/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.value;

public final class Cardinality {
    private Cardinality() {
    }

    public static final boolean allowsMany(int n2) {
        return (n2 & 0x8000) != 0;
    }

    public static final boolean allowsZero(int n2) {
        return (n2 & 0x2000) != 0;
    }

    public static final int union(int n2, int n3) {
        int n4 = n2 | n3;
        if (n4 == 40960) {
            n4 = 57344;
        }
        return n4;
    }

    public static final int sum(int n2, int n3) {
        if (n2 == 0) {
            return n3;
        }
        if (n3 == 0) {
            return n2;
        }
        if (Cardinality.allowsMany(n2) || Cardinality.allowsMany(n3)) {
            return n2 | n3;
        }
        if (!Cardinality.allowsZero(n2) && !Cardinality.allowsZero(n3)) {
            return 49152;
        }
        return 57344;
    }

    public static final boolean subsumes(int n2, int n3) {
        return (n2 | n3) == n2;
    }

    public static final int add(int n2, int n3) {
        if (n2 == 8192) {
            return n3;
        }
        if (n3 == 8192) {
            return n2;
        }
        boolean bl = Cardinality.allowsZero(n2) && Cardinality.allowsZero(n3);
        return 0xC000 | (bl ? 8192 : 0);
    }

    public static final int multiply(int n2, int n3) {
        if (n2 == 8192 || n3 == 8192) {
            return 8192;
        }
        if (n3 == 16384) {
            return n2;
        }
        if (n2 == 16384) {
            return n3;
        }
        if (n2 == 24576 && n3 == 24576) {
            return 24576;
        }
        if (n2 == 49152 && n3 == 49152) {
            return 49152;
        }
        return 57344;
    }

    public static String toString(int n2) {
        switch (n2) {
            case 24576: {
                return "zero or one";
            }
            case 16384: {
                return "exactly one";
            }
            case 57344: {
                return "zero or more";
            }
            case 49152: {
                return "one or more";
            }
            case 8192: {
                return "exactly zero";
            }
            case 32768: {
                return "more than one";
            }
        }
        return "code " + n2;
    }

    public static String getOccurrenceIndicator(int n2) {
        switch (n2) {
            case 24576: {
                return "?";
            }
            case 16384: {
                return "";
            }
            case 57344: {
                return "*";
            }
            case 49152: {
                return "+";
            }
        }
        throw new AssertionError((Object)"unknown cardinality value");
    }
}

