/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.value;

import java.math.BigDecimal;
import java.util.GregorianCalendar;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.om.FastStringBuffer;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.value.AtomicValue;
import net.sf.saxon.value.DateTimeValue;
import net.sf.saxon.value.DurationValue;
import net.sf.saxon.value.SecondsDurationValue;

public abstract class CalendarValue
extends AtomicValue
implements Comparable {
    private int tzMinutes = 9999999;
    public static final int NO_TIMEZONE = 9999999;

    public final boolean hasTimezone() {
        return this.tzMinutes != 9999999;
    }

    public final void setTimezoneInMinutes(int n2) {
        this.tzMinutes = n2;
    }

    public abstract DateTimeValue toDateTime();

    public final int getTimezoneInMinutes() {
        return this.tzMinutes;
    }

    public final String getStringValue() {
        return ((Object)this.getStringValueCS()).toString();
    }

    public abstract GregorianCalendar getCalendar();

    public abstract CalendarValue add(DurationValue var1) throws XPathException;

    public SecondsDurationValue subtract(CalendarValue calendarValue, XPathContext xPathContext) throws XPathException {
        DateTimeValue dateTimeValue = this.toDateTime();
        DateTimeValue dateTimeValue2 = calendarValue.toDateTime();
        if (dateTimeValue.getTimezoneInMinutes() != dateTimeValue2.getTimezoneInMinutes()) {
            dateTimeValue = dateTimeValue.normalize(xPathContext);
            dateTimeValue2 = dateTimeValue2.normalize(xPathContext);
        }
        BigDecimal bigDecimal = dateTimeValue.toJulianInstant();
        BigDecimal bigDecimal2 = dateTimeValue2.toJulianInstant();
        BigDecimal bigDecimal3 = bigDecimal.subtract(bigDecimal2);
        return SecondsDurationValue.fromSeconds(bigDecimal3);
    }

    public final CalendarValue removeTimezone() {
        CalendarValue calendarValue = this.copy();
        calendarValue.tzMinutes = 9999999;
        return calendarValue;
    }

    public abstract CalendarValue adjustTimezone(int var1);

    public abstract CalendarValue copy();

    public abstract int compareTo(CalendarValue var1, XPathContext var2);

    public final void appendTimezone(FastStringBuffer fastStringBuffer) {
        if (this.hasTimezone()) {
            CalendarValue.appendTimezone(this.getTimezoneInMinutes(), fastStringBuffer);
        }
    }

    public static final void appendTimezone(int n2, FastStringBuffer fastStringBuffer) {
        if (n2 == 0) {
            fastStringBuffer.append("Z");
        } else {
            fastStringBuffer.append(n2 > 0 ? "+" : "-");
            n2 = Math.abs(n2);
            CalendarValue.appendTwoDigits(fastStringBuffer, n2 / 60);
            fastStringBuffer.append(':');
            CalendarValue.appendTwoDigits(fastStringBuffer, n2 % 60);
        }
    }

    static void appendString(FastStringBuffer fastStringBuffer, int n2, int n3) {
        String string = "000000000" + n2;
        fastStringBuffer.append(string.substring(string.length() - n3));
    }

    static void appendTwoDigits(FastStringBuffer fastStringBuffer, int n2) {
        fastStringBuffer.append((char)(n2 / 10 + 48));
        fastStringBuffer.append((char)(n2 % 10 + 48));
    }
}

