/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.type;

import javax.xml.transform.SourceLocator;
import net.sf.saxon.trans.XPathException;
import org.xml.sax.Locator;

public class ValidationException
extends XPathException
implements SourceLocator,
Locator {
    private String systemId;
    private String publicId;
    private int lineNumber = -1;
    private int columnNumber = -1;
    private int schemaPart = -1;
    private String constraintName;
    private String constraintClauseNumber;

    public ValidationException(String string) {
        super(string);
        this.setIsTypeError(true);
    }

    public ValidationException(Exception exception) {
        super(exception);
        this.setIsTypeError(true);
    }

    public ValidationException(String string, Exception exception) {
        super(string, exception);
        this.setIsTypeError(true);
    }

    public ValidationException(String string, SourceLocator sourceLocator) {
        super(string, sourceLocator);
        this.setIsTypeError(true);
        this.setSourceLocator(sourceLocator);
    }

    public void setConstraintReference(int n2, String string, String string2) {
        this.schemaPart = n2;
        this.constraintName = string;
        this.constraintClauseNumber = string2;
    }

    public String getConstraintReferenceMessage() {
        if (this.schemaPart == -1) {
            return null;
        }
        return "See http://www.w3.org/TR/xmlschema-" + this.schemaPart + "/#" + this.constraintName + " clause " + this.constraintClauseNumber;
    }

    public int getConstraintSchemaPart() {
        return this.schemaPart;
    }

    public String getConstraintName() {
        return this.constraintName;
    }

    public String getConstraintClauseNumber() {
        return this.constraintClauseNumber;
    }

    public String getConstraintReference() {
        return this.constraintName + '.' + this.constraintClauseNumber;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer("ValidationException: ");
        String string = this.getMessage();
        if (string != null) {
            stringBuffer.append(string);
        }
        return stringBuffer.toString();
    }

    public String getPublicId() {
        if (this.publicId == null && this.getLocator() != this) {
            return this.getLocator().getPublicId();
        }
        return this.publicId;
    }

    public String getSystemId() {
        if (this.systemId == null && this.getLocator() != this) {
            return this.getLocator().getSystemId();
        }
        return this.systemId;
    }

    public int getLineNumber() {
        if (this.lineNumber == -1 && this.getLocator() != this) {
            return this.getLocator().getLineNumber();
        }
        return this.lineNumber;
    }

    public int getColumnNumber() {
        if (this.columnNumber == -1 && this.getLocator() != this) {
            return this.getLocator().getColumnNumber();
        }
        return this.columnNumber;
    }

    public void setPublicId(String string) {
        this.publicId = string;
    }

    public void setSystemId(String string) {
        this.systemId = string;
    }

    public void setLineNumber(int n2) {
        this.lineNumber = n2;
    }

    public void setColumnNumber(int n2) {
        this.columnNumber = n2;
    }

    public void setLocator(Locator locator) {
        this.setPublicId(locator.getPublicId());
        this.setSystemId(locator.getSystemId());
        this.setLineNumber(locator.getLineNumber());
        this.setColumnNumber(locator.getColumnNumber());
        super.setLocator(null);
    }

    public void setSourceLocator(SourceLocator sourceLocator) {
        this.setPublicId(sourceLocator.getPublicId());
        this.setSystemId(sourceLocator.getSystemId());
        this.setLineNumber(sourceLocator.getLineNumber());
        this.setColumnNumber(sourceLocator.getColumnNumber());
        super.setLocator(null);
    }

    public SourceLocator getLocator() {
        SourceLocator sourceLocator = super.getLocator();
        if (sourceLocator != null) {
            return sourceLocator;
        }
        return this;
    }
}

