/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.tree;

import javax.xml.transform.SourceLocator;
import net.sf.saxon.Configuration;
import net.sf.saxon.event.Receiver;
import net.sf.saxon.om.AxisIterator;
import net.sf.saxon.om.DocumentInfo;
import net.sf.saxon.om.EmptyIterator;
import net.sf.saxon.om.FastStringBuffer;
import net.sf.saxon.om.FingerprintedNode;
import net.sf.saxon.om.NamePool;
import net.sf.saxon.om.NamespaceIterator;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.om.SingletonIterator;
import net.sf.saxon.pattern.AnyNodeTest;
import net.sf.saxon.pattern.NameTest;
import net.sf.saxon.pattern.NodeTest;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.tree.AncestorEnumeration;
import net.sf.saxon.tree.AttributeEnumeration;
import net.sf.saxon.tree.DescendantEnumeration;
import net.sf.saxon.tree.DocumentImpl;
import net.sf.saxon.tree.FollowingEnumeration;
import net.sf.saxon.tree.FollowingSiblingEnumeration;
import net.sf.saxon.tree.ParentNodeImpl;
import net.sf.saxon.tree.PrecedingEnumeration;
import net.sf.saxon.tree.PrecedingOrAncestorEnumeration;
import net.sf.saxon.tree.PrecedingSiblingEnumeration;
import net.sf.saxon.value.UntypedAtomicValue;
import net.sf.saxon.value.Value;

public abstract class NodeImpl
implements NodeInfo,
FingerprintedNode,
SourceLocator {
    protected ParentNodeImpl parent;
    protected int index;
    public static final char[] NODE_LETTER = new char[]{'x', 'e', 'a', 't', 'x', 'x', 'x', 'p', 'c', 'r', 'x', 'x', 'x', 'n'};

    public CharSequence getStringValueCS() {
        return this.getStringValue();
    }

    public int getTypeAnnotation() {
        return 641;
    }

    public int getColumnNumber() {
        return -1;
    }

    public String getPublicId() {
        return null;
    }

    public int getDocumentNumber() {
        return this.getRoot().getDocumentNumber();
    }

    public SequenceIterator getTypedValue() throws XPathException {
        return SingletonIterator.makeIterator(new UntypedAtomicValue(this.getStringValue()));
    }

    public Value atomize() throws XPathException {
        return new UntypedAtomicValue(this.getStringValue());
    }

    public void setSystemId(String string) {
        this.getParent().setSystemId(string);
    }

    public boolean isSameNodeInfo(NodeInfo nodeInfo) {
        return this == nodeInfo;
    }

    public boolean equals(Object object) {
        if (object instanceof NodeInfo) {
            return this.isSameNodeInfo((NodeInfo)object);
        }
        return false;
    }

    public int hashCode() {
        FastStringBuffer fastStringBuffer = new FastStringBuffer(20);
        this.generateId(fastStringBuffer);
        return fastStringBuffer.toString().hashCode();
    }

    public int getNameCode() {
        return -1;
    }

    public int getFingerprint() {
        int n2 = this.getNameCode();
        if (n2 == -1) {
            return -1;
        }
        return n2 & 0xFFFFF;
    }

    public void generateId(FastStringBuffer fastStringBuffer) {
        this.getDocumentRoot().generateId(fastStringBuffer);
        fastStringBuffer.append(NODE_LETTER[this.getNodeKind()]);
        fastStringBuffer.append(Long.toString(this.getSequenceNumber()));
    }

    public String getSystemId() {
        return this.parent.getSystemId();
    }

    public String getBaseURI() {
        return this.parent.getBaseURI();
    }

    protected long getSequenceNumber() {
        NodeImpl nodeImpl = this;
        int n2 = 0;
        while (!(nodeImpl instanceof ParentNodeImpl)) {
            nodeImpl = nodeImpl.getPreviousInDocument();
            ++n2;
        }
        return nodeImpl.getSequenceNumber() + 65536L + (long)n2;
    }

    public final int compareOrder(NodeInfo nodeInfo) {
        long l2;
        if (nodeInfo instanceof NamespaceIterator.NamespaceNodeImpl) {
            return 0 - nodeInfo.compareOrder(this);
        }
        long l3 = this.getSequenceNumber();
        if (l3 < (l2 = ((NodeImpl)nodeInfo).getSequenceNumber())) {
            return -1;
        }
        if (l3 > l2) {
            return 1;
        }
        return 0;
    }

    public Configuration getConfiguration() {
        return this.getDocumentRoot().getConfiguration();
    }

    public NamePool getNamePool() {
        return this.getDocumentRoot().getNamePool();
    }

    public String getPrefix() {
        int n2 = this.getNameCode();
        if (n2 == -1) {
            return "";
        }
        if (NamePool.getPrefixIndex(n2) == 0) {
            return "";
        }
        return this.getNamePool().getPrefix(n2);
    }

    public String getURI() {
        int n2 = this.getNameCode();
        if (n2 == -1) {
            return "";
        }
        return this.getNamePool().getURI(n2);
    }

    public String getDisplayName() {
        int n2 = this.getNameCode();
        if (n2 == -1) {
            return "";
        }
        return this.getNamePool().getDisplayName(n2);
    }

    public String getLocalPart() {
        int n2 = this.getNameCode();
        if (n2 == -1) {
            return "";
        }
        return this.getNamePool().getLocalName(n2);
    }

    public int getLineNumber() {
        return this.parent.getLineNumber();
    }

    public final NodeInfo getParent() {
        return this.parent;
    }

    public NodeInfo getPreviousSibling() {
        return this.parent.getNthChild(this.index - 1);
    }

    public NodeInfo getNextSibling() {
        return this.parent.getNthChild(this.index + 1);
    }

    public NodeInfo getFirstChild() {
        return null;
    }

    public NodeInfo getLastChild() {
        return null;
    }

    public AxisIterator iterateAxis(byte by) {
        if (by == 3) {
            if (this instanceof ParentNodeImpl) {
                return ((ParentNodeImpl)this).enumerateChildren(null);
            }
            return EmptyIterator.getInstance();
        }
        return this.iterateAxis(by, AnyNodeTest.getInstance());
    }

    public AxisIterator iterateAxis(byte by, NodeTest nodeTest) {
        switch (by) {
            case 0: {
                return new AncestorEnumeration(this, nodeTest, false);
            }
            case 1: {
                return new AncestorEnumeration(this, nodeTest, true);
            }
            case 2: {
                if (this.getNodeKind() != 1) {
                    return EmptyIterator.getInstance();
                }
                return new AttributeEnumeration(this, nodeTest);
            }
            case 3: {
                if (this instanceof ParentNodeImpl) {
                    return ((ParentNodeImpl)this).enumerateChildren(nodeTest);
                }
                return EmptyIterator.getInstance();
            }
            case 4: {
                if (this.getNodeKind() == 9 && nodeTest instanceof NameTest && nodeTest.getPrimitiveType() == 1) {
                    return ((DocumentImpl)this).getAllElements(nodeTest.getFingerprint());
                }
                if (this.hasChildNodes()) {
                    return new DescendantEnumeration(this, nodeTest, false);
                }
                return EmptyIterator.getInstance();
            }
            case 5: {
                return new DescendantEnumeration(this, nodeTest, true);
            }
            case 6: {
                return new FollowingEnumeration(this, nodeTest);
            }
            case 7: {
                return new FollowingSiblingEnumeration(this, nodeTest);
            }
            case 8: {
                if (this.getNodeKind() != 1) {
                    return EmptyIterator.getInstance();
                }
                return new NamespaceIterator(this, nodeTest);
            }
            case 9: {
                NodeInfo nodeInfo = this.getParent();
                if (nodeInfo == null) {
                    return EmptyIterator.getInstance();
                }
                if (nodeTest.matches(nodeInfo)) {
                    return SingletonIterator.makeIterator(nodeInfo);
                }
                return EmptyIterator.getInstance();
            }
            case 10: {
                return new PrecedingEnumeration(this, nodeTest);
            }
            case 11: {
                return new PrecedingSiblingEnumeration(this, nodeTest);
            }
            case 12: {
                if (nodeTest.matches(this)) {
                    return SingletonIterator.makeIterator(this);
                }
                return EmptyIterator.getInstance();
            }
            case 13: {
                return new PrecedingOrAncestorEnumeration(this, nodeTest);
            }
        }
        throw new IllegalArgumentException("Unknown axis number " + by);
    }

    public String getAttributeValue(int n2) {
        return null;
    }

    public NodeInfo getRoot() {
        return this.getDocumentRoot();
    }

    public DocumentInfo getDocumentRoot() {
        return this.getParent().getDocumentRoot();
    }

    public NodeImpl getNextInDocument(NodeImpl nodeImpl) {
        NodeImpl nodeImpl2 = (NodeImpl)this.getFirstChild();
        if (nodeImpl2 != null) {
            return nodeImpl2;
        }
        if (this == nodeImpl) {
            return null;
        }
        nodeImpl2 = (NodeImpl)this.getNextSibling();
        if (nodeImpl2 != null) {
            return nodeImpl2;
        }
        NodeImpl nodeImpl3 = this;
        do {
            if ((nodeImpl3 = (NodeImpl)nodeImpl3.getParent()) == null) {
                return null;
            }
            if (nodeImpl3 != nodeImpl) continue;
            return null;
        } while ((nodeImpl2 = (NodeImpl)nodeImpl3.getNextSibling()) == null);
        return nodeImpl2;
    }

    public NodeImpl getPreviousInDocument() {
        NodeImpl nodeImpl = (NodeImpl)this.getPreviousSibling();
        if (nodeImpl != null) {
            return nodeImpl.getLastDescendantOrSelf();
        }
        return (NodeImpl)this.getParent();
    }

    private NodeImpl getLastDescendantOrSelf() {
        NodeImpl nodeImpl = (NodeImpl)this.getLastChild();
        if (nodeImpl == null) {
            return this;
        }
        return nodeImpl.getLastDescendantOrSelf();
    }

    public void sendNamespaceDeclarations(Receiver receiver, boolean bl) throws XPathException {
    }

    public int[] getDeclaredNamespaces(int[] nArray) {
        return null;
    }

    public boolean hasChildNodes() {
        return this.getFirstChild() != null;
    }
}

