/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.trans;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Iterator;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.instruct.Template;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.pattern.Pattern;
import net.sf.saxon.pattern.UnionPattern;
import net.sf.saxon.trans.Mode;
import net.sf.saxon.trans.Rule;
import net.sf.saxon.trans.XPathException;

public final class RuleManager
implements Serializable {
    private Mode defaultMode;
    private HashMap modes;
    private Mode omniMode = null;

    public RuleManager() {
        this.resetHandlers();
    }

    public void resetHandlers() {
        this.defaultMode = new Mode(-1);
        this.modes = new HashMap(5);
    }

    public Mode getDefaultMode() {
        return this.defaultMode;
    }

    public Mode getMode(int n2) {
        if (n2 == -1) {
            return this.defaultMode;
        }
        if (n2 == -2) {
            if (this.omniMode == null) {
                this.omniMode = new Mode(-3);
            }
            return this.omniMode;
        }
        Integer n3 = new Integer(n2 & 0xFFFFF);
        Mode mode = (Mode)this.modes.get(n3);
        if (mode == null) {
            mode = new Mode(this.omniMode);
            this.modes.put(n3, mode);
        }
        return mode;
    }

    public void setHandler(Pattern pattern, Template template, Mode mode, int n2) {
        if (pattern instanceof UnionPattern) {
            UnionPattern unionPattern = (UnionPattern)pattern;
            Pattern pattern2 = unionPattern.getLHS();
            Pattern pattern3 = unionPattern.getRHS();
            this.setHandler(pattern2, template, mode, n2);
            this.setHandler(pattern3, template, mode, n2);
            return;
        }
        double d2 = pattern.getDefaultPriority();
        this.setHandler(pattern, template, mode, n2, d2);
    }

    public void setHandler(Pattern pattern, Template template, Mode mode, int n2, double d2) {
        if (pattern instanceof UnionPattern) {
            UnionPattern unionPattern = (UnionPattern)pattern;
            Pattern pattern2 = unionPattern.getLHS();
            Pattern pattern3 = unionPattern.getRHS();
            this.setHandler(pattern2, template, mode, n2, d2);
            this.setHandler(pattern3, template, mode, n2, d2);
            return;
        }
        mode.addRule(pattern, template, n2, d2);
        if (mode == this.omniMode) {
            this.defaultMode.addRule(pattern, template, n2, d2);
            Iterator iterator = this.modes.values().iterator();
            while (iterator.hasNext()) {
                Mode mode2 = (Mode)iterator.next();
                mode2.addRule(pattern, template, n2, d2);
            }
        }
    }

    public Rule getTemplateRule(NodeInfo nodeInfo, Mode mode, XPathContext xPathContext) throws XPathException {
        if (mode == null) {
            mode = this.defaultMode;
        }
        return mode.getRule(nodeInfo, xPathContext);
    }

    public Rule getTemplateRule(NodeInfo nodeInfo, Mode mode, int n2, int n3, XPathContext xPathContext) throws XPathException {
        if (mode == null) {
            mode = this.defaultMode;
        }
        return mode.getRule(nodeInfo, n2, n3, xPathContext);
    }

    public Rule getNextMatchHandler(NodeInfo nodeInfo, Mode mode, Rule rule, XPathContext xPathContext) throws XPathException {
        if (mode == null) {
            mode = this.defaultMode;
        }
        return mode.getNextMatchRule(nodeInfo, rule, xPathContext);
    }
}

