/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.tinytree;

import net.sf.saxon.om.FastStringBuffer;
import net.sf.saxon.tinytree.TinyNodeImpl;
import net.sf.saxon.tinytree.TinyTextImpl;
import net.sf.saxon.tinytree.TinyTree;
import net.sf.saxon.tinytree.WhitespaceTextImpl;

abstract class TinyParentNodeImpl
extends TinyNodeImpl {
    TinyParentNodeImpl() {
    }

    public final boolean hasChildNodes() {
        return this.nodeNr + 1 < this.tree.numberOfNodes && this.tree.depth[this.nodeNr + 1] > this.tree.depth[this.nodeNr];
    }

    public final String getStringValue() {
        return ((Object)TinyParentNodeImpl.getStringValue(this.tree, this.nodeNr)).toString();
    }

    public CharSequence getStringValueCS() {
        return TinyParentNodeImpl.getStringValue(this.tree, this.nodeNr);
    }

    public static final CharSequence getStringValue(TinyTree tinyTree, int n2) {
        int n3 = n2 + 1;
        short s2 = tinyTree.depth[n2];
        if (tinyTree.depth[n3] <= s2) {
            return "";
        }
        if (tinyTree.nodeKind[n3] == 3 && (n3 + 1 >= tinyTree.numberOfNodes || tinyTree.depth[n3 + 1] <= s2)) {
            return TinyTextImpl.getStringValue(tinyTree, n3);
        }
        FastStringBuffer fastStringBuffer = null;
        while (n3 < tinyTree.numberOfNodes && tinyTree.depth[n3] > s2) {
            byte by = tinyTree.nodeKind[n3];
            if (by == 3) {
                if (fastStringBuffer == null) {
                    fastStringBuffer = new FastStringBuffer(1024);
                }
                fastStringBuffer.append(TinyTextImpl.getStringValue(tinyTree, n3));
            } else if (by == 4) {
                if (fastStringBuffer == null) {
                    fastStringBuffer = new FastStringBuffer(1024);
                }
                fastStringBuffer.append(WhitespaceTextImpl.getStringValue(tinyTree, n3));
            }
            ++n3;
        }
        if (fastStringBuffer == null) {
            return "";
        }
        return fastStringBuffer.condense();
    }
}

