/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.tinytree;

import net.sf.saxon.om.AxisIteratorImpl;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.pattern.NodeTest;
import net.sf.saxon.tinytree.TinyNodeImpl;
import net.sf.saxon.tinytree.TinyTree;

final class PrecedingEnumeration
extends AxisIteratorImpl {
    private TinyTree tree;
    private TinyNodeImpl startNode;
    private NodeTest test;
    private int nextAncestorDepth;
    private boolean includeAncestors;

    public PrecedingEnumeration(TinyTree tinyTree, TinyNodeImpl tinyNodeImpl, NodeTest nodeTest, boolean bl) {
        this.includeAncestors = bl;
        this.test = nodeTest;
        this.tree = tinyTree;
        this.startNode = tinyNodeImpl;
        this.current = this.startNode;
        this.nextAncestorDepth = tinyTree.depth[tinyNodeImpl.nodeNr] - 1;
    }

    public Item next() {
        int n2 = ((TinyNodeImpl)this.current).nodeNr;
        do {
            --n2;
            if (!this.includeAncestors) {
                while (this.nextAncestorDepth >= 0 && this.tree.depth[n2] == this.nextAncestorDepth) {
                    if (this.nextAncestorDepth-- <= 0) {
                        this.current = null;
                        this.position = -1;
                        return null;
                    }
                    --n2;
                }
            } else if (this.tree.depth[n2] == 0) {
                this.current = null;
                this.position = -1;
                return null;
            }
            if (!this.test.matches(this.tree, n2)) continue;
            ++this.position;
            this.current = this.tree.getNode(n2);
            return this.current;
        } while (this.tree.depth[n2] != 0);
        this.current = null;
        this.position = -1;
        return null;
    }

    public SequenceIterator getAnother() {
        return new PrecedingEnumeration(this.tree, this.startNode, this.test, this.includeAncestors);
    }
}

