/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.tinytree;

import java.io.IOException;
import java.io.Writer;
import net.sf.saxon.om.FastStringBuffer;

public class CompressedWhitespace
implements CharSequence {
    private static char[] WHITE_CHARS = new char[]{'\t', '\n', '\r', ' '};
    private long value;

    public CompressedWhitespace(long l2) {
        this.value = l2;
    }

    public static CharSequence compress(CharSequence charSequence) {
        int n2;
        int n3;
        int n4 = charSequence.length();
        if (n4 == 0) {
            return charSequence;
        }
        int n5 = 1;
        int n6 = 0;
        for (n3 = 0; n3 < n4; ++n3) {
            char c2 = charSequence.charAt(n3);
            if ("\t\n\r ".indexOf(c2) >= 0) {
                if (n3 == n4 - 1 || c2 != charSequence.charAt(n3 + 1) || n5 == 63) {
                    n5 = 1;
                    if (++n6 <= 8) continue;
                    return charSequence;
                }
                ++n5;
                continue;
            }
            return charSequence;
        }
        n3 = 0;
        n5 = 1;
        int[] nArray = new int[n6];
        for (int i2 = 0; i2 < n4; ++i2) {
            char c3 = charSequence.charAt(i2);
            if (i2 == n4 - 1 || c3 != charSequence.charAt(i2 + 1) || n5 == 63) {
                n2 = "\t\n\r ".indexOf(c3);
                nArray[n3++] = n2 << 6 | n5;
                n5 = 1;
                continue;
            }
            ++n5;
        }
        long l2 = 0L;
        for (n2 = 0; n2 < n6; ++n2) {
            l2 = l2 << 8 | (long)nArray[n2];
        }
        return new CompressedWhitespace(l2 <<= 8 * (8 - n6));
    }

    public FastStringBuffer uncompress(FastStringBuffer fastStringBuffer) {
        byte by;
        if (fastStringBuffer == null) {
            fastStringBuffer = new FastStringBuffer(this.length());
        }
        long l2 = this.value;
        for (int i2 = 56; i2 >= 0 && (by = (byte)(l2 >>> i2 & 0xFFL)) != 0; i2 -= 8) {
            char c2 = WHITE_CHARS[by >>> 6 & 3];
            int n2 = by & 0x3F;
            for (int i3 = 0; i3 < n2; ++i3) {
                fastStringBuffer.append(c2);
            }
        }
        return fastStringBuffer;
    }

    public long getCompressedValue() {
        return this.value;
    }

    public int length() {
        int n2;
        int n3 = 0;
        long l2 = this.value;
        for (int i2 = 56; i2 >= 0 && (n2 = (int)(l2 >>> i2 & 0x3FL)) != 0; i2 -= 8) {
            n3 += n2;
        }
        return n3;
    }

    public char charAt(int n2) {
        byte by;
        int n3 = 0;
        long l2 = this.value;
        for (int i2 = 56; i2 >= 0 && (by = (byte)(l2 >>> i2 & 0xFFL)) != 0; i2 -= 8) {
            if ((n3 += by & 0x3F) <= n2) continue;
            return WHITE_CHARS[by >>> 6 & 3];
        }
        throw new IndexOutOfBoundsException(n2 + "");
    }

    public CharSequence subSequence(int n2, int n3) {
        return this.uncompress(null).subSequence(n2, n3);
    }

    public boolean equals(Object object) {
        if (object instanceof CompressedWhitespace) {
            return this.value == ((CompressedWhitespace)object).value;
        }
        return this.uncompress(null).equals(object);
    }

    public int hashCode() {
        return this.uncompress(null).hashCode();
    }

    public String toString() {
        return this.uncompress(null).toString();
    }

    public void write(Writer writer) throws IOException {
        byte by;
        long l2 = this.value;
        for (int i2 = 56; i2 >= 0 && (by = (byte)(l2 >>> i2 & 0xFFL)) != 0; i2 -= 8) {
            char c2 = WHITE_CHARS[by >>> 6 & 3];
            int n2 = by & 0x3F;
            for (int i3 = 0; i3 < n2; ++i3) {
                writer.write(c2);
            }
        }
    }

    public void writeEscape(boolean[] blArray, Writer writer) throws IOException {
        byte by;
        long l2 = this.value;
        for (int i2 = 56; i2 >= 0 && (by = (byte)(l2 >>> i2 & 0xFFL)) != 0; i2 -= 8) {
            char c2 = WHITE_CHARS[by >>> 6 & 3];
            int n2 = by & 0x3F;
            if (blArray[c2]) {
                String string = "";
                if (c2 == '\n') {
                    string = "&#xA;";
                } else if (c2 == '\r') {
                    string = "&#xD;";
                } else if (c2 == '\t') {
                    string = "&#x9;";
                }
                for (int i3 = 0; i3 < n2; ++i3) {
                    writer.write(string);
                }
                continue;
            }
            for (int i4 = 0; i4 < n2; ++i4) {
                writer.write(c2);
            }
        }
    }

    public static void main(String[] stringArray) {
        CharSequence charSequence = CompressedWhitespace.compress("\t\n\n\t\t\n      ");
        System.err.println(charSequence);
    }
}

