/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.tinytree;

import java.io.IOException;
import java.io.Serializable;
import java.io.Writer;

public final class CharSlice
implements CharSequence,
Serializable {
    private char[] array;
    private int offset;
    private int count;

    public CharSlice(char[] cArray) {
        this.array = cArray;
        this.offset = 0;
        this.count = cArray.length;
    }

    public CharSlice(char[] cArray, int n2, int n3) {
        this.array = cArray;
        this.offset = n2;
        this.count = n3;
        if (n2 + n3 > cArray.length) {
            throw new IndexOutOfBoundsException("start(" + n2 + ") + length(" + n3 + ") > size(" + cArray.length + ')');
        }
    }

    public int length() {
        return this.count;
    }

    public void setLength(int n2) {
        this.count = n2;
    }

    public char charAt(int n2) {
        return this.array[this.offset + n2];
    }

    public CharSequence subSequence(int n2, int n3) {
        return new CharSlice(this.array, this.offset + n2, n3 - n2);
    }

    public String toString() {
        return new String(this.array, this.offset, this.count);
    }

    public boolean equals(Object object) {
        return this.toString().equals(object);
    }

    public int hashCode() {
        int n2 = this.offset + this.count;
        int n3 = 0;
        for (int i2 = this.offset; i2 < n2; ++i2) {
            n3 = 31 * n3 + this.array[i2];
        }
        return n3;
    }

    public int indexOf(char c2) {
        int n2 = this.offset + this.count;
        for (int i2 = this.offset; i2 < n2; ++i2) {
            if (this.array[i2] != c2) continue;
            return i2 - this.offset;
        }
        return -1;
    }

    public String substring(int n2, int n3) {
        return new String(this.array, this.offset + n2, n3 - n2);
    }

    public void copyTo(char[] cArray, int n2) {
        System.arraycopy(this.array, this.offset, cArray, n2, this.count);
    }

    public void write(Writer writer) throws IOException {
        writer.write(this.array, this.offset, this.count);
    }
}

