/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.tinytree;

import net.sf.saxon.om.AxisIteratorImpl;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.pattern.NameTest;
import net.sf.saxon.pattern.NodeTest;
import net.sf.saxon.tinytree.TinyTree;
import net.sf.saxon.value.UntypedAtomicValue;

final class AttributeEnumeration
extends AxisIteratorImpl {
    private TinyTree tree;
    private int element;
    private NodeTest nodeTest;
    private int index;

    AttributeEnumeration(TinyTree tinyTree, int n2, NodeTest nodeTest) {
        this.nodeTest = nodeTest;
        this.tree = tinyTree;
        this.element = n2;
        this.index = tinyTree.alpha[n2];
    }

    public Item next() {
        while (true) {
            if (this.index >= this.tree.numberOfAttributes || this.tree.attParent[this.index] != this.element) {
                this.index = Integer.MAX_VALUE;
                this.current = null;
                this.position = -1;
                return null;
            }
            int n2 = this.tree.getAttributeAnnotation(this.index);
            if ((n2 & 0x40000000) != 0) {
                n2 = 642;
            }
            if (this.nodeTest.matches(2, this.tree.attCode[this.index], n2)) {
                ++this.position;
                int n3 = this.index++;
                if (this.nodeTest instanceof NameTest) {
                    this.index = Integer.MAX_VALUE;
                }
                if (this.isAtomizing() && n2 == 642) {
                    this.current = new UntypedAtomicValue(this.tree.attValue[n3]);
                    return this.current;
                }
                this.current = this.tree.getAttributeNode(n3);
                return this.current;
            }
            ++this.index;
        }
    }

    public SequenceIterator getAnother() {
        return new AttributeEnumeration(this.tree, this.element, this.nodeTest);
    }
}

