/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.style;

import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.ExpressionLocation;
import net.sf.saxon.expr.ExpressionTool;
import net.sf.saxon.expr.RoleLocator;
import net.sf.saxon.expr.TypeChecker;
import net.sf.saxon.instruct.Executable;
import net.sf.saxon.instruct.NumberInstruction;
import net.sf.saxon.instruct.ValueOf;
import net.sf.saxon.number.NumberFormatter;
import net.sf.saxon.number.Numberer;
import net.sf.saxon.number.Numberer_en;
import net.sf.saxon.om.AttributeCollection;
import net.sf.saxon.pattern.NodeKindTest;
import net.sf.saxon.pattern.Pattern;
import net.sf.saxon.style.StyleElement;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.type.ItemType;
import net.sf.saxon.value.SequenceType;
import net.sf.saxon.value.StringValue;

public class XSLNumber
extends StyleElement {
    private static final int SINGLE = 0;
    private static final int MULTI = 1;
    private static final int ANY = 2;
    private static final int SIMPLE = 3;
    private int level;
    private Pattern count = null;
    private Pattern from = null;
    private Expression select = null;
    private Expression value = null;
    private Expression format = null;
    private Expression groupSize = null;
    private Expression groupSeparator = null;
    private Expression letterValue = null;
    private Expression lang = null;
    private Expression ordinal = null;
    private NumberFormatter formatter = null;
    private Numberer numberer = null;
    private boolean hasVariablesInPatterns = false;
    private static Numberer defaultNumberer = new Numberer_en();

    public boolean isInstruction() {
        return true;
    }

    protected ItemType getReturnedItemType() {
        return NodeKindTest.TEXT;
    }

    public void prepareAttributes() throws XPathException {
        AttributeCollection attributeCollection = this.getAttributeList();
        String string = null;
        String string2 = null;
        String string3 = null;
        String string4 = null;
        String string5 = null;
        String string6 = null;
        String string7 = null;
        String string8 = null;
        String string9 = null;
        String string10 = null;
        String string11 = null;
        for (int i2 = 0; i2 < attributeCollection.getLength(); ++i2) {
            int n2 = attributeCollection.getNameCode(i2);
            String string12 = this.getNamePool().getClarkName(n2);
            if (string12 == "select") {
                string = attributeCollection.getValue(i2);
                continue;
            }
            if (string12 == "value") {
                string2 = attributeCollection.getValue(i2);
                continue;
            }
            if (string12 == "count") {
                string3 = attributeCollection.getValue(i2);
                continue;
            }
            if (string12 == "from") {
                string4 = attributeCollection.getValue(i2);
                continue;
            }
            if (string12 == "level") {
                string5 = attributeCollection.getValue(i2).trim();
                continue;
            }
            if (string12 == "format") {
                string6 = attributeCollection.getValue(i2);
                continue;
            }
            if (string12 == "lang") {
                string9 = attributeCollection.getValue(i2);
                continue;
            }
            if (string12 == "letter-value") {
                string10 = attributeCollection.getValue(i2).trim();
                continue;
            }
            if (string12 == "grouping-size") {
                string7 = attributeCollection.getValue(i2).trim();
                continue;
            }
            if (string12 == "grouping-separator") {
                string8 = attributeCollection.getValue(i2);
                continue;
            }
            if (string12 == "ordinal") {
                string11 = attributeCollection.getValue(i2);
                continue;
            }
            this.checkUnknownAttribute(n2);
        }
        if (string != null) {
            this.select = this.makeExpression(string);
        }
        if (string2 != null) {
            this.value = this.makeExpression(string2);
            if (string != null) {
                this.compileError("The select attribute and value attribute must not both be present", "XTSE0975");
            }
            if (string3 != null) {
                this.compileError("The count attribute and value attribute must not both be present", "XTSE0975");
            }
            if (string4 != null) {
                this.compileError("The from attribute and value attribute must not both be present", "XTSE0975");
            }
            if (string5 != null) {
                this.compileError("The level attribute and value attribute must not both be present", "XTSE0975");
            }
        }
        if (string3 != null) {
            this.count = this.makePattern(string3);
            if (string3.indexOf(36) >= 0) {
                this.hasVariablesInPatterns = true;
            }
        }
        if (string4 != null) {
            this.from = this.makePattern(string4);
            if (string4.indexOf(36) >= 0) {
                this.hasVariablesInPatterns = true;
            }
        }
        if (string5 == null) {
            this.level = 0;
        } else if (string5.equals("single")) {
            this.level = 0;
        } else if (string5.equals("multiple")) {
            this.level = 1;
        } else if (string5.equals("any")) {
            this.level = 2;
        } else {
            this.compileError("Invalid value for level attribute", "XTSE0020");
        }
        if (this.level == 0 && this.from == null && this.count == null) {
            this.level = 3;
        }
        if (string6 != null) {
            this.format = this.makeAttributeValueTemplate(string6);
            if (this.format instanceof StringValue) {
                this.formatter = new NumberFormatter();
                this.formatter.prepare(((StringValue)this.format).getStringValue());
            }
        } else {
            this.formatter = new NumberFormatter();
            this.formatter.prepare("1");
        }
        if (string8 != null && string7 != null) {
            this.groupSize = this.makeAttributeValueTemplate(string7);
            this.groupSeparator = this.makeAttributeValueTemplate(string8);
        }
        if (string9 == null) {
            this.numberer = defaultNumberer;
        } else {
            this.lang = this.makeAttributeValueTemplate(string9);
            if (this.lang instanceof StringValue) {
                this.numberer = this.makeNumberer(((StringValue)this.lang).getStringValue());
            }
        }
        if (string10 != null) {
            this.letterValue = this.makeAttributeValueTemplate(string10);
        }
        if (string11 != null) {
            this.ordinal = this.makeAttributeValueTemplate(string11);
        }
    }

    public void validate() throws XPathException {
        this.checkWithinTemplate();
        this.checkEmpty();
        this.select = this.typeCheck("select", this.select);
        this.value = this.typeCheck("value", this.value);
        this.format = this.typeCheck("format", this.format);
        this.groupSize = this.typeCheck("group-size", this.groupSize);
        this.groupSeparator = this.typeCheck("group-separator", this.groupSeparator);
        this.letterValue = this.typeCheck("letter-value", this.letterValue);
        this.ordinal = this.typeCheck("ordinal", this.ordinal);
        this.lang = this.typeCheck("lang", this.lang);
        this.from = this.typeCheck("from", this.from);
        this.count = this.typeCheck("count", this.count);
        if (this.select != null) {
            try {
                RoleLocator roleLocator = new RoleLocator(4, "xsl:number/select", 0, null);
                roleLocator.setSourceLocator(new ExpressionLocation(this));
                roleLocator.setErrorCode("XTTE1000");
                this.select = TypeChecker.staticTypeCheck(this.select, SequenceType.SINGLE_NODE, false, roleLocator, this.getStaticContext());
            }
            catch (XPathException xPathException) {
                this.compileError(xPathException);
            }
        }
    }

    public Expression compile(Executable executable) throws XPathException {
        NumberInstruction numberInstruction = new NumberInstruction(executable.getConfiguration(), this.select, this.level, this.count, this.from, this.value, this.format, this.groupSize, this.groupSeparator, this.letterValue, this.ordinal, this.lang, this.formatter, this.numberer, this.hasVariablesInPatterns, this.backwardsCompatibleModeIsEnabled());
        int n2 = this.getStaticContext().getLocationMap().allocateLocationId(this.getSystemId(), this.getLineNumber());
        numberInstruction.setLocationId(n2);
        ExpressionTool.makeParentReferences(numberInstruction);
        ValueOf valueOf = new ValueOf(numberInstruction, false, false);
        valueOf.setLocationId(this.allocateLocationId(this.getSystemId(), this.getLineNumber()));
        ExpressionTool.makeParentReferences(valueOf);
        valueOf.setIsNumberingInstruction();
        return valueOf;
    }

    protected Numberer makeNumberer(String string) {
        Numberer numberer;
        if (string.equals("en")) {
            numberer = defaultNumberer;
        } else {
            String string2 = "net.sf.saxon.number.Numberer_";
            for (int i2 = 0; i2 < string.length(); ++i2) {
                if (!Character.isLetter(string.charAt(i2))) continue;
                string2 = string2 + string.charAt(i2);
            }
            try {
                numberer = (Numberer)this.getConfiguration().getInstance(string2, null);
            }
            catch (Exception exception) {
                numberer = defaultNumberer;
            }
        }
        return numberer;
    }
}

