/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.style;

import java.io.Serializable;
import net.sf.saxon.expr.ComputedExpression;
import net.sf.saxon.expr.ErrorExpression;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.ExpressionLocation;
import net.sf.saxon.expr.RoleLocator;
import net.sf.saxon.expr.TypeChecker;
import net.sf.saxon.instruct.DocumentInstr;
import net.sf.saxon.instruct.Executable;
import net.sf.saxon.instruct.GeneralVariable;
import net.sf.saxon.instruct.GlobalVariable;
import net.sf.saxon.instruct.ParentNodeConstructor;
import net.sf.saxon.instruct.SlotManager;
import net.sf.saxon.instruct.TraceInstruction;
import net.sf.saxon.om.AttributeCollection;
import net.sf.saxon.om.AxisIterator;
import net.sf.saxon.om.NamespaceException;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.pattern.NodeKindTest;
import net.sf.saxon.style.StyleElement;
import net.sf.saxon.style.XSLParam;
import net.sf.saxon.style.XSLVariableDeclaration;
import net.sf.saxon.style.XSLWithParam;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.type.ItemType;
import net.sf.saxon.type.Type;
import net.sf.saxon.value.Cardinality;
import net.sf.saxon.value.EmptySequence;
import net.sf.saxon.value.SequenceType;
import net.sf.saxon.value.StringValue;

public abstract class XSLGeneralVariable
extends StyleElement {
    protected Expression select = null;
    protected SequenceType requiredType = null;
    protected String constantText = null;
    protected boolean global;
    protected SlotManager slotManager = null;
    protected boolean assignable = false;
    protected boolean redundant = false;
    protected boolean requiredParam = false;
    protected boolean implicitlyRequiredParam = false;
    protected boolean tunnel = false;
    private boolean textonly;

    protected ItemType getReturnedItemType() {
        return null;
    }

    public boolean mayContainSequenceConstructor() {
        return true;
    }

    protected boolean allowsAsAttribute() {
        return true;
    }

    protected boolean allowsTunnelAttribute() {
        return false;
    }

    protected boolean allowsValue() {
        return true;
    }

    protected boolean allowsRequired() {
        return false;
    }

    public boolean isAssignable() {
        return this.assignable;
    }

    public boolean isTunnelParam() {
        return this.tunnel;
    }

    public boolean isRequiredParam() {
        return this.requiredParam;
    }

    public boolean isGlobal() {
        return this.isTopLevel();
    }

    public String getVariableName() {
        return this.getAttributeValue("name");
    }

    public void setRedundant() {
        this.redundant = true;
    }

    public int getVariableFingerprint() {
        if (this.getObjectNameCode() == -1) {
            String string = this.getAttributeValue("name");
            if (string == null) {
                return -1;
            }
            try {
                this.setObjectNameCode(this.makeNameCode(string.trim()));
            }
            catch (NamespaceException namespaceException) {
                this.setObjectNameCode(-1);
            }
            catch (XPathException xPathException) {
                this.setObjectNameCode(-1);
            }
        }
        return this.getObjectFingerprint();
    }

    public void prepareAttributes() throws XPathException {
        this.getVariableFingerprint();
        AttributeCollection attributeCollection = this.getAttributeList();
        String string = null;
        String string2 = null;
        String string3 = null;
        String string4 = null;
        String string5 = null;
        String string6 = null;
        for (int i2 = 0; i2 < attributeCollection.getLength(); ++i2) {
            int n2 = attributeCollection.getNameCode(i2);
            String string7 = this.getNamePool().getClarkName(n2);
            if (string7 == "name") {
                string3 = attributeCollection.getValue(i2).trim();
                continue;
            }
            if (string7 == "select") {
                string = attributeCollection.getValue(i2);
                continue;
            }
            if (string7 == "as" && this.allowsAsAttribute()) {
                string4 = attributeCollection.getValue(i2);
                continue;
            }
            if (string7 == "required" && this.allowsRequired()) {
                string5 = attributeCollection.getValue(i2).trim();
                continue;
            }
            if (string7 == "tunnel" && this.allowsTunnelAttribute()) {
                string6 = attributeCollection.getValue(i2).trim();
                continue;
            }
            if (string7 == "{http://saxon.sf.net/}assignable" && this instanceof XSLVariableDeclaration) {
                string2 = attributeCollection.getValue(i2).trim();
                continue;
            }
            this.checkUnknownAttribute(n2);
        }
        if (string3 == null) {
            this.reportAbsence("name");
        } else {
            try {
                this.setObjectNameCode(this.makeNameCode(string3.trim()));
            }
            catch (NamespaceException namespaceException) {
                this.compileError(namespaceException.getMessage());
            }
            catch (XPathException xPathException) {
                this.compileError(xPathException);
            }
        }
        if (string != null) {
            if (!this.allowsValue()) {
                this.compileError("Function parameters cannot have a default value", "XTSE0760");
            }
            this.select = this.makeExpression(string);
        }
        if (string2 != null && string2.equals("yes")) {
            this.assignable = true;
        }
        if (string5 != null) {
            if (string5.equals("yes")) {
                this.requiredParam = true;
            } else if (string5.equals("no")) {
                this.requiredParam = false;
            } else {
                this.compileError("The attribute 'required' must be set to 'yes' or 'no'", "XTSE0020");
            }
        }
        if (string6 != null) {
            if (string6.equals("yes")) {
                this.tunnel = true;
            } else if (string6.equals("no")) {
                this.tunnel = false;
            } else {
                this.compileError("The attribute 'tunnel' must be set to 'yes' or 'no'", "XTSE0020");
            }
        }
        if (string4 != null) {
            this.requiredType = this.makeSequenceType(string4);
        }
    }

    public void validate() throws XPathException {
        this.global = this.isTopLevel();
        if (this.global) {
            this.slotManager = this.getConfiguration().makeSlotManager();
        }
        if (this.select != null && this.hasChildNodes()) {
            this.compileError("An " + this.getDisplayName() + " element with a select attribute must be empty", "XTSE0620");
        }
        if (this.hasChildNodes() && !this.allowsValue()) {
            this.compileError("Function parameters cannot have a default value", "XTSE0760");
        }
        if (this.assignable && !this.global) {
            this.compileError("saxon:assignable='yes' is no longer permitted for local variables");
        }
        this.checkAgainstRequiredType(this.requiredType);
        if (this.select == null && this.allowsValue()) {
            this.textonly = true;
            AxisIterator axisIterator = this.iterateAxis((byte)3);
            NodeInfo nodeInfo = (NodeInfo)axisIterator.next();
            if (nodeInfo == null) {
                if (this.requiredType == null) {
                    this.select = StringValue.EMPTY_STRING;
                } else if (this instanceof XSLParam) {
                    if (!this.requiredParam) {
                        if (Cardinality.allowsZero(this.requiredType.getCardinality())) {
                            this.select = EmptySequence.getInstance();
                        } else {
                            this.implicitlyRequiredParam = true;
                        }
                    }
                } else if (Cardinality.allowsZero(this.requiredType.getCardinality())) {
                    this.select = EmptySequence.getInstance();
                } else {
                    this.compileError("The implicit value () is not valid for the declared type", "XTTE0570");
                }
            } else {
                if (axisIterator.next() == null && nodeInfo.getNodeKind() == 3) {
                    this.constantText = nodeInfo.getStringValue();
                }
                this.textonly = this.getCommonChildItemType() == NodeKindTest.TEXT;
            }
        }
        this.select = this.typeCheck("select", this.select);
    }

    protected void checkAgainstRequiredType(SequenceType sequenceType) throws XPathException {
        try {
            if (sequenceType != null && this.select != null) {
                int n2 = 3;
                String string = "XTTE0570";
                if (this instanceof XSLParam) {
                    n2 = 8;
                    string = "XTTE0600";
                } else if (this instanceof XSLWithParam) {
                    n2 = 8;
                }
                RoleLocator roleLocator = new RoleLocator(n2, this.getVariableName(), 0, null);
                roleLocator.setSourceLocator(new ExpressionLocation(this));
                roleLocator.setErrorCode(string);
                this.select = TypeChecker.staticTypeCheck(this.select, sequenceType, false, roleLocator, this.getStaticContext());
            }
        }
        catch (XPathException xPathException) {
            xPathException.setLocator(this);
            this.compileError(xPathException);
            this.select = new ErrorExpression(xPathException);
        }
    }

    protected void initializeInstruction(Executable executable, GeneralVariable generalVariable) throws XPathException {
        Expression expression;
        Serializable serializable;
        generalVariable.init(this.select, this.getObjectNameCode());
        generalVariable.setAssignable(this.assignable);
        generalVariable.setRequiredParam(this.requiredParam);
        generalVariable.setImplicitlyRequiredParam(this.implicitlyRequiredParam);
        generalVariable.setRequiredType(this.requiredType);
        generalVariable.setTunnel(this.tunnel);
        if (this.hasChildNodes()) {
            if (this.requiredType == null) {
                serializable = new DocumentInstr(this.textonly, this.constantText, this.getBaseURI());
                ((ComputedExpression)serializable).setParentExpression(generalVariable);
                expression = this.compileSequenceConstructor(executable, this.iterateAxis((byte)3), true);
                if (expression == null) {
                    expression = EmptySequence.getInstance();
                }
                ((ParentNodeConstructor)serializable).setContentExpression(expression);
                this.select = serializable;
                generalVariable.setSelectExpression((Expression)serializable);
            } else {
                this.select = this.compileSequenceConstructor(executable, this.iterateAxis((byte)3), true);
                generalVariable.adoptChildExpression(this.select);
                if (this.select == null) {
                    this.select = EmptySequence.getInstance();
                }
                try {
                    if (this.requiredType != null) {
                        generalVariable.setParentExpression(this);
                        serializable = new RoleLocator(3, this.getVariableName(), 0, null);
                        ((RoleLocator)serializable).setErrorCode("XTTE0570");
                        ((RoleLocator)serializable).setSourceLocator(new ExpressionLocation(this));
                        this.select = this.select.simplify(this.getStaticContext());
                        this.select = TypeChecker.staticTypeCheck(this.select, this.requiredType, false, (RoleLocator)serializable, this.getStaticContext());
                    }
                }
                catch (XPathException xPathException) {
                    xPathException.setLocator(this);
                    this.compileError(xPathException);
                    this.select = new ErrorExpression(xPathException);
                }
                generalVariable.setSelectExpression(this.select);
            }
        }
        if (this.global) {
            serializable = (GlobalVariable)generalVariable;
            expression = this.select;
            if (expression != null) {
                try {
                    expression = this.select.simplify(this.staticContext).typeCheck(this.staticContext, Type.NODE_TYPE);
                    expression = expression.optimize(this.getConfiguration().getOptimizer(), this.staticContext, Type.NODE_TYPE);
                }
                catch (XPathException xPathException) {
                    this.compileError(xPathException);
                }
                if (this.getConfiguration().getTraceListener() != null) {
                    TraceInstruction traceInstruction = new TraceInstruction(expression, this);
                    traceInstruction.setLocationId(this.allocateLocationId(this.getSystemId(), this.getLineNumber()));
                    expression = traceInstruction;
                }
                this.allocateSlots(expression);
            }
            if (this.slotManager != null && this.slotManager.getNumberOfVariables() > 0) {
                ((GlobalVariable)serializable).setContainsLocals(this.slotManager);
            }
            executable.registerGlobalVariable((GlobalVariable)serializable);
            this.setReferenceCount((GeneralVariable)serializable);
            if (expression != this.select) {
                ((GeneralVariable)serializable).setSelectExpression(expression);
            }
        }
    }

    protected void setReferenceCount(GeneralVariable generalVariable) {
    }

    public int getConstructType() {
        return 185;
    }
}

