/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.style;

import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.ExpressionTool;
import net.sf.saxon.instruct.Executable;
import net.sf.saxon.instruct.ForEach;
import net.sf.saxon.om.AttributeCollection;
import net.sf.saxon.sort.SortExpression;
import net.sf.saxon.sort.SortKeyDefinition;
import net.sf.saxon.style.StyleElement;
import net.sf.saxon.style.XSLSort;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.type.ItemType;
import net.sf.saxon.value.EmptySequence;

public class XSLForEach
extends StyleElement {
    Expression select = null;

    public boolean isInstruction() {
        return true;
    }

    protected boolean isPermittedChild(StyleElement styleElement) {
        return styleElement instanceof XSLSort;
    }

    protected ItemType getReturnedItemType() {
        return this.getCommonChildItemType();
    }

    public boolean mayContainSequenceConstructor() {
        return true;
    }

    public void prepareAttributes() throws XPathException {
        AttributeCollection attributeCollection = this.getAttributeList();
        String string = null;
        for (int i2 = 0; i2 < attributeCollection.getLength(); ++i2) {
            int n2 = attributeCollection.getNameCode(i2);
            String string2 = this.getNamePool().getClarkName(n2);
            if (string2 == "select") {
                string = attributeCollection.getValue(i2);
                continue;
            }
            this.checkUnknownAttribute(n2);
        }
        if (string == null) {
            this.reportAbsence("select");
        } else {
            this.select = this.makeExpression(string);
        }
    }

    public void validate() throws XPathException {
        this.checkWithinTemplate();
        this.checkSortComesFirst(false);
        this.select = this.typeCheck("select", this.select);
    }

    public Expression compile(Executable executable) throws XPathException {
        Expression expression;
        SortKeyDefinition[] sortKeyDefinitionArray = this.makeSortKeys();
        Expression expression2 = this.select;
        if (sortKeyDefinitionArray != null) {
            expression2 = new SortExpression(this.select, sortKeyDefinitionArray);
            ExpressionTool.makeParentReferences(expression2);
        }
        if ((expression = this.compileSequenceConstructor(executable, this.iterateAxis((byte)3), true)) == null) {
            return EmptySequence.getInstance();
        }
        try {
            ForEach forEach = new ForEach(expression2, expression.simplify(this.getStaticContext()));
            ExpressionTool.makeParentReferences(forEach);
            return forEach;
        }
        catch (XPathException xPathException) {
            this.compileError(xPathException);
            return null;
        }
    }
}

