/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.style;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.instruct.AttributeSet;
import net.sf.saxon.instruct.Executable;
import net.sf.saxon.instruct.SlotManager;
import net.sf.saxon.instruct.TraceInstruction;
import net.sf.saxon.om.AttributeCollection;
import net.sf.saxon.om.AxisIterator;
import net.sf.saxon.om.NamespaceException;
import net.sf.saxon.style.StyleElement;
import net.sf.saxon.style.StylesheetProcedure;
import net.sf.saxon.style.XSLAttribute;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.type.AnyItemType;
import net.sf.saxon.value.EmptySequence;

public class XSLAttributeSet
extends StyleElement
implements StylesheetProcedure {
    private String nameAtt;
    private String useAtt;
    private SlotManager stackFrameMap;
    private List attributeSetElements = null;
    private AttributeSet[] useAttributeSets = null;
    private AttributeSet procedure = new AttributeSet();
    private int referenceCount = 0;
    private boolean validated = false;

    public int getAttributeSetFingerprint() {
        return this.getObjectFingerprint();
    }

    public AttributeSet getInstruction() {
        return this.procedure;
    }

    public void incrementReferenceCount() {
        ++this.referenceCount;
    }

    public void prepareAttributes() throws XPathException {
        this.useAtt = null;
        AttributeCollection attributeCollection = this.getAttributeList();
        for (int i2 = 0; i2 < attributeCollection.getLength(); ++i2) {
            int n2 = attributeCollection.getNameCode(i2);
            String string = this.getNamePool().getClarkName(n2);
            if (string == "name") {
                this.nameAtt = attributeCollection.getValue(i2).trim();
                continue;
            }
            if (string == "use-attribute-sets") {
                this.useAtt = attributeCollection.getValue(i2);
                continue;
            }
            this.checkUnknownAttribute(n2);
        }
        if (this.nameAtt == null) {
            this.reportAbsence("name");
            return;
        }
        try {
            this.setObjectNameCode(this.makeNameCode(this.nameAtt.trim()));
        }
        catch (NamespaceException namespaceException) {
            this.compileError(namespaceException.getMessage(), "XTSE0280");
        }
        catch (XPathException xPathException) {
            this.compileError(xPathException.getMessage(), "XTSE0280");
        }
    }

    public void validate() throws XPathException {
        Object object;
        if (this.validated) {
            return;
        }
        this.checkTopLevel(null);
        this.stackFrameMap = this.getConfiguration().makeSlotManager();
        AxisIterator axisIterator = this.iterateAxis((byte)3);
        while ((object = axisIterator.next()) != null) {
            if (object instanceof XSLAttribute) continue;
            this.compileError("Only xsl:attribute is allowed within xsl:attribute-set", "XTSE0010");
        }
        if (this.useAtt != null) {
            this.attributeSetElements = new ArrayList(5);
            this.useAttributeSets = this.getAttributeSets(this.useAtt, this.attributeSetElements);
            object = this.attributeSetElements.iterator();
            while (object.hasNext()) {
                ((XSLAttributeSet)object.next()).checkCircularity(this);
            }
        }
        this.validated = true;
    }

    public void checkCircularity(XSLAttributeSet xSLAttributeSet) throws XPathException {
        if (this == xSLAttributeSet) {
            this.compileError("The definition of the attribute set is circular", "XTSE0720");
        } else {
            if (!this.validated) {
                return;
            }
            if (this.attributeSetElements != null) {
                Iterator iterator = this.attributeSetElements.iterator();
                while (iterator.hasNext()) {
                    ((XSLAttributeSet)iterator.next()).checkCircularity(xSLAttributeSet);
                }
            }
        }
    }

    public SlotManager getSlotManager() {
        return this.stackFrameMap;
    }

    public Expression compile(Executable executable) throws XPathException {
        if (this.referenceCount > 0) {
            Expression expression = this.compileSequenceConstructor(executable, this.iterateAxis((byte)3), true);
            if (expression == null) {
                expression = EmptySequence.getInstance();
            }
            try {
                Expression expression2;
                expression = expression.simplify(this.getStaticContext());
                if (this.getConfiguration().getTraceListener() != null) {
                    expression2 = new TraceInstruction(expression, this);
                    expression2.setLocationId(this.allocateLocationId(this.getSystemId(), this.getLineNumber()));
                    expression2.setParentExpression(this.procedure);
                    expression = expression2;
                }
                this.procedure.setUseAttributeSets(this.useAttributeSets);
                this.procedure.setNameCode(this.getObjectNameCode());
                this.procedure.setBody(expression);
                this.procedure.setSystemId(this.getSystemId());
                this.procedure.setLineNumber(this.getLineNumber());
                this.procedure.setExecutable(executable);
                expression2 = expression.optimize(this.getConfiguration().getOptimizer(), this.staticContext, AnyItemType.getInstance());
                if (expression != expression2) {
                    this.procedure.setBody(expression2);
                    expression = expression2;
                }
                super.allocateSlots(expression);
                this.procedure.setStackFrameMap(this.stackFrameMap);
            }
            catch (XPathException xPathException) {
                this.compileError(xPathException);
            }
        }
        return null;
    }

    public int getConstructType() {
        return 132;
    }
}

