/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.style;

import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.ExpressionTool;
import net.sf.saxon.instruct.Executable;
import net.sf.saxon.instruct.ValueOf;
import net.sf.saxon.om.AttributeCollection;
import net.sf.saxon.style.StyleElement;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.value.StringValue;

public class SaxonEntityRef
extends StyleElement {
    String nameAttribute;

    public boolean isInstruction() {
        return true;
    }

    public void prepareAttributes() throws XPathException {
        AttributeCollection attributeCollection = this.getAttributeList();
        for (int i2 = 0; i2 < attributeCollection.getLength(); ++i2) {
            int n2 = attributeCollection.getNameCode(i2);
            String string = this.getNamePool().getClarkName(n2);
            if (string == "name") {
                this.nameAttribute = attributeCollection.getValue(i2).trim();
                continue;
            }
            this.checkUnknownAttribute(n2);
        }
        if (this.nameAttribute == null) {
            this.reportAbsence("name");
        }
    }

    public void validate() throws XPathException {
        this.checkWithinTemplate();
        this.checkEmpty();
    }

    public Expression compile(Executable executable) throws XPathException {
        ValueOf valueOf = new ValueOf(new StringValue('&' + this.nameAttribute + ';'), true, false);
        ExpressionTool.makeParentReferences(valueOf);
        return valueOf;
    }
}

