/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.style;

import java.net.URI;
import java.net.URISyntaxException;
import java.text.Collator;
import java.util.Comparator;
import java.util.Locale;
import java.util.Properties;
import net.sf.saxon.Configuration;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.instruct.Executable;
import net.sf.saxon.om.AttributeCollection;
import net.sf.saxon.style.StyleElement;
import net.sf.saxon.trans.XPathException;

public class SaxonCollation
extends StyleElement {
    private String collationName;
    private Comparator collator;
    private boolean isDefault = false;

    public void prepareAttributes() throws XPathException {
        AttributeCollection attributeCollection = this.getAttributeList();
        String string = null;
        String string2 = null;
        Properties properties = new Properties();
        for (int i2 = 0; i2 < attributeCollection.getLength(); ++i2) {
            int n2 = attributeCollection.getNameCode(i2);
            String string3 = this.getNamePool().getClarkName(n2);
            if (string3 == "name") {
                string = attributeCollection.getValue(i2).trim();
                continue;
            }
            if (string3 == "class") {
                properties.setProperty("class", attributeCollection.getValue(i2).trim());
                continue;
            }
            if (string3 == "strength") {
                properties.setProperty("strength", attributeCollection.getValue(i2).trim());
                continue;
            }
            if (string3 == "decomposition") {
                properties.setProperty("decomposition", attributeCollection.getValue(i2).trim());
                continue;
            }
            if (string3 == "lang") {
                properties.setProperty("lang", attributeCollection.getValue(i2).trim());
                continue;
            }
            if (string3 == "rules") {
                properties.setProperty("rules", attributeCollection.getValue(i2).trim());
                continue;
            }
            if (string3 == "case-order") {
                properties.setProperty("case-order", attributeCollection.getValue(i2).trim());
                continue;
            }
            if (string3 == "alphanumeric") {
                properties.setProperty("alphanumeric", attributeCollection.getValue(i2).trim());
                continue;
            }
            if (string3 == "ignore-case") {
                properties.setProperty("ignore-case", attributeCollection.getValue(i2).trim());
                continue;
            }
            if (string3 == "ignore-modifiers") {
                properties.setProperty("ignore-modifiers", attributeCollection.getValue(i2).trim());
                continue;
            }
            if (string3 == "ignore-symbols") {
                properties.setProperty("ignore-modifiers", attributeCollection.getValue(i2).trim());
                continue;
            }
            if (string3 == "ignore-width") {
                properties.setProperty("ignore-width", attributeCollection.getValue(i2).trim());
                continue;
            }
            if (string3 == "default") {
                string2 = attributeCollection.getValue(i2).trim();
                continue;
            }
            this.checkUnknownAttribute(n2);
        }
        if (string != null) {
            this.collationName = string.trim();
            try {
                URI uRI = new URI(this.collationName);
                if (!uRI.isAbsolute()) {
                    URI uRI2 = new URI(this.getBaseURI());
                    uRI = uRI2.resolve(uRI);
                    this.collationName = uRI.toString();
                }
            }
            catch (URISyntaxException uRISyntaxException) {
                this.compileError("Collation name '" + this.collationName + "' is not a valid URI");
                this.collationName = "http://www.w3.org/2005/xpath-functions/collation/codepoint";
            }
        }
        if (string2 != null) {
            if (string2.equals("yes")) {
                this.isDefault = true;
            } else if (!string2.equals("no")) {
                this.compileError("default attribute must be yes or no");
            }
        }
        if (this.collator == null) {
            Configuration configuration = this.getConfiguration();
            this.collator = configuration.getPlatform().makeCollation(configuration, properties);
        }
        this.getPrincipalStylesheet().setCollation(this.collationName, this.collator, this.isDefault);
    }

    public void validate() throws XPathException {
        this.checkTopLevel(null);
        this.checkEmpty();
    }

    public Expression compile(Executable executable) throws XPathException {
        this.getPrincipalStylesheet().setCollation(this.collationName, this.collator, this.isDefault);
        executable.setReasonUnableToCompile("Cannot compile a stylesheet that uses saxon:collation (because the Java class java.text.RuleBasedCollator is not serializable)");
        return null;
    }

    public String getCollationName() {
        return this.collationName;
    }

    public boolean isDefaultCollation() {
        return this.isDefault;
    }

    public Comparator getCollator() {
        return this.collator;
    }

    public static void main(String[] stringArray) {
        System.err.println("The following locales have collations available:");
        Locale[] localeArray = Collator.getAvailableLocales();
        for (int i2 = 0; i2 < localeArray.length; ++i2) {
            Locale locale = localeArray[i2];
            System.err.println("Locale:" + ("".equals(locale.getCountry()) ? "" : " country='" + locale.getCountry() + "' (" + locale.getDisplayCountry() + ')') + ("".equals(locale.getLanguage()) ? "" : " language='" + locale.getLanguage() + "' (" + locale.getDisplayLanguage() + ')') + ("".equals(locale.getVariant()) ? "" : " variant='" + locale.getVariant() + "' (" + locale.getDisplayVariant() + ')'));
        }
    }
}

