/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.regex;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.sf.saxon.om.ArrayIterator;
import net.sf.saxon.om.EmptyIterator;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.regex.RegexIterator;
import net.sf.saxon.value.StringValue;

public class JRegexIterator
implements RegexIterator {
    private String theString;
    private Pattern pattern;
    private Matcher matcher;
    private String current;
    private String next;
    private int position = 0;
    private int prevEnd = 0;

    public JRegexIterator(String string, Pattern pattern) {
        this.theString = string;
        this.pattern = pattern;
        this.matcher = pattern.matcher(string);
        this.next = null;
    }

    public Item next() {
        if (this.next == null && this.prevEnd >= 0) {
            if (this.matcher.find()) {
                int n2 = this.matcher.start();
                int n3 = this.matcher.end();
                if (this.prevEnd == n2) {
                    this.next = null;
                    this.current = this.theString.substring(n2, n3);
                    this.prevEnd = n3;
                } else {
                    this.current = this.theString.substring(this.prevEnd, n2);
                    this.next = this.theString.substring(n2, n3);
                }
            } else {
                if (this.prevEnd >= this.theString.length()) {
                    this.current = null;
                    this.position = -1;
                    this.prevEnd = -1;
                    return null;
                }
                this.current = this.theString.substring(this.prevEnd);
                this.next = null;
                this.prevEnd = -1;
            }
        } else if (this.prevEnd >= 0) {
            this.current = this.next;
            this.next = null;
            this.prevEnd = this.matcher.end();
        } else {
            this.current = null;
            this.position = -1;
            return null;
        }
        ++this.position;
        return StringValue.makeStringValue(this.current);
    }

    public Item current() {
        return StringValue.makeStringValue(this.current);
    }

    public int position() {
        return this.position;
    }

    public SequenceIterator getAnother() {
        return new JRegexIterator(this.theString, this.pattern);
    }

    public int getProperties() {
        return 0;
    }

    public boolean isMatching() {
        return this.next == null && this.prevEnd >= 0;
    }

    public String getRegexGroup(int n2) {
        if (!this.isMatching()) {
            return null;
        }
        if (n2 > this.matcher.groupCount() || n2 < 0) {
            return "";
        }
        String string = this.matcher.group(n2);
        if (string == null) {
            return "";
        }
        return string;
    }

    public SequenceIterator getRegexGroupIterator() {
        int n2 = this.matcher.groupCount();
        if (n2 == 0) {
            return EmptyIterator.getInstance();
        }
        Item[] itemArray = new StringValue[n2];
        for (int i2 = 1; i2 <= itemArray.length; ++i2) {
            itemArray[i2 - 1] = StringValue.makeStringValue(this.matcher.group(i2));
        }
        return new ArrayIterator(itemArray);
    }
}

