/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.pull;

import net.sf.saxon.Configuration;
import net.sf.saxon.event.ComplexContentOutputter;
import net.sf.saxon.event.NamespaceReducer;
import net.sf.saxon.event.PipelineConfiguration;
import net.sf.saxon.event.Receiver;
import net.sf.saxon.event.SequenceOutputter;
import net.sf.saxon.expr.StackFrame;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.expr.XPathContextMajor;
import net.sf.saxon.instruct.ParentNodeConstructor;
import net.sf.saxon.om.AxisIterator;
import net.sf.saxon.om.DocumentInfo;
import net.sf.saxon.om.FastStringBuffer;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.NamePool;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.om.SingletonIterator;
import net.sf.saxon.om.ValueRepresentation;
import net.sf.saxon.pattern.NodeTest;
import net.sf.saxon.pull.PullProvider;
import net.sf.saxon.pull.PullPushCopier;
import net.sf.saxon.pull.TreeWalker;
import net.sf.saxon.pull.VirtualTreeWalker;
import net.sf.saxon.tinytree.TinyBuilder;
import net.sf.saxon.trans.UncheckedXPathException;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.value.Value;

public abstract class UnconstructedParent
implements NodeInfo {
    private ParentNodeConstructor instruction;
    private XPathContextMajor savedXPathContext;
    NodeInfo node = null;

    public UnconstructedParent(ParentNodeConstructor parentNodeConstructor, XPathContext xPathContext) {
        ValueRepresentation[] valueRepresentationArray;
        Object object;
        Object object2;
        this.instruction = parentNodeConstructor;
        this.savedXPathContext = xPathContext.newContext();
        this.savedXPathContext.setOriginatingConstructType(2063);
        if ((parentNodeConstructor.getDependencies() & 0x80) != 0 && (object2 = ((StackFrame)(object = xPathContext.getStackFrame())).getStackFrameValues()) != null) {
            valueRepresentationArray = new ValueRepresentation[((ValueRepresentation[])object2).length];
            System.arraycopy(object2, 0, valueRepresentationArray, 0, ((ValueRepresentation[])object2).length);
            this.savedXPathContext.setStackFrame(((StackFrame)object).getStackFrameMap(), valueRepresentationArray);
        }
        if ((object = xPathContext.getCurrentIterator()) != null) {
            object2 = object.current();
            valueRepresentationArray = SingletonIterator.makeIterator((Item)object2);
            valueRepresentationArray.next();
            this.savedXPathContext.setCurrentIterator((SequenceIterator)valueRepresentationArray);
        }
        this.savedXPathContext.setReceiver(new SequenceOutputter());
    }

    public XPathContext getXPathContext() {
        return this.savedXPathContext;
    }

    public ParentNodeConstructor getInstruction() {
        return this.instruction;
    }

    public PullProvider getPuller() {
        if (this.node == null) {
            VirtualTreeWalker virtualTreeWalker = new VirtualTreeWalker(this.instruction, this.savedXPathContext);
            virtualTreeWalker.setPipelineConfiguration(this.savedXPathContext.getController().makePipelineConfiguration());
            virtualTreeWalker.setNameCode(this.getNameCode());
            return virtualTreeWalker;
        }
        return TreeWalker.makeTreeWalker(this.node);
    }

    void construct() throws XPathException {
        PipelineConfiguration pipelineConfiguration = this.savedXPathContext.getController().makePipelineConfiguration();
        PullProvider pullProvider = this.getPuller();
        pullProvider.setPipelineConfiguration(pipelineConfiguration);
        TinyBuilder tinyBuilder = new TinyBuilder();
        tinyBuilder.setPipelineConfiguration(pipelineConfiguration);
        tinyBuilder.setSystemId(pipelineConfiguration.getLocationProvider().getSystemId(this.instruction.getLocationId()));
        NamespaceReducer namespaceReducer = new NamespaceReducer();
        namespaceReducer.setUnderlyingReceiver(tinyBuilder);
        namespaceReducer.setPipelineConfiguration(pipelineConfiguration);
        ComplexContentOutputter complexContentOutputter = new ComplexContentOutputter();
        complexContentOutputter.setReceiver(namespaceReducer);
        complexContentOutputter.setPipelineConfiguration(pipelineConfiguration);
        complexContentOutputter.open();
        new PullPushCopier(pullProvider, complexContentOutputter).copy();
        complexContentOutputter.close();
        this.node = tinyBuilder.getCurrentRoot();
    }

    void tryToConstruct() {
        try {
            this.construct();
        }
        catch (XPathException xPathException) {
            throw new UncheckedXPathException(xPathException);
        }
    }

    public boolean isSameNodeInfo(NodeInfo nodeInfo) {
        if (this == nodeInfo) {
            return true;
        }
        if (nodeInfo instanceof UnconstructedParent) {
            return false;
        }
        if (this.node != null) {
            return this.node.isSameNodeInfo(nodeInfo);
        }
        return false;
    }

    public boolean equals(Object object) {
        if (object instanceof NodeInfo) {
            return this.isSameNodeInfo((NodeInfo)object);
        }
        return false;
    }

    public int hashCode() {
        if (this.node != null) {
            return ((Object)this.node).hashCode();
        }
        return super.hashCode();
    }

    public String getSystemId() {
        if (this.node == null) {
            this.tryToConstruct();
        }
        return this.node.getSystemId();
    }

    public String getBaseURI() {
        if (this.node == null) {
            this.tryToConstruct();
        }
        return this.node.getBaseURI();
    }

    public int getLineNumber() {
        return -1;
    }

    public int compareOrder(NodeInfo nodeInfo) {
        if (this.node == null) {
            this.tryToConstruct();
        }
        return this.node.compareOrder(nodeInfo);
    }

    public String getStringValue() {
        return ((Object)this.getStringValueCS()).toString();
    }

    public int getFingerprint() {
        int n2 = this.getNameCode();
        if (n2 == -1) {
            return -1;
        }
        return n2 & 0xFFFFF;
    }

    public String getLocalPart() {
        return this.getNamePool().getLocalName(this.getNameCode());
    }

    public String getURI() {
        return this.getNamePool().getURI(this.getNameCode());
    }

    public String getDisplayName() {
        return this.getNamePool().getDisplayName(this.getNameCode());
    }

    public String getPrefix() {
        return this.getNamePool().getPrefix(this.getNameCode());
    }

    public Configuration getConfiguration() {
        return this.savedXPathContext.getConfiguration();
    }

    public NamePool getNamePool() {
        return this.getConfiguration().getNamePool();
    }

    public int getTypeAnnotation() {
        return 641;
    }

    public NodeInfo getParent() {
        return null;
    }

    public AxisIterator iterateAxis(byte by) {
        if (this.node == null) {
            this.tryToConstruct();
        }
        return this.node.iterateAxis(by);
    }

    public AxisIterator iterateAxis(byte by, NodeTest nodeTest) {
        if (this.node == null) {
            this.tryToConstruct();
        }
        return this.node.iterateAxis(by, nodeTest);
    }

    public String getAttributeValue(int n2) {
        if (this.node == null) {
            this.tryToConstruct();
        }
        return this.node.getAttributeValue(n2);
    }

    public NodeInfo getRoot() {
        return this;
    }

    public DocumentInfo getDocumentRoot() {
        return null;
    }

    public boolean hasChildNodes() {
        if (this.node == null) {
            this.tryToConstruct();
        }
        return this.node.hasChildNodes();
    }

    public void generateId(FastStringBuffer fastStringBuffer) {
        if (this.node == null) {
            this.tryToConstruct();
        }
        this.node.generateId(fastStringBuffer);
    }

    public int getDocumentNumber() {
        if (this.node == null) {
            this.tryToConstruct();
        }
        return this.node.getDocumentNumber();
    }

    public void copy(Receiver receiver, int n2, boolean bl, int n3) throws XPathException {
        if (this.node == null) {
            if (n2 == 2 && bl) {
                VirtualTreeWalker virtualTreeWalker = new VirtualTreeWalker(this.instruction, this.savedXPathContext);
                PullPushCopier pullPushCopier = new PullPushCopier(virtualTreeWalker, receiver);
                pullPushCopier.copy();
                return;
            }
            this.construct();
        }
        this.node.copy(receiver, n2, bl, n3);
    }

    public void sendNamespaceDeclarations(Receiver receiver, boolean bl) throws XPathException {
        if (this.node == null) {
            try {
                this.construct();
            }
            catch (UncheckedXPathException uncheckedXPathException) {
                throw uncheckedXPathException.getXPathException();
            }
        }
        this.node.sendNamespaceDeclarations(receiver, bl);
    }

    public int[] getDeclaredNamespaces(int[] nArray) {
        if (this.node == null) {
            this.tryToConstruct();
        }
        return this.node.getDeclaredNamespaces(nArray);
    }

    public void setSystemId(String string) {
    }

    public CharSequence getStringValueCS() {
        if (this.node == null) {
            try {
                PullProvider pullProvider = this.getPuller();
                pullProvider.next();
                return pullProvider.getStringValue();
            }
            catch (XPathException xPathException) {
                throw new UncheckedXPathException(xPathException);
            }
        }
        return this.node.getStringValueCS();
    }

    public SequenceIterator getTypedValue() throws XPathException {
        if (this.node == null) {
            this.construct();
        }
        return this.node.getTypedValue();
    }

    public Value atomize() throws XPathException {
        if (this.node == null) {
            this.construct();
        }
        return this.node.atomize();
    }
}

