/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.pull;

import net.sf.saxon.om.FastStringBuffer;
import net.sf.saxon.om.NamePool;
import net.sf.saxon.pull.PullFilter;
import net.sf.saxon.pull.PullProvider;
import net.sf.saxon.trans.XPathException;

public class PullTracer
extends PullFilter {
    private NamePool pool;

    public PullTracer(PullProvider pullProvider) {
        super(pullProvider);
    }

    public int next() throws XPathException {
        this.currentEvent = super.next();
        this.traceEvent(this.currentEvent);
        return this.currentEvent;
    }

    private void traceEvent(int n2) {
        if (this.pool == null) {
            this.pool = this.getPipelineConfiguration().getConfiguration().getNamePool();
        }
        PullProvider pullProvider = this.getUnderlyingProvider();
        switch (n2) {
            case 2: {
                System.err.println("START_DOCUMENT");
                break;
            }
            case 4: {
                System.err.println("START_ELEMENT " + this.pool.getDisplayName(pullProvider.getNameCode()));
                break;
            }
            case 8: {
                System.err.println("TEXT");
                try {
                    CharSequence charSequence = this.getStringValue();
                    FastStringBuffer fastStringBuffer = new FastStringBuffer(charSequence.length() * 5);
                    fastStringBuffer.append('(');
                    for (int i2 = 0; i2 < charSequence.length(); ++i2) {
                        fastStringBuffer.append(charSequence.charAt(i2) + " ");
                    }
                    fastStringBuffer.append(')');
                    System.err.println(fastStringBuffer);
                }
                catch (XPathException xPathException) {}
                break;
            }
            case 9: {
                System.err.println("COMMENT");
                break;
            }
            case 10: {
                System.err.println("PROCESSING_INSTRUCTION");
                break;
            }
            case 5: {
                int n3 = pullProvider.getNameCode();
                System.err.println("END_ELEMENT " + (n3 == -1 ? "" : this.pool.getDisplayName(n3)));
                break;
            }
            case 3: {
                System.err.println("END_DOCUMENT");
                break;
            }
            case -1: {
                System.err.println("END_OF_INPUT");
                break;
            }
            case 1: {
                try {
                    System.err.println("ATOMIC VALUE: " + pullProvider.getStringValue());
                    break;
                }
                catch (XPathException xPathException) {
                    // empty catch block
                }
            }
        }
    }
}

