/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.pattern;

import net.sf.saxon.om.AxisIterator;
import net.sf.saxon.om.NamePool;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.pattern.NodeTest;
import net.sf.saxon.tinytree.TinyTree;

public class DocumentNodeTest
extends NodeTest {
    private NodeTest elementTest;

    public DocumentNodeTest(NodeTest nodeTest) {
        this.elementTest = nodeTest;
    }

    public boolean matches(int n2, int n3, int n4) {
        throw new UnsupportedOperationException("DocumentNodeTest doesn't support this method");
    }

    public boolean matches(TinyTree tinyTree, int n2) {
        if (tinyTree.getNodeKind(n2) != 9) {
            return false;
        }
        return this.matches(tinyTree.getNode(n2));
    }

    public boolean matches(NodeInfo nodeInfo) {
        if (nodeInfo.getNodeKind() != 9) {
            return false;
        }
        AxisIterator axisIterator = nodeInfo.iterateAxis((byte)3);
        boolean bl = false;
        while (true) {
            NodeInfo nodeInfo2;
            if ((nodeInfo2 = (NodeInfo)axisIterator.next()) == null) {
                return bl;
            }
            int n2 = nodeInfo2.getNodeKind();
            if (n2 == 3) {
                return false;
            }
            if (n2 != 1) continue;
            if (bl) {
                return false;
            }
            if (!this.elementTest.matches(nodeInfo2)) break;
            bl = true;
        }
        return false;
    }

    public final double getDefaultPriority() {
        return this.elementTest.getDefaultPriority();
    }

    public int getPrimitiveType() {
        return 9;
    }

    public int getNodeKindMask() {
        return 512;
    }

    public NodeTest getElementTest() {
        return this.elementTest;
    }

    public String toString(NamePool namePool) {
        return "document-node(" + this.elementTest.toString(namePool) + ')';
    }

    public String toString() {
        return "document-node(" + this.elementTest.toString() + ')';
    }

    public int hashCode() {
        return this.elementTest.hashCode() ^ 0x3039;
    }

    public boolean equals(Object object) {
        return object instanceof DocumentNodeTest && ((DocumentNodeTest)object).elementTest.equals(this.elementTest);
    }
}

