/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.pattern;

import net.sf.saxon.expr.Token;
import net.sf.saxon.om.NamePool;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.pattern.ContentTypeTest;
import net.sf.saxon.pattern.NameTest;
import net.sf.saxon.pattern.NodeTest;
import net.sf.saxon.pattern.SubstitutionGroupTest;
import net.sf.saxon.sort.IntHashSet;
import net.sf.saxon.tinytree.TinyTree;
import net.sf.saxon.type.AnyType;
import net.sf.saxon.type.AtomicType;
import net.sf.saxon.type.ItemType;
import net.sf.saxon.type.SchemaType;
import net.sf.saxon.type.Type;
import net.sf.saxon.type.TypeHierarchy;

public class CombinedNodeTest
extends NodeTest {
    private NodeTest nodetest1;
    private NodeTest nodetest2;
    private int operator;
    private boolean isGlobalComponentTest;

    public CombinedNodeTest(NodeTest nodeTest, int n2, NodeTest nodeTest2) {
        this.nodetest1 = nodeTest;
        this.operator = n2;
        this.nodetest2 = nodeTest2;
    }

    public void setGlobalComponentTest(boolean bl) {
        this.isGlobalComponentTest = bl;
    }

    public boolean matches(int n2, int n3, int n4) {
        switch (this.operator) {
            case 1: {
                return this.nodetest1 == null || this.nodetest2 == null || this.nodetest1.matches(n2, n3, n4) || this.nodetest2.matches(n2, n3, n4);
            }
            case 23: {
                return !(this.nodetest1 != null && !this.nodetest1.matches(n2, n3, n4) || this.nodetest2 != null && !this.nodetest2.matches(n2, n3, n4));
            }
            case 24: {
                return (this.nodetest1 == null || this.nodetest1.matches(n2, n3, n4)) && this.nodetest2 != null && !this.nodetest2.matches(n2, n3, n4);
            }
        }
        throw new IllegalArgumentException("Unknown operator in Combined Node Test");
    }

    public boolean matches(TinyTree tinyTree, int n2) {
        switch (this.operator) {
            case 1: {
                return this.nodetest1 == null || this.nodetest2 == null || this.nodetest1.matches(tinyTree, n2) || this.nodetest2.matches(tinyTree, n2);
            }
            case 23: {
                return !(this.nodetest1 != null && !this.nodetest1.matches(tinyTree, n2) || this.nodetest2 != null && !this.nodetest2.matches(tinyTree, n2));
            }
            case 24: {
                return (this.nodetest1 == null || this.nodetest1.matches(tinyTree, n2)) && this.nodetest2 != null && !this.nodetest2.matches(tinyTree, n2);
            }
        }
        throw new IllegalArgumentException("Unknown operator in Combined Node Test");
    }

    public boolean matches(NodeInfo nodeInfo) {
        switch (this.operator) {
            case 1: {
                return this.nodetest1 == null || this.nodetest2 == null || this.nodetest1.matches(nodeInfo) || this.nodetest2.matches(nodeInfo);
            }
            case 23: {
                return !(this.nodetest1 != null && !this.nodetest1.matches(nodeInfo) || this.nodetest2 != null && !this.nodetest2.matches(nodeInfo));
            }
            case 24: {
                return (this.nodetest1 == null || this.nodetest1.matches(nodeInfo)) && this.nodetest2 != null && !this.nodetest2.matches(nodeInfo);
            }
        }
        throw new IllegalArgumentException("Unknown operator in Combined Node Test");
    }

    public String toString(NamePool namePool) {
        if (this.isGlobalComponentTest) {
            if (this.nodetest1 instanceof SubstitutionGroupTest) {
                return this.nodetest1.toString(namePool);
            }
            int n2 = this.nodetest1.getPrimitiveType();
            String string = n2 == 1 ? "schema-element(" : "schema-attribute(";
            String string2 = namePool.getClarkName(this.nodetest1.getFingerprint());
            return string + string2 + ')';
        }
        if (this.nodetest1 instanceof NameTest && this.operator == 23) {
            Object object;
            int n3 = this.nodetest1.getPrimitiveType();
            String string = n3 == 1 ? "element(" : "attribute(";
            String string3 = "";
            if (this.nodetest2 instanceof ContentTypeTest) {
                object = ((ContentTypeTest)this.nodetest2).getSchemaType();
                string3 = ", " + namePool.getClarkName(object.getFingerprint());
            }
            object = namePool.getClarkName(this.nodetest1.getFingerprint());
            return string + (String)object + string3 + ')';
        }
        String string = this.nodetest1 == null ? "true()" : this.nodetest1.toString(namePool);
        String string4 = this.nodetest2 == null ? "true()" : this.nodetest2.toString(namePool);
        return '(' + string + ' ' + Token.tokens[this.operator] + ' ' + string4 + ')';
    }

    public ItemType getSuperType(TypeHierarchy typeHierarchy) {
        switch (this.operator) {
            case 1: {
                return Type.getCommonSuperType(this.nodetest1, this.nodetest2, typeHierarchy);
            }
            case 23: {
                return this.nodetest1;
            }
            case 24: {
                return this.nodetest1;
            }
        }
        throw new IllegalArgumentException("Unknown operator in Combined Node Test");
    }

    public int getNodeKindMask() {
        switch (this.operator) {
            case 1: {
                return this.nodetest1.getNodeKindMask() | this.nodetest2.getNodeKindMask();
            }
            case 23: {
                return this.nodetest1.getNodeKindMask() & this.nodetest2.getNodeKindMask();
            }
            case 24: {
                return this.nodetest1.getNodeKindMask();
            }
        }
        return 0;
    }

    public int getPrimitiveType() {
        int n2 = this.getNodeKindMask();
        if (n2 == 2) {
            return 1;
        }
        if (n2 == 4) {
            return 2;
        }
        if (n2 == 512) {
            return 9;
        }
        return 0;
    }

    public IntHashSet getRequiredNodeNames() {
        IntHashSet intHashSet = this.nodetest1.getRequiredNodeNames();
        IntHashSet intHashSet2 = this.nodetest2.getRequiredNodeNames();
        if (intHashSet2 == null) {
            return intHashSet;
        }
        if (intHashSet == null) {
            return intHashSet2;
        }
        switch (this.operator) {
            case 1: {
                return intHashSet.union(intHashSet2);
            }
            case 23: {
                return intHashSet.intersect(intHashSet2);
            }
            case 24: {
                return intHashSet.except(intHashSet2);
            }
        }
        throw new UnsupportedOperationException();
    }

    public SchemaType getContentType() {
        SchemaType schemaType;
        SchemaType schemaType2 = this.nodetest1.getContentType();
        if (schemaType2.isSameType(schemaType = this.nodetest2.getContentType())) {
            return schemaType2;
        }
        if (this.operator == 23) {
            if (schemaType instanceof AnyType) {
                return schemaType2;
            }
            if (schemaType2 instanceof AnyType) {
                return schemaType;
            }
        }
        return AnyType.getInstance();
    }

    public AtomicType getAtomizedItemType() {
        AtomicType atomicType;
        AtomicType atomicType2 = this.nodetest1.getAtomizedItemType();
        if (atomicType2.isSameType(atomicType = this.nodetest2.getAtomizedItemType())) {
            return atomicType2;
        }
        if (this.operator == 23) {
            if (atomicType == Type.ANY_ATOMIC_TYPE) {
                return atomicType2;
            }
            if (atomicType2 == Type.ANY_ATOMIC_TYPE) {
                return atomicType;
            }
        }
        return Type.ANY_ATOMIC_TYPE;
    }

    public int getFingerprint() {
        int n2;
        int n3 = this.nodetest1.getFingerprint();
        if (n3 == (n2 = this.nodetest2.getFingerprint())) {
            return n3;
        }
        if (n2 == -1 && this.operator == 23) {
            return n3;
        }
        if (n3 == -1 && this.operator == 23) {
            return n2;
        }
        return -1;
    }

    public int hashCode() {
        return this.nodetest1.hashCode() ^ this.nodetest2.hashCode();
    }

    public boolean equals(Object object) {
        return object instanceof CombinedNodeTest && ((CombinedNodeTest)object).nodetest1.equals(this.nodetest1) && ((CombinedNodeTest)object).nodetest2.equals(this.nodetest2) && ((CombinedNodeTest)object).operator == this.operator;
    }

    public double getDefaultPriority() {
        return 0.25;
    }

    public NodeTest[] getComponentNodeTests() {
        NodeTest[] nodeTestArray = new NodeTest[]{this.nodetest1, this.nodetest2};
        return nodeTestArray;
    }
}

