/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.om;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.List;
import net.sf.saxon.Controller;
import net.sf.saxon.event.Receiver;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.ReversibleIterator;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.functions.EscapeURI;
import net.sf.saxon.om.AxisIterator;
import net.sf.saxon.om.AxisIteratorImpl;
import net.sf.saxon.om.EmptyIterator;
import net.sf.saxon.om.FastStringBuffer;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.NamePool;
import net.sf.saxon.om.NamespaceIterator;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.om.SiblingCountingNode;
import net.sf.saxon.om.SingletonIterator;
import net.sf.saxon.pattern.AnyNodeTest;
import net.sf.saxon.pattern.NameTest;
import net.sf.saxon.pattern.NodeKindTest;
import net.sf.saxon.pattern.NodeTest;
import net.sf.saxon.pattern.NodeTestPattern;
import net.sf.saxon.pattern.Pattern;
import net.sf.saxon.tinytree.TinyNodeImpl;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.value.SequenceExtent;
import net.sf.saxon.value.Whitespace;

public final class Navigator {
    private static int[] nodeCategories = new int[]{-1, 3, 2, 3, -1, -1, -1, 3, 3, 0, -1, -1, -1, 1};

    private Navigator() {
    }

    public static String getAttributeValue(NodeInfo nodeInfo, String string, String string2) {
        int n2 = nodeInfo.getNamePool().allocate("", string, string2);
        return nodeInfo.getAttributeValue(n2);
    }

    public static String getBaseURI(NodeInfo nodeInfo) {
        String string = nodeInfo.getAttributeValue(385);
        if (string != null) {
            URI uRI;
            String string2 = ((Object)EscapeURI.iriToUri(string)).toString();
            try {
                uRI = new URI(string2);
                if (!uRI.isAbsolute()) {
                    String string3;
                    NodeInfo nodeInfo2 = nodeInfo.getParent();
                    if (nodeInfo2 == null) {
                        return uRI.toString();
                    }
                    String string4 = nodeInfo.getSystemId();
                    if (string4.equals(string3 = nodeInfo2.getSystemId())) {
                        URI uRI2 = new URI(nodeInfo.getParent().getBaseURI());
                        uRI = uRI2.resolve(uRI);
                    } else {
                        URI uRI3 = new URI(string4);
                        uRI = uRI3.resolve(uRI);
                    }
                }
            }
            catch (URISyntaxException uRISyntaxException) {
                return string;
            }
            return uRI.toString();
        }
        String string5 = nodeInfo.getSystemId();
        NodeInfo nodeInfo3 = nodeInfo.getParent();
        if (nodeInfo3 == null) {
            return string5;
        }
        String string6 = nodeInfo3.getSystemId();
        if (string5.equals(string6)) {
            return nodeInfo3.getBaseURI();
        }
        return string5;
    }

    public static void sendNamespaceDeclarations(NodeInfo nodeInfo, Receiver receiver, boolean bl) throws XPathException {
        if (nodeInfo.getNodeKind() == 1) {
            int[] nArray = bl ? new NamespaceIterator(nodeInfo, null).getInScopeNamespaceCodes() : nodeInfo.getDeclaredNamespaces(NodeInfo.EMPTY_NAMESPACE_LIST);
            for (int i2 = 0; i2 < nArray.length && nArray[i2] != -1; ++i2) {
                receiver.namespace(nArray[i2], 0);
            }
        }
    }

    public static String getPath(NodeInfo nodeInfo) {
        if (nodeInfo == null) {
            return "";
        }
        NodeInfo nodeInfo2 = nodeInfo.getParent();
        switch (nodeInfo.getNodeKind()) {
            case 9: {
                return "/";
            }
            case 1: {
                if (nodeInfo2 == null) {
                    return nodeInfo.getDisplayName();
                }
                String string = Navigator.getPath(nodeInfo2);
                if (string.equals("/")) {
                    return '/' + nodeInfo.getDisplayName();
                }
                return string + '/' + nodeInfo.getDisplayName() + '[' + Navigator.getNumberSimple(nodeInfo) + ']';
            }
            case 2: {
                return Navigator.getPath(nodeInfo2) + "/@" + nodeInfo.getDisplayName();
            }
            case 3: {
                String string = Navigator.getPath(nodeInfo2);
                return (string.equals("/") ? "" : string) + "/text()[" + Navigator.getNumberSimple(nodeInfo) + ']';
            }
            case 8: {
                String string = Navigator.getPath(nodeInfo2);
                return (string.equals("/") ? "" : string) + "/comment()[" + Navigator.getNumberSimple(nodeInfo) + ']';
            }
            case 7: {
                String string = Navigator.getPath(nodeInfo2);
                return (string.equals("/") ? "" : string) + "/processing-instruction()[" + Navigator.getNumberSimple(nodeInfo) + ']';
            }
            case 13: {
                String string = nodeInfo.getLocalPart();
                if (string.equals("")) {
                    string = "*[not(local-name()]";
                }
                return Navigator.getPath(nodeInfo2) + "/namespace::" + string;
            }
        }
        return "";
    }

    public static int getNumberSimple(NodeInfo nodeInfo, XPathContext xPathContext) throws XPathException {
        NodeInfo nodeInfo2;
        int n2 = nodeInfo.getFingerprint();
        NodeTest nodeTest = n2 == -1 ? NodeKindTest.makeNodeKindTest(nodeInfo.getNodeKind()) : new NameTest(nodeInfo);
        AxisIterator axisIterator = nodeInfo.iterateAxis((byte)11, nodeTest);
        int n3 = 1;
        while ((nodeInfo2 = (NodeInfo)axisIterator.next()) != null) {
            Controller controller = xPathContext.getController();
            int n4 = controller.getRememberedNumber(nodeInfo2);
            if (n4 > 0) {
                controller.setRememberedNumber(nodeInfo, n4 += n3);
                return n4;
            }
            ++n3;
        }
        xPathContext.getController().setRememberedNumber(nodeInfo, n3);
        return n3;
    }

    private static int getNumberSimple(NodeInfo nodeInfo) {
        int n2 = nodeInfo.getFingerprint();
        NodeTest nodeTest = n2 == -1 ? NodeKindTest.makeNodeKindTest(nodeInfo.getNodeKind()) : new NameTest(nodeInfo);
        AxisIterator axisIterator = nodeInfo.iterateAxis((byte)11, nodeTest);
        int n3 = 1;
        while (axisIterator.next() != null) {
            ++n3;
        }
        return n3;
    }

    public static int getNumberSingle(NodeInfo nodeInfo, Pattern pattern, Pattern pattern2, XPathContext xPathContext) throws XPathException {
        if (pattern == null && pattern2 == null) {
            return Navigator.getNumberSimple(nodeInfo, xPathContext);
        }
        boolean bl = false;
        if (pattern == null) {
            pattern = nodeInfo.getFingerprint() == -1 ? new NodeTestPattern(NodeKindTest.makeNodeKindTest(nodeInfo.getNodeKind())) : new NodeTestPattern(new NameTest(nodeInfo));
            bl = true;
        }
        NodeInfo nodeInfo2 = nodeInfo;
        while (!bl && !pattern.matches(nodeInfo2, xPathContext)) {
            if ((nodeInfo2 = nodeInfo2.getParent()) == null) {
                return 0;
            }
            if (pattern2 == null || !pattern2.matches(nodeInfo2, xPathContext)) continue;
            return 0;
        }
        AxisIterator axisIterator = nodeInfo2.iterateAxis((byte)11, pattern.getNodeTest());
        boolean bl2 = pattern instanceof NodeTestPattern;
        int n2 = 1;
        NodeInfo nodeInfo3;
        while ((nodeInfo3 = (NodeInfo)axisIterator.next()) != null) {
            if (!bl2 && !pattern.matches(nodeInfo3, xPathContext)) continue;
            ++n2;
        }
        return n2;
    }

    public static int getNumberAny(Expression expression, NodeInfo nodeInfo, Pattern pattern, Pattern pattern2, XPathContext xPathContext, boolean bl) throws XPathException {
        Object[] objectArray;
        Object[] objectArray2;
        boolean bl2;
        NodeInfo nodeInfo2 = null;
        int n2 = 0;
        Controller controller = xPathContext.getController();
        boolean bl3 = bl2 = !bl;
        if (bl2 && (objectArray2 = (Object[])controller.getUserData(expression, "xsl:number")) != null) {
            nodeInfo2 = (NodeInfo)objectArray2[0];
            n2 = (Integer)objectArray2[1];
        }
        int n3 = 0;
        if (pattern == null) {
            pattern = nodeInfo.getFingerprint() == -1 ? new NodeTestPattern(NodeKindTest.makeNodeKindTest(nodeInfo.getNodeKind())) : new NodeTestPattern(new NameTest(nodeInfo));
            n3 = 1;
        } else if (pattern.matches(nodeInfo, xPathContext)) {
            n3 = 1;
        }
        NodeTest nodeTest = pattern2 == null ? pattern.getNodeTest() : (pattern2.getNodeKind() == 1 && pattern.getNodeKind() == 1 ? NodeKindTest.ELEMENT : AnyNodeTest.getInstance());
        AxisIterator axisIterator = nodeInfo.iterateAxis((byte)13, nodeTest);
        boolean bl4 = false;
        while ((objectArray = (Object[])axisIterator.next()) != null) {
            if (pattern.matches((NodeInfo)objectArray, xPathContext)) {
                if (n3 == 1 && nodeInfo2 != null && objectArray.isSameNodeInfo(nodeInfo2)) {
                    n3 = n2 + 1;
                    bl4 = true;
                    break;
                }
                ++n3;
            }
            if (pattern2 == null || !pattern2.matches((NodeInfo)objectArray, xPathContext)) continue;
            bl4 = true;
            break;
        }
        if (!bl4 && pattern2 != null) {
            return 0;
        }
        if (bl2) {
            objectArray = new Object[]{nodeInfo, new Integer(n3)};
            controller.setUserData(expression, "xsl:number", objectArray);
        }
        return n3;
    }

    public static List getNumberMulti(NodeInfo nodeInfo, Pattern pattern, Pattern pattern2, XPathContext xPathContext) throws XPathException {
        ArrayList<Long> arrayList = new ArrayList<Long>(5);
        if (pattern == null) {
            pattern = nodeInfo.getFingerprint() == -1 ? new NodeTestPattern(NodeKindTest.makeNodeKindTest(nodeInfo.getNodeKind())) : new NodeTestPattern(new NameTest(nodeInfo));
        }
        NodeInfo nodeInfo2 = nodeInfo;
        do {
            if (!pattern.matches(nodeInfo2, xPathContext)) continue;
            int n2 = Navigator.getNumberSingle(nodeInfo2, pattern, null, xPathContext);
            arrayList.add(0, new Long(n2));
        } while ((nodeInfo2 = nodeInfo2.getParent()) != null && (pattern2 == null || !pattern2.matches(nodeInfo2, xPathContext)));
        return arrayList;
    }

    public static void copy(NodeInfo nodeInfo, Receiver receiver, NamePool namePool, int n2, boolean bl, int n3) throws XPathException {
        switch (nodeInfo.getNodeKind()) {
            case 9: {
                NodeInfo nodeInfo2;
                receiver.startDocument(0);
                AxisIterator axisIterator = nodeInfo.iterateAxis((byte)3, new AnyNodeTest());
                while ((nodeInfo2 = (NodeInfo)axisIterator.next()) != null) {
                    nodeInfo2.copy(receiver, n2, bl, n3);
                }
                receiver.endDocument();
                break;
            }
            case 1: {
                NodeInfo nodeInfo3;
                Object object;
                receiver.startElement(nodeInfo.getNameCode(), bl ? nodeInfo.getTypeAnnotation() : 641, 0, 0);
                if (n2 != 0) {
                    nodeInfo.sendNamespaceDeclarations(receiver, true);
                }
                AxisIterator axisIterator = nodeInfo.iterateAxis((byte)2, new AnyNodeTest());
                while ((object = (NodeInfo)axisIterator.next()) != null) {
                    object.copy(receiver, n2, bl, n3);
                }
                receiver.startContent();
                object = nodeInfo.iterateAxis((byte)3, new AnyNodeTest());
                while ((nodeInfo3 = (NodeInfo)object.next()) != null) {
                    nodeInfo3.copy(receiver, n2, bl, n3);
                }
                receiver.endElement();
                return;
            }
            case 2: {
                receiver.attribute(nodeInfo.getNameCode(), bl ? nodeInfo.getTypeAnnotation() : 642, nodeInfo.getStringValueCS(), 0, 0);
                return;
            }
            case 3: {
                receiver.characters(nodeInfo.getStringValueCS(), 0, 0);
                return;
            }
            case 8: {
                receiver.comment(nodeInfo.getStringValueCS(), 0, 0);
                return;
            }
            case 7: {
                receiver.processingInstruction(nodeInfo.getLocalPart(), nodeInfo.getStringValueCS(), 0, 0);
                return;
            }
            case 13: {
                receiver.namespace(namePool.allocateNamespaceCode(nodeInfo.getLocalPart(), nodeInfo.getStringValue()), 0);
                return;
            }
        }
    }

    public static int compareOrder(SiblingCountingNode siblingCountingNode, SiblingCountingNode siblingCountingNode2) {
        NodeInfo nodeInfo;
        SiblingCountingNode siblingCountingNode3 = siblingCountingNode2;
        if (siblingCountingNode.isSameNodeInfo(siblingCountingNode2)) {
            return 0;
        }
        NodeInfo nodeInfo2 = siblingCountingNode.getParent();
        if (nodeInfo2 == null) {
            return -1;
        }
        NodeInfo nodeInfo3 = siblingCountingNode2.getParent();
        if (nodeInfo3 == null) {
            return 1;
        }
        if (nodeInfo2.isSameNodeInfo(nodeInfo3)) {
            int n2;
            int n3 = nodeCategories[siblingCountingNode.getNodeKind()];
            if (n3 == (n2 = nodeCategories[siblingCountingNode2.getNodeKind()])) {
                return siblingCountingNode.getSiblingPosition() - siblingCountingNode2.getSiblingPosition();
            }
            return n3 - n2;
        }
        int n4 = 0;
        int n5 = 0;
        NodeInfo nodeInfo4 = siblingCountingNode2;
        for (nodeInfo = siblingCountingNode; nodeInfo != null; nodeInfo = nodeInfo.getParent()) {
            ++n4;
        }
        while (nodeInfo4 != null) {
            ++n5;
            nodeInfo4 = nodeInfo4.getParent();
        }
        nodeInfo = siblingCountingNode;
        while (n4 > n5) {
            if ((nodeInfo = nodeInfo.getParent()).isSameNodeInfo(siblingCountingNode2)) {
                return 1;
            }
            --n4;
        }
        nodeInfo4 = siblingCountingNode3;
        while (n5 > n4) {
            if ((nodeInfo4 = nodeInfo4.getParent()).isSameNodeInfo(siblingCountingNode)) {
                return -1;
            }
            --n5;
        }
        while (true) {
            NodeInfo nodeInfo5 = nodeInfo.getParent();
            NodeInfo nodeInfo6 = nodeInfo4.getParent();
            if (nodeInfo5 == null || nodeInfo6 == null) {
                throw new NullPointerException("DOM/JDOM tree compare - internal error");
            }
            if (nodeInfo5.isSameNodeInfo(nodeInfo6)) {
                return ((SiblingCountingNode)nodeInfo).getSiblingPosition() - ((SiblingCountingNode)nodeInfo4).getSiblingPosition();
            }
            nodeInfo = nodeInfo5;
            nodeInfo4 = nodeInfo6;
        }
    }

    public static void appendSequentialKey(SiblingCountingNode siblingCountingNode, FastStringBuffer fastStringBuffer, boolean bl) {
        NodeInfo nodeInfo;
        if (bl) {
            fastStringBuffer.append('w');
            fastStringBuffer.append(Integer.toString(siblingCountingNode.getDocumentNumber()));
        }
        if (siblingCountingNode.getNodeKind() != 9 && (nodeInfo = siblingCountingNode.getParent()) != null) {
            Navigator.appendSequentialKey((SiblingCountingNode)nodeInfo, fastStringBuffer, false);
        }
        fastStringBuffer.append(Navigator.alphaKey(siblingCountingNode.getSiblingPosition()));
    }

    public static String alphaKey(int n2) {
        if (n2 < 1) {
            return "a";
        }
        if (n2 < 10) {
            return "b" + n2;
        }
        if (n2 < 100) {
            return "c" + n2;
        }
        if (n2 < 1000) {
            return "d" + n2;
        }
        if (n2 < 10000) {
            return "e" + n2;
        }
        if (n2 < 100000) {
            return "f" + n2;
        }
        if (n2 < 1000000) {
            return "g" + n2;
        }
        if (n2 < 10000000) {
            return "h" + n2;
        }
        if (n2 < 100000000) {
            return "i" + n2;
        }
        if (n2 < 1000000000) {
            return "j" + n2;
        }
        return "k" + n2;
    }

    public static final boolean isWhite(CharSequence charSequence) {
        return Whitespace.isWhite(charSequence);
    }

    public static boolean isAncestorOrSelf(NodeInfo nodeInfo, NodeInfo nodeInfo2) {
        if (nodeInfo instanceof TinyNodeImpl) {
            if (nodeInfo2 instanceof TinyNodeImpl) {
                return ((TinyNodeImpl)nodeInfo).isAncestorOrSelf((TinyNodeImpl)nodeInfo2);
            }
            if (nodeInfo2.getNodeKind() != 13) {
                return false;
            }
        }
        for (NodeInfo nodeInfo3 = nodeInfo2; nodeInfo3 != null; nodeInfo3 = nodeInfo3.getParent()) {
            if (!nodeInfo.isSameNodeInfo(nodeInfo3)) continue;
            return true;
        }
        return false;
    }

    public static AxisIterator filteredSingleton(NodeInfo nodeInfo, NodeTest nodeTest) {
        if (nodeInfo != null && (nodeTest == AnyNodeTest.getInstance() || nodeTest.matches(nodeInfo))) {
            return SingletonIterator.makeIterator(nodeInfo);
        }
        return EmptyIterator.getInstance();
    }

    public static final class PrecedingEnumeration
    extends BaseEnumeration {
        private NodeInfo start;
        private AxisIterator ancestorEnum = null;
        private AxisIterator siblingEnum = null;
        private AxisIterator descendEnum = null;
        private boolean includeAncestors;

        public PrecedingEnumeration(NodeInfo nodeInfo, boolean bl) {
            this.start = nodeInfo;
            this.includeAncestors = bl;
            this.ancestorEnum = new AncestorEnumeration(nodeInfo, false);
            switch (nodeInfo.getNodeKind()) {
                case 1: 
                case 3: 
                case 7: 
                case 8: {
                    this.siblingEnum = nodeInfo.iterateAxis((byte)11);
                    break;
                }
                default: {
                    this.siblingEnum = EmptyIterator.getInstance();
                }
            }
        }

        public void advance() {
            Item item;
            if (this.descendEnum != null) {
                item = this.descendEnum.next();
                if (item != null) {
                    this.current = item;
                    return;
                }
                this.descendEnum = null;
            }
            if (this.siblingEnum != null) {
                item = this.siblingEnum.next();
                if (item != null) {
                    NodeInfo nodeInfo = (NodeInfo)item;
                    if (nodeInfo.hasChildNodes()) {
                        this.descendEnum = new DescendantEnumeration(nodeInfo, true, false);
                        this.advance();
                    } else {
                        this.descendEnum = null;
                        this.current = nodeInfo;
                    }
                    return;
                }
                this.descendEnum = null;
                this.siblingEnum = null;
            }
            if ((item = this.ancestorEnum.next()) != null) {
                this.current = item;
                NodeInfo nodeInfo = (NodeInfo)this.current;
                this.siblingEnum = nodeInfo.getNodeKind() == 9 ? EmptyIterator.getInstance() : nodeInfo.iterateAxis((byte)11);
                if (!this.includeAncestors) {
                    this.advance();
                }
            } else {
                this.current = null;
            }
        }

        public SequenceIterator getAnother() {
            return new PrecedingEnumeration(this.start, this.includeAncestors);
        }
    }

    public static final class FollowingEnumeration
    extends BaseEnumeration {
        private NodeInfo start;
        private AxisIterator ancestorEnum = null;
        private AxisIterator siblingEnum = null;
        private AxisIterator descendEnum = null;

        public FollowingEnumeration(NodeInfo nodeInfo) {
            this.start = nodeInfo;
            this.ancestorEnum = new AncestorEnumeration(nodeInfo, false);
            switch (nodeInfo.getNodeKind()) {
                case 1: 
                case 3: 
                case 7: 
                case 8: {
                    this.siblingEnum = nodeInfo.iterateAxis((byte)7);
                    break;
                }
                case 2: 
                case 13: {
                    NodeInfo nodeInfo2 = nodeInfo.getParent();
                    if (nodeInfo2 == null) {
                        this.siblingEnum = EmptyIterator.getInstance();
                        break;
                    }
                    this.siblingEnum = nodeInfo2.iterateAxis((byte)3);
                    break;
                }
                default: {
                    this.siblingEnum = EmptyIterator.getInstance();
                }
            }
        }

        public void advance() {
            Item item;
            if (this.descendEnum != null) {
                item = this.descendEnum.next();
                if (item != null) {
                    this.current = item;
                    return;
                }
                this.descendEnum = null;
            }
            if (this.siblingEnum != null) {
                item = this.siblingEnum.next();
                if (item != null) {
                    this.current = item;
                    NodeInfo nodeInfo = (NodeInfo)this.current;
                    this.descendEnum = nodeInfo.hasChildNodes() ? new DescendantEnumeration(nodeInfo, false, true) : null;
                    return;
                }
                this.descendEnum = null;
                this.siblingEnum = null;
            }
            if ((item = this.ancestorEnum.next()) != null) {
                this.current = item;
                NodeInfo nodeInfo = (NodeInfo)this.current;
                this.siblingEnum = nodeInfo.getNodeKind() == 9 ? EmptyIterator.getInstance() : nodeInfo.iterateAxis((byte)7);
                this.advance();
            } else {
                this.current = null;
            }
        }

        public SequenceIterator getAnother() {
            return new FollowingEnumeration(this.start);
        }
    }

    public static final class DescendantEnumeration
    extends BaseEnumeration {
        private AxisIterator children = null;
        private AxisIterator descendants = null;
        private NodeInfo start;
        private boolean includeSelf;
        private boolean forwards;
        private boolean atEnd = false;

        public DescendantEnumeration(NodeInfo nodeInfo, boolean bl, boolean bl2) {
            this.start = nodeInfo;
            this.includeSelf = bl;
            this.forwards = bl2;
        }

        public void advance() {
            Item item;
            if (this.descendants != null) {
                item = this.descendants.next();
                if (item != null) {
                    this.current = item;
                    return;
                }
                this.descendants = null;
            }
            if (this.children != null) {
                item = (NodeInfo)this.children.next();
                if (item != null) {
                    if (item.hasChildNodes()) {
                        if (this.forwards) {
                            this.descendants = new DescendantEnumeration((NodeInfo)item, false, this.forwards);
                            this.current = item;
                        } else {
                            this.descendants = new DescendantEnumeration((NodeInfo)item, true, this.forwards);
                            this.advance();
                        }
                    } else {
                        this.current = item;
                    }
                } else if (this.forwards || !this.includeSelf) {
                    this.current = null;
                } else {
                    this.atEnd = true;
                    this.children = null;
                    this.current = this.start;
                }
            } else if (this.atEnd) {
                this.current = null;
            } else {
                if (this.start.hasChildNodes()) {
                    this.children = this.start.iterateAxis((byte)3);
                    if (!this.forwards) {
                        if (this.children instanceof ReversibleIterator) {
                            this.children = (AxisIterator)((ReversibleIterator)((Object)this.children)).getReverseIterator();
                        } else {
                            try {
                                this.children = new SequenceExtent(this.start.iterateAxis((byte)3)).reverseIterate();
                            }
                            catch (XPathException xPathException) {
                                throw new AssertionError((Object)("Internal error in Navigator#descendantEnumeration: " + xPathException.getMessage()));
                            }
                        }
                    }
                } else {
                    this.children = EmptyIterator.getInstance();
                }
                if (this.forwards && this.includeSelf) {
                    this.current = this.start;
                } else {
                    this.advance();
                }
            }
        }

        public SequenceIterator getAnother() {
            return new DescendantEnumeration(this.start, this.includeSelf, this.forwards);
        }
    }

    public static final class AncestorEnumeration
    extends BaseEnumeration {
        private boolean includeSelf;
        private boolean atStart;
        private NodeInfo start;

        public AncestorEnumeration(NodeInfo nodeInfo, boolean bl) {
            this.start = nodeInfo;
            this.includeSelf = bl;
            this.current = nodeInfo;
            this.atStart = true;
        }

        public void advance() {
            if (this.atStart) {
                this.atStart = false;
                if (this.includeSelf) {
                    return;
                }
            }
            this.current = ((NodeInfo)this.current).getParent();
        }

        public SequenceIterator getAnother() {
            return new AncestorEnumeration(this.start, this.includeSelf);
        }
    }

    public static abstract class BaseEnumeration
    extends AxisIteratorImpl {
        public final Item next() {
            this.advance();
            return this.current;
        }

        public abstract void advance();

        public abstract SequenceIterator getAnother();
    }

    public static class AxisFilter
    extends AxisIteratorImpl {
        private AxisIterator base;
        private NodeTest nodeTest;

        public AxisFilter(AxisIterator axisIterator, NodeTest nodeTest) {
            this.base = axisIterator;
            this.nodeTest = nodeTest;
            this.position = 0;
        }

        public Item next() {
            do {
                this.current = this.base.next();
                if (this.current != null) continue;
                this.position = -1;
                return null;
            } while (!this.nodeTest.matches((NodeInfo)this.current));
            ++this.position;
            return this.current;
        }

        public SequenceIterator getAnother() {
            return new AxisFilter((AxisIterator)this.base.getAnother(), this.nodeTest);
        }
    }
}

