/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.om;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import net.sf.saxon.om.NamePool;
import net.sf.saxon.om.NamespaceDeclarations;
import net.sf.saxon.om.NamespaceResolver;

public class NamespaceResolverAsDeclarations
implements NamespaceDeclarations {
    private NamePool pool;
    private NamespaceResolver resolver;
    private List prefixes;

    public NamespaceResolverAsDeclarations(NamePool namePool, NamespaceResolver namespaceResolver) {
        this.pool = namePool;
        this.resolver = namespaceResolver;
        this.prefixes = new ArrayList(10);
        Iterator iterator = namespaceResolver.iteratePrefixes();
        while (iterator.hasNext()) {
            this.prefixes.add(iterator.next());
        }
    }

    public int getNumberOfNamespaces() {
        return this.prefixes.size();
    }

    public String getPrefix(int n2) {
        return (String)this.prefixes.get(n2);
    }

    public String getURI(int n2) {
        return this.resolver.getURIForPrefix((String)this.prefixes.get(n2), true);
    }

    public int getNamespaceCode(int n2) {
        String string = this.getPrefix(n2);
        String string2 = this.getURI(n2);
        return this.pool.allocateNamespaceCode(string, string2);
    }

    public int[] getNamespaceCodes(int[] nArray) {
        if (nArray.length < this.getNumberOfNamespaces()) {
            nArray = new int[this.getNumberOfNamespaces()];
        }
        for (int i2 = 0; i2 < this.getNumberOfNamespaces(); ++i2) {
            nArray[i2] = this.getNamespaceCode(i2);
        }
        return nArray;
    }
}

