/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.om;

import net.sf.saxon.Configuration;
import net.sf.saxon.event.Receiver;
import net.sf.saxon.om.AxisIterator;
import net.sf.saxon.om.DocumentInfo;
import net.sf.saxon.om.EmptyIterator;
import net.sf.saxon.om.FastStringBuffer;
import net.sf.saxon.om.FingerprintedNode;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.NamePool;
import net.sf.saxon.om.Navigator;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.om.PrependIterator;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.om.SingletonIterator;
import net.sf.saxon.pattern.AnyNodeTest;
import net.sf.saxon.pattern.NodeKindTest;
import net.sf.saxon.pattern.NodeTest;
import net.sf.saxon.sort.IntHashSet;
import net.sf.saxon.sort.IntIterator;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.value.StringValue;
import net.sf.saxon.value.Value;

public class NamespaceIterator
implements AxisIterator {
    private NodeInfo element;
    private NodeTest test;
    private int index;
    private int position;
    private NamespaceNodeImpl next;
    private NamespaceNodeImpl current;
    private IntIterator nsIterator;
    private int count;

    public NamespaceIterator(NodeInfo nodeInfo, NodeTest nodeTest) {
        this.element = nodeInfo;
        this.test = nodeTest;
        if (nodeTest instanceof AnyNodeTest || nodeTest == NodeKindTest.NAMESPACE) {
            this.test = null;
        }
        this.index = -1;
        IntHashSet intHashSet = new IntHashSet(8);
        IntHashSet intHashSet2 = new IntHashSet(8);
        int[] nArray = new int[8];
        intHashSet2.add(65537);
        for (NodeInfo nodeInfo2 = nodeInfo; nodeInfo2 != null && nodeInfo2.getNodeKind() == 1; nodeInfo2 = nodeInfo2.getParent()) {
            int[] nArray2 = nodeInfo2.getDeclaredNamespaces(nArray);
            if (nArray2 == null) continue;
            for (int i2 = 0; i2 < nArray2.length && nArray2[i2] != -1; ++i2) {
                short s2 = (short)(nArray2[i2] & 0xFFFF);
                short s3 = (short)(nArray2[i2] >> 16);
                if (s2 == 0) {
                    intHashSet.add(s3);
                    continue;
                }
                if (intHashSet.contains(s3)) continue;
                intHashSet2.add(nArray2[i2]);
                intHashSet.add(s3);
            }
        }
        this.count = intHashSet2.size();
        this.nsIterator = intHashSet2.iterator();
    }

    public void advance() {
        while (this.nsIterator.hasNext()) {
            int n2 = this.nsIterator.next();
            this.next = new NamespaceNodeImpl(this.element, n2, ++this.index);
            if (this.test != null && !this.test.matches(this.next)) continue;
            return;
        }
        this.next = null;
    }

    public Item next() {
        if (this.index == -1) {
            this.advance();
            this.index = 0;
        }
        this.current = this.next;
        if (this.current == null) {
            this.position = -1;
            return null;
        }
        this.advance();
        ++this.position;
        return this.current;
    }

    public Item current() {
        return this.current;
    }

    public int position() {
        return this.position;
    }

    public SequenceIterator getAnother() {
        return new NamespaceIterator(this.element, this.test);
    }

    public int getProperties() {
        return 0;
    }

    public int[] getInScopeNamespaceCodes() {
        int[] nArray = new int[this.count];
        int n2 = 0;
        while (this.nsIterator.hasNext()) {
            nArray[n2++] = this.nsIterator.next();
        }
        return nArray;
    }

    public static class NamespaceNodeImpl
    implements NodeInfo,
    FingerprintedNode {
        NodeInfo element;
        int nscode;
        int position;
        int namecode;

        public NamespaceNodeImpl(NodeInfo nodeInfo, int n2, int n3) {
            this.element = nodeInfo;
            this.nscode = n2;
            this.position = n3;
            NamePool namePool = nodeInfo.getNamePool();
            String string = namePool.getPrefixFromNamespaceCode(n2);
            this.namecode = "".equals(string) ? -1 : namePool.allocate("", "", string);
        }

        public int getNodeKind() {
            return 13;
        }

        public boolean isSameNodeInfo(NodeInfo nodeInfo) {
            if (!(nodeInfo instanceof NamespaceNodeImpl)) {
                return false;
            }
            return this.element.isSameNodeInfo(((NamespaceNodeImpl)nodeInfo).element) && this.nscode == ((NamespaceNodeImpl)nodeInfo).nscode;
        }

        public boolean equals(Object object) {
            if (object instanceof NodeInfo) {
                return this.isSameNodeInfo((NodeInfo)object);
            }
            return false;
        }

        public int hashCode() {
            return ((Object)this.element).hashCode() ^ this.position << 13;
        }

        public String getSystemId() {
            return this.element.getSystemId();
        }

        public String getBaseURI() {
            return null;
        }

        public int getLineNumber() {
            return this.element.getLineNumber();
        }

        public int compareOrder(NodeInfo nodeInfo) {
            if (nodeInfo instanceof NamespaceNodeImpl && this.element.isSameNodeInfo(((NamespaceNodeImpl)nodeInfo).element)) {
                int n2 = this.position - ((NamespaceNodeImpl)nodeInfo).position;
                if (n2 == 0) {
                    return 0;
                }
                if (n2 < 0) {
                    return -1;
                }
                return 1;
            }
            if (this.element.isSameNodeInfo(nodeInfo)) {
                return 1;
            }
            return this.element.compareOrder(nodeInfo);
        }

        public String getStringValue() {
            return this.element.getNamePool().getURIFromURICode((short)(this.nscode & 0xFFFF));
        }

        public CharSequence getStringValueCS() {
            return this.getStringValue();
        }

        public int getNameCode() {
            return this.namecode;
        }

        public int getFingerprint() {
            if (this.namecode == -1) {
                return -1;
            }
            return this.namecode & 0xFFFFF;
        }

        public String getLocalPart() {
            if (this.namecode == -1) {
                return "";
            }
            return this.element.getNamePool().getLocalName(this.namecode);
        }

        public String getURI() {
            return "";
        }

        public String getDisplayName() {
            return this.getLocalPart();
        }

        public String getPrefix() {
            return "";
        }

        public Configuration getConfiguration() {
            return this.element.getConfiguration();
        }

        public NamePool getNamePool() {
            return this.element.getNamePool();
        }

        public int getTypeAnnotation() {
            return -1;
        }

        public NodeInfo getParent() {
            return this.element;
        }

        public AxisIterator iterateAxis(byte by) {
            return this.iterateAxis(by, new AnyNodeTest());
        }

        public AxisIterator iterateAxis(byte by, NodeTest nodeTest) {
            switch (by) {
                case 0: {
                    return this.element.iterateAxis((byte)1, nodeTest);
                }
                case 1: {
                    if (nodeTest.matches(this)) {
                        return new PrependIterator(this, this.element.iterateAxis((byte)1, nodeTest));
                    }
                    return this.element.iterateAxis((byte)1, nodeTest);
                }
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 7: 
                case 8: 
                case 11: {
                    return EmptyIterator.getInstance();
                }
                case 6: {
                    return new Navigator.AxisFilter(new Navigator.FollowingEnumeration(this), nodeTest);
                }
                case 9: {
                    if (nodeTest.matches(this.element)) {
                        return SingletonIterator.makeIterator(this.element);
                    }
                    return EmptyIterator.getInstance();
                }
                case 10: {
                    return new Navigator.AxisFilter(new Navigator.PrecedingEnumeration(this, false), nodeTest);
                }
                case 12: {
                    if (nodeTest.matches(this)) {
                        return SingletonIterator.makeIterator(this);
                    }
                    return EmptyIterator.getInstance();
                }
                case 13: {
                    return new Navigator.AxisFilter(new Navigator.PrecedingEnumeration(this, true), nodeTest);
                }
            }
            throw new IllegalArgumentException("Unknown axis number " + by);
        }

        public String getAttributeValue(int n2) {
            return null;
        }

        public NodeInfo getRoot() {
            return this.element.getRoot();
        }

        public DocumentInfo getDocumentRoot() {
            return this.element.getDocumentRoot();
        }

        public boolean hasChildNodes() {
            return false;
        }

        public void generateId(FastStringBuffer fastStringBuffer) {
            this.element.generateId(fastStringBuffer);
            fastStringBuffer.append("n");
            fastStringBuffer.append(Integer.toString(this.position));
        }

        public int getDocumentNumber() {
            return this.element.getDocumentNumber();
        }

        public void copy(Receiver receiver, int n2, boolean bl, int n3) throws XPathException {
            receiver.namespace(this.nscode, 0);
        }

        public void sendNamespaceDeclarations(Receiver receiver, boolean bl) throws XPathException {
        }

        public int[] getDeclaredNamespaces(int[] nArray) {
            return null;
        }

        public void setSystemId(String string) {
        }

        public SequenceIterator getTypedValue() throws XPathException {
            return SingletonIterator.makeIterator(new StringValue(this.getStringValueCS()));
        }

        public Value atomize() throws XPathException {
            return new StringValue(this.getStringValueCS());
        }
    }
}

