/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.number;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import net.sf.saxon.number.NumberFormatter;
import net.sf.saxon.number.Numberer;
import net.sf.saxon.om.FastStringBuffer;
import net.sf.saxon.om.XMLChar;
import net.sf.saxon.value.DateTimeValue;
import net.sf.saxon.value.StringValue;

public class Numberer_en
implements Numberer,
Serializable {
    private String country;
    public static final int UPPER_CASE = 0;
    public static final int LOWER_CASE = 1;
    public static final int TITLE_CASE = 2;
    protected static final int[] westernDigits = new int[]{48, 49, 50, 51, 52, 53, 54, 55, 56, 57};
    protected static final String latinUpper = "ABCDEFGHIJKLMNOPQRSTUVWXYZ";
    protected static final String latinLower = "abcdefghijklmnopqrstuvwxyz";
    protected static final String greekUpper = "\u0391\u0392\u0393\u0394\u0395\u0396\u0397\u0398\u0399\u039a\u039b\u039c\u039c\u039d\u039e\u039f\u03a0\u03a1\u03a3\u03a4\u03a5\u03a6\u03a7\u03a8\u03a9";
    protected static final String greekLower = "\u03b1\u03b2\u03b3\u03b4\u03b5\u03b6\u03b7\u03b8\u03b9\u03ba\u03bb\u03bc\u03bc\u03bd\u03be\u03bf\u03c0\u03c1\u03c3\u03c4\u03c5\u03c6\u03c7\u03c8\u03c9";
    protected static final String cyrillicUpper = "\u0410\u0411\u0412\u0413\u0414\u0415\u0416\u0417\u0418\u041a\u041b\u041c\u041d\u041e\u041f\u0420\u0421\u0421\u0423\u0424\u0425\u0426\u0427\u0428\u0429\u042b\u042d\u042e\u042f";
    protected static final String cyrillicLower = "\u0430\u0431\u0432\u0433\u0434\u0435\u0436\u0437\u0438\u043a\u043b\u043c\u043d\u043e\u043f\u0440\u0441\u0441\u0443\u0444\u0445\u0446\u0447\u0448\u0449\u044b\u044d\u044e\u044f";
    protected static final String hebrew = "\u05d0\u05d1\u05d2\u05d3\u05d4\u05d5\u05d6\u05d7\u05d8\u05d9\u05db\u05dc\u05de\u05e0\u05e1\u05e2\u05e4\u05e6\u05e7\u05e8\u05e9\u05ea";
    protected static final String hiraganaA = "\u3042\u3044\u3046\u3048\u304a\u304b\u304d\u304f\u3051\u3053\u3055\u3057\u3059\u305b\u305d\u305f\u3061\u3064\u3066\u3068\u306a\u306b\u306c\u306d\u306e\u306f\u3072\u3075\u3078\u307b\u307e\u307f\u3080\u3081\u3082\u3084\u3086\u3088\u3089\u308a\u308b\u308c\u308d\u308f\u3092\u3093";
    protected static final String katakanaA = "\u30a2\u30a4\u30a6\u30a8\u30aa\u30ab\u30ad\u30af\u30b1\u30b3\u30b5\u30b7\u30b9\u30bb\u30bd\u30bf\u30c1\u30c4\u30c6\u30c8\u30ca\u30cb\u30cc\u30cd\u30ce\u30cf\u30d2\u30d5\u30d8\u30db\u30de\u30df\u30e0\u30e1\u30e2\u30e4\u30e6\u30e8\u30e9\u30ea\u30eb\u30ec\u30ed\u30ef\u30f2\u30f3";
    protected static final String hiraganaI = "\u3044\u308d\u306f\u306b\u307b\u3078\u3068\u3061\u308a\u306c\u308b\u3092\u308f\u304b\u3088\u305f\u308c\u305d\u3064\u306d\u306a\u3089\u3080\u3046\u3090\u306e\u304a\u304f\u3084\u307e\u3051\u3075\u3053\u3048\u3066\u3042\u3055\u304d\u3086\u3081\u307f\u3057\u3091\u3072\u3082\u305b\u3059";
    protected static final String katakanaI = "\u30a4\u30ed\u30cf\u30cb\u30db\u30d8\u30c8\u30c1\u30ea\u30cc\u30eb\u30f2\u30ef\u30ab\u30e8\u30bf\u30ec\u30bd\u30c4\u30cd\u30ca\u30e9\u30e0\u30a6\u30f0\u30ce\u30aa\u30af\u30e4\u30de\u30b1\u30d5\u30b3\u30a8\u30c6\u30a2\u30b5\u30ad\u30e6\u30e1\u30df\u30b7\u30f1\u30d2\u30e2\u30bb\u30b9";
    protected static final int[] kanjiDigits = new int[]{12295, 19968, 20108, 19977, 22235, 20116, 20845, 19971, 20843, 20061};
    private static String[] romanThousands = new String[]{"", "m", "mm", "mmm", "mmmm", "mmmmm", "mmmmmm", "mmmmmmm", "mmmmmmmm", "mmmmmmmmm"};
    private static String[] romanHundreds = new String[]{"", "c", "cc", "ccc", "cd", "d", "dc", "dcc", "dccc", "cm"};
    private static String[] romanTens = new String[]{"", "x", "xx", "xxx", "xl", "l", "lx", "lxx", "lxxx", "xc"};
    private static String[] romanUnits = new String[]{"", "i", "ii", "iii", "iv", "v", "vi", "vii", "viii", "ix"};
    private static String[] englishUnits = new String[]{"", "One", "Two", "Three", "Four", "Five", "Six", "Seven", "Eight", "Nine", "Ten", "Eleven", "Twelve", "Thirteen", "Fourteen", "Fifteen", "Sixteen", "Seventeen", "Eighteen", "Nineteen"};
    private static String[] englishTens = new String[]{"", "Ten", "Twenty", "Thirty", "Forty", "Fifty", "Sixty", "Seventy", "Eighty", "Ninety"};
    private static String[] englishOrdinalUnits = new String[]{"", "First", "Second", "Third", "Fourth", "Fifth", "Sixth", "Seventh", "Eighth", "Ninth", "Tenth", "Eleventh", "Twelfth", "Thirteenth", "Fourteenth", "Fifteenth", "Sixteenth", "Seventeenth", "Eighteenth", "Nineteenth"};
    private static String[] englishOrdinalTens = new String[]{"", "Tenth", "Twentieth", "Thirtieth", "Fortieth", "Fiftieth", "Sixtieth", "Seventieth", "Eightieth", "Ninetieth"};
    private static String[] englishMonths = new String[]{"January", "February", "March", "April", "May", "June", "July", "August", "September", "October", "November", "December"};
    private static String[] englishDays = new String[]{"Monday", "Tuesday", "Wednesday", "Thursday", "Friday", "Saturday", "Sunday"};
    private static String[] englishDayAbbreviations = new String[]{"Mon", "Tues", "Weds", "Thurs", "Fri", "Sat", "Sun"};
    private static int[] minUniqueDayLength = new int[]{2, 1, 2, 1, 2, 2, 1};
    static HashMap timezones = new HashMap(50);

    public void setCountry(String string) {
        this.country = string;
    }

    public String format(long l2, String string, int n2, String string2, String string3, String string4) {
        if (l2 < 0L) {
            return "" + l2;
        }
        if (string == null || string.length() == 0) {
            return "" + l2;
        }
        int n3 = StringValue.getStringLength(string);
        FastStringBuffer fastStringBuffer = new FastStringBuffer(16);
        int n4 = string.charAt(0);
        if (XMLChar.isHighSurrogate(n4)) {
            n4 = XMLChar.supplemental((char)n4, string.charAt(1));
        }
        switch (n4) {
            case 48: 
            case 49: {
                fastStringBuffer.append(this.toRadical(l2, westernDigits, n3, n2, string2));
                if (string4 == null || string4.length() <= 0) break;
                fastStringBuffer.append(this.ordinalSuffix(string4, l2));
                break;
            }
            case 65: {
                if (l2 == 0L) {
                    return "0";
                }
                fastStringBuffer.append(this.toAlphaSequence(l2, latinUpper));
                break;
            }
            case 97: {
                if (l2 == 0L) {
                    return "0";
                }
                fastStringBuffer.append(this.toAlphaSequence(l2, latinLower));
                break;
            }
            case 87: 
            case 119: {
                int n5 = string.equals("W") ? 0 : (string.equals("w") ? 1 : 2);
                if (string4 != null && string4.length() > 0) {
                    fastStringBuffer.append(this.toOrdinalWords(string4, l2, n5));
                    break;
                }
                fastStringBuffer.append(this.toWords(l2, n5));
                break;
            }
            case 105: {
                if (l2 == 0L) {
                    return "0";
                }
                if (string3 == null || string3.equals("") || string3.equals("traditional")) {
                    fastStringBuffer.append(Numberer_en.toRoman(l2));
                    break;
                }
                this.alphaDefault(l2, 'i', fastStringBuffer);
                break;
            }
            case 73: {
                if (l2 == 0L) {
                    return "0";
                }
                if (string3 == null || string3.equals("") || string3.equals("traditional")) {
                    fastStringBuffer.append(Numberer_en.toRoman(l2).toUpperCase());
                    break;
                }
                this.alphaDefault(l2, 'I', fastStringBuffer);
                break;
            }
            case 913: {
                if (l2 == 0L) {
                    return "0";
                }
                fastStringBuffer.append(this.toAlphaSequence(l2, greekUpper));
                break;
            }
            case 945: {
                if (l2 == 0L) {
                    return "0";
                }
                fastStringBuffer.append(this.toAlphaSequence(l2, greekLower));
                break;
            }
            case 1040: {
                if (l2 == 0L) {
                    return "0";
                }
                fastStringBuffer.append(this.toAlphaSequence(l2, cyrillicUpper));
                break;
            }
            case 1072: {
                if (l2 == 0L) {
                    return "0";
                }
                fastStringBuffer.append(this.toAlphaSequence(l2, cyrillicLower));
                break;
            }
            case 1488: {
                if (l2 == 0L) {
                    return "0";
                }
                fastStringBuffer.append(this.toAlphaSequence(l2, hebrew));
                break;
            }
            case 12354: {
                if (l2 == 0L) {
                    return "0";
                }
                fastStringBuffer.append(this.toAlphaSequence(l2, hiraganaA));
                break;
            }
            case 12450: {
                if (l2 == 0L) {
                    return "0";
                }
                fastStringBuffer.append(this.toAlphaSequence(l2, katakanaA));
                break;
            }
            case 12356: {
                if (l2 == 0L) {
                    return "0";
                }
                fastStringBuffer.append(this.toAlphaSequence(l2, hiraganaI));
                break;
            }
            case 12452: {
                if (l2 == 0L) {
                    return "0";
                }
                fastStringBuffer.append(this.toAlphaSequence(l2, katakanaI));
                break;
            }
            case 19968: {
                if (l2 == 0L) {
                    return "0";
                }
                fastStringBuffer.append(this.toRadical(l2, kanjiDigits, n3, n2, string2));
                break;
            }
            default: {
                int n6 = NumberFormatter.getDigitValue(n4);
                if (n6 >= 0) {
                    int n7 = n4 - n6;
                    int[] nArray = new int[10];
                    for (int i2 = 0; i2 <= 9; ++i2) {
                        nArray[i2] = n7 + i2;
                    }
                    fastStringBuffer.append(this.toRadical(l2, nArray, n3, n2, string2));
                    break;
                }
                if (l2 == 0L) {
                    return "0";
                }
                if (n4 < 4352) {
                    this.alphaDefault(l2, (char)n4, fastStringBuffer);
                    break;
                }
                fastStringBuffer.append(this.toRadical(l2, westernDigits, n3, n2, string2));
            }
        }
        return fastStringBuffer.toString();
    }

    protected String ordinalSuffix(String string, long l2) {
        int n2 = (int)(l2 % 100L) / 10;
        int n3 = (int)(l2 % 10L);
        if (n2 == 1) {
            return "th";
        }
        if (n3 == 1) {
            return "st";
        }
        if (n3 == 2) {
            return "nd";
        }
        if (n3 == 3) {
            return "rd";
        }
        return "th";
    }

    protected void alphaDefault(long l2, char n2, FastStringBuffer fastStringBuffer) {
        int n3 = n2;
        int n4 = n2;
        while (Character.isLetterOrDigit((char)(n4 + '\u0001'))) {
            ++n4;
        }
        fastStringBuffer.append(this.toAlpha(l2, n3, n4));
    }

    protected String toAlpha(long l2, int n2, int n3) {
        if (l2 <= 0L) {
            return "" + l2;
        }
        int n4 = n3 - n2 + 1;
        char c2 = (char)((l2 - 1L) % (long)n4 + (long)n2);
        if (l2 > (long)n4) {
            return this.toAlpha((l2 - 1L) / (long)n4, n2, n3) + c2;
        }
        return "" + c2;
    }

    protected String toAlphaSequence(long l2, String string) {
        if (l2 <= 0L) {
            return "" + l2;
        }
        int n2 = string.length();
        char c2 = string.charAt((int)((l2 - 1L) % (long)n2));
        if (l2 > (long)n2) {
            return this.toAlphaSequence((l2 - 1L) / (long)n2, string) + c2;
        }
        return "" + c2;
    }

    private String toRadical(long l2, int[] nArray, int n2, int n3, String string) {
        int n4;
        FastStringBuffer fastStringBuffer = new FastStringBuffer(16);
        FastStringBuffer fastStringBuffer2 = new FastStringBuffer(16);
        int n5 = nArray.length;
        int n6 = nArray[0] > 65535 ? 2 : 1;
        FastStringBuffer fastStringBuffer3 = new FastStringBuffer(16);
        int n7 = 0;
        for (long i2 = l2; i2 > 0L; i2 /= (long)n5) {
            n4 = nArray[(int)(i2 % (long)n5)];
            fastStringBuffer3.prependWideChar(n4);
            ++n7;
        }
        for (n4 = 0; n4 < n2 - n7; ++n4) {
            fastStringBuffer2.appendWideChar(nArray[0]);
        }
        fastStringBuffer2.append(fastStringBuffer3);
        if (n3 > 0) {
            n3 *= n6;
            for (n4 = 0; n4 < fastStringBuffer2.length(); ++n4) {
                if (n4 != 0 && (fastStringBuffer2.length() - n4) % n3 == 0) {
                    fastStringBuffer.append(string);
                }
                fastStringBuffer.append(fastStringBuffer2.charAt(n4));
            }
        } else {
            fastStringBuffer = fastStringBuffer2;
        }
        return fastStringBuffer.toString();
    }

    public static String toRoman(long l2) {
        if (l2 <= 0L || l2 > 9999L) {
            return "" + l2;
        }
        return romanThousands[(int)l2 / 1000] + romanHundreds[(int)l2 / 100 % 10] + romanTens[(int)l2 / 10 % 10] + romanUnits[(int)l2 % 10];
    }

    public String toWords(long l2) {
        if (l2 >= 1000000000L) {
            long l3 = l2 % 1000000000L;
            return this.toWords(l2 / 1000000000L) + " Billion" + (l3 == 0L ? "" : (l3 < 100L ? " and " : " ") + this.toWords(l3));
        }
        if (l2 >= 1000000L) {
            long l4 = l2 % 1000000L;
            return this.toWords(l2 / 1000000L) + " Million" + (l4 == 0L ? "" : (l4 < 100L ? " and " : " ") + this.toWords(l4));
        }
        if (l2 >= 1000L) {
            long l5 = l2 % 1000L;
            return this.toWords(l2 / 1000L) + " Thousand" + (l5 == 0L ? "" : (l5 < 100L ? " and " : " ") + this.toWords(l5));
        }
        if (l2 >= 100L) {
            long l6 = l2 % 100L;
            return this.toWords(l2 / 100L) + " Hundred" + (l6 == 0L ? "" : " and " + this.toWords(l6));
        }
        if (l2 < 20L) {
            return englishUnits[(int)l2];
        }
        int n2 = (int)(l2 % 10L);
        return englishTens[(int)l2 / 10] + (n2 == 0 ? "" : ' ' + englishUnits[n2]);
    }

    public String toWords(long l2, int n2) {
        String string = l2 == 0L ? "Zero" : this.toWords(l2);
        if (n2 == 0) {
            return string.toUpperCase();
        }
        if (n2 == 1) {
            return string.toLowerCase();
        }
        return string;
    }

    public String toOrdinalWords(String string, long l2, int n2) {
        String string2;
        if (l2 >= 1000000000L) {
            long l3 = l2 % 1000000000L;
            string2 = this.toWords(l2 / 1000000000L) + " Billion" + (l3 == 0L ? "th" : (l3 < 100L ? " and " : " ") + this.toOrdinalWords(string, l3, n2));
        } else if (l2 >= 1000000L) {
            long l4 = l2 % 1000000L;
            string2 = this.toWords(l2 / 1000000L) + " Million" + (l4 == 0L ? "th" : (l4 < 100L ? " and " : " ") + this.toOrdinalWords(string, l4, n2));
        } else if (l2 >= 1000L) {
            long l5 = l2 % 1000L;
            string2 = this.toWords(l2 / 1000L) + " Thousand" + (l5 == 0L ? "th" : (l5 < 100L ? " and " : " ") + this.toOrdinalWords(string, l5, n2));
        } else if (l2 >= 100L) {
            long l6 = l2 % 100L;
            string2 = this.toWords(l2 / 100L) + " Hundred" + (l6 == 0L ? "th" : " and " + this.toOrdinalWords(string, l6, n2));
        } else {
            int n3;
            string2 = l2 < 20L ? englishOrdinalUnits[(int)l2] : ((n3 = (int)(l2 % 10L)) == 0 ? englishOrdinalTens[(int)l2 / 10] : englishTens[(int)l2 / 10] + '-' + englishOrdinalUnits[n3]);
        }
        if (n2 == 0) {
            return string2.toUpperCase();
        }
        if (n2 == 1) {
            return string2.toLowerCase();
        }
        return string2;
    }

    public String monthName(int n2, int n3, int n4) {
        String string = englishMonths[n2 - 1];
        if (n4 < 3) {
            n4 = 3;
        }
        if (string.length() > n4) {
            string = string.substring(0, n4);
        }
        while (string.length() < n3) {
            string = string + ' ';
        }
        return string;
    }

    public String dayName(int n2, int n3, int n4) {
        String string = englishDays[n2 - 1];
        if (n4 < 2) {
            n4 = 2;
        }
        if (string.length() > n4 && (string = englishDayAbbreviations[n2 - 1]).length() > n4) {
            string = string.substring(0, n4);
        }
        while (string.length() < n3) {
            string = string + ' ';
        }
        if (n3 == 1 && n4 == 2) {
            string = string.substring(0, minUniqueDayLength[n2 - 1]);
        }
        return string;
    }

    public String halfDayName(int n2, int n3, int n4) {
        String string;
        if (n2 < 720) {
            switch (n4) {
                case 1: {
                    string = "A";
                    break;
                }
                case 2: 
                case 3: {
                    string = "Am";
                    break;
                }
                default: {
                    string = "A.M.";
                    break;
                }
            }
        } else {
            switch (n4) {
                case 1: {
                    string = "P";
                    break;
                }
                case 2: 
                case 3: {
                    string = "Pm";
                    break;
                }
                default: {
                    string = "P.M.";
                }
            }
        }
        return string;
    }

    public String getOrdinalSuffixForDateTime(String string) {
        return "yes";
    }

    public String getEraName(int n2) {
        return n2 > 0 ? "AD" : "BC";
    }

    public String getTimezoneName(int n2) {
        String string;
        List list = (List)timezones.get(new Integer(n2));
        if (list == null) {
            FastStringBuffer fastStringBuffer = new FastStringBuffer(10);
            DateTimeValue.appendTimezone(n2, fastStringBuffer);
            return fastStringBuffer.toString();
        }
        String string2 = string = this.country == null ? "us" : this.country;
        if (list.size() == 1) {
            return ((String[])list.get(0))[0];
        }
        for (int i2 = 0; i2 < list.size(); ++i2) {
            String[] stringArray = (String[])list.get(i2);
            if (!stringArray[1].equals(string)) continue;
            return stringArray[0];
        }
        return ((String[])list.get(0))[0];
    }

    static void tz(double d2, String string, String string2) {
        Integer n2 = new Integer((int)(d2 * 60.0));
        String[] stringArray = new String[]{string, string2};
        ArrayList<String[]> arrayList = (ArrayList<String[]>)timezones.get(n2);
        if (arrayList == null) {
            arrayList = new ArrayList<String[]>(3);
        }
        arrayList.add(stringArray);
        timezones.put(n2, arrayList);
    }

    public String getCalendarName(String string) {
        if (string.equals("AD")) {
            return "Gregorian";
        }
        return string;
    }

    static {
        Numberer_en.tz(9.5, "ACST", "au");
        Numberer_en.tz(10.0, "AEST", "au");
        Numberer_en.tz(-9.0, "AKST", "us");
        Numberer_en.tz(8.0, "AWST", "au");
        Numberer_en.tz(1.0, "BST", "gb");
        Numberer_en.tz(1.0, "CET", "eu");
        Numberer_en.tz(9.5, "CST", "au");
        Numberer_en.tz(-6.0, "CST", "us");
        Numberer_en.tz(7.0, "CXT", "au");
        Numberer_en.tz(2.0, "EET", "eu");
        Numberer_en.tz(10.0, "EST", "au");
        Numberer_en.tz(-5.0, "EST", "us");
        Numberer_en.tz(0.0, "GMT", "gb");
        Numberer_en.tz(-10.0, "HAST", "us");
        Numberer_en.tz(1.0, "MEZ", "de");
        Numberer_en.tz(-7.0, "MST", "us");
        Numberer_en.tz(11.5, "NFT", "au");
        Numberer_en.tz(-3.5, "NST", "us");
        Numberer_en.tz(-8.0, "PST", "us");
        Numberer_en.tz(0.0, "UTC", "eu");
        Numberer_en.tz(0.0, "WET", "eu");
        Numberer_en.tz(8.0, "WST", "au");
        Numberer_en.tz(10.5, "ACDT", "au*");
        Numberer_en.tz(-3.0, "ADT", "us*");
        Numberer_en.tz(11.0, "AEDT", "au*");
        Numberer_en.tz(-8.0, "AKDT", "us*");
        Numberer_en.tz(-4.0, "AST", "us*");
        Numberer_en.tz(10.5, "CDT", "au*");
        Numberer_en.tz(-5.0, "CDT", "us*");
        Numberer_en.tz(2.0, "CEDT", "eu*");
        Numberer_en.tz(11.0, "EDT", "au*");
        Numberer_en.tz(-4.0, "EDT", "us*");
        Numberer_en.tz(3.0, "EEDT", "eu*");
        Numberer_en.tz(-6.0, "MDT", "us*");
        Numberer_en.tz(2.0, "MESZ", "de*");
        Numberer_en.tz(-2.5, "NDT", "us*");
        Numberer_en.tz(-7.0, "PDT", "us*");
        Numberer_en.tz(1.0, "WEDT", "eu*");
    }
}

