/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.number;

import net.sf.saxon.number.Numberer_en;

public class Numberer_de
extends Numberer_en {
    private static String[] germanUnits = new String[]{"", "Eins", "Zwei", "Drei", "Vier", "F\u00fcnf", "Sechs", "Sieben", "Acht", "Neun", "Zehn", "Elf", "Zw\u00f6lf", "Dreizehn", "Vierzehn", "F\u00fcnfzehn", "Sechszehn", "Siebzehn", "Achtzehn", "Neunzehn"};
    private static String[] germanTens = new String[]{"", "Zehn", "Zwanzig", "Drei\u00dfig", "Vierzig", "F\u00fcnfzig", "Sechzig", "Siebzig", "Achtzig", "Neunzig"};
    private static String[] germanOrdinalUnits = new String[]{"", "Erst", "Zweit", "Dritt", "Viert", "F\u00fcnft", "Sechst", "Siebt", "Acht", "Neunt", "Zehnt", "Elft", "Zw\u00f6lft", "Dreizehnt", "Vierzehnt", "F\u00fcnfzehnt", "Sechszehnt", "Siebzehnt", "Achtzehnt", "Neunzehnt"};
    private static String[] germanMonths = new String[]{"Januar", "Februar", "M\u00e4rz", "April", "Mai", "Juni", "Juli", "August", "September", "Oktober", "November", "Dezember"};
    private static String[] germanDays = new String[]{"Montag", "Dienstag", "Mittwoch", "Donnerstag", "Freitag", "Samstag", "Sonntag"};

    protected String ordinalSuffix(String string, long l2) {
        return ".";
    }

    public String toWords(long l2) {
        if (l2 >= 1000000000L) {
            long l3 = l2 % 1000000000L;
            long l4 = l2 / 1000000000L;
            String string = l4 == 1L ? "Eine" : this.toWords(l4);
            return string + " Milliarde" + (l3 == 0L ? "" : ' ' + this.toWords(l3));
        }
        if (l2 >= 1000000L) {
            long l5 = l2 % 1000000L;
            long l6 = l2 / 1000000L;
            String string = l6 == 1L ? "Eine" : this.toWords(l6);
            return string + " Million" + (l5 == 0L ? "" : ' ' + this.toWords(l5));
        }
        if (l2 >= 1000L) {
            long l7 = l2 % 1000L;
            long l8 = l2 / 1000L;
            String string = l8 == 1L ? "Ein" : this.toWords(l8);
            return string + "tausend" + (l7 == 0L ? "" : ' ' + this.toWords(l7));
        }
        if (l2 >= 100L) {
            long l9 = l2 % 100L;
            long l10 = l2 / 100L;
            String string = l10 == 1L ? "Ein" : this.toWords(l10);
            return string + "hundert" + (l9 == 0L ? "" : (l9 > 20L ? "" : "und") + this.toWords(l9, 1));
        }
        if (l2 < 20L) {
            return germanUnits[(int)l2];
        }
        int n2 = (int)(l2 % 10L);
        int n3 = (int)l2 / 10;
        return germanUnits[n2] + (n3 == 0 ? "" : (n2 == 0 ? "" : "und") + germanTens[n3]);
    }

    public String toOrdinalWords(String string, long l2, int n2) {
        String string2 = "e";
        if (string.equalsIgnoreCase("-er")) {
            string2 = "er";
        } else if (string.equalsIgnoreCase("-es")) {
            string2 = "es";
        } else if (string.equalsIgnoreCase("-en")) {
            string2 = "en";
        }
        long l3 = l2 % 100L;
        if (l2 < 20L) {
            String string3 = germanOrdinalUnits[(int)l2] + string2;
            if (n2 == 0) {
                return string3.toUpperCase();
            }
            if (n2 == 1) {
                return string3.toLowerCase();
            }
            return string3;
        }
        if (l3 < 20L && l3 > 0L) {
            return this.toWords(l2 - l3, n2) + this.toOrdinalWords(string, l3, n2 == 2 ? 1 : n2);
        }
        String string4 = "st" + string2;
        if (n2 == 0) {
            string4 = string4.toUpperCase();
        }
        return this.toWords(l2, n2) + (n2 == 0 ? string4.toUpperCase() : string4);
    }

    public String monthName(int n2, int n3, int n4) {
        String string = germanMonths[n2 - 1];
        if (n4 < 3) {
            n4 = 3;
        }
        if (string.length() > n4) {
            string = string.substring(0, n4);
        }
        while (string.length() < n3) {
            string = string + " ";
        }
        return string;
    }

    public String dayName(int n2, int n3, int n4) {
        String string = germanDays[n2 - 1];
        if (n4 < 10) {
            string = string.substring(0, 2);
        }
        while (string.length() < n3) {
            string = string + ' ';
        }
        return string;
    }

    public String getOrdinalSuffixForDateTime(String string) {
        return "-e";
    }

    public String getEraName(int n2) {
        return n2 <= 0 ? "v. Chr." : "n. Chr.";
    }

    public String getCalendarName(String string) {
        if (string.equals("AD")) {
            return "Gregorianisch";
        }
        return string;
    }
}

