/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.instruct;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Iterator;
import net.sf.saxon.om.NamePool;
import net.sf.saxon.om.NamespaceResolver;

public final class SavedNamespaceContext
implements Serializable,
NamespaceResolver {
    private int[] namespaceCodes;
    private NamePool namePool;

    public SavedNamespaceContext(int[] nArray, NamePool namePool) {
        this.namespaceCodes = nArray;
        this.namePool = namePool;
    }

    public int[] getNamespaceCodes() {
        return this.namespaceCodes;
    }

    public String getURIForPrefix(String string, boolean bl) {
        if (string.equals("") && !bl) {
            return "";
        }
        if (string.equals("xml")) {
            return "http://www.w3.org/XML/1998/namespace";
        }
        for (int i2 = this.namespaceCodes.length - 1; i2 >= 0; --i2) {
            if (!this.namePool.getPrefixFromNamespaceCode(this.namespaceCodes[i2]).equals(string)) continue;
            return this.namePool.getURIFromNamespaceCode(this.namespaceCodes[i2]);
        }
        if (string.equals("") && bl) {
            return "";
        }
        return null;
    }

    public Iterator iteratePrefixes() {
        ArrayList<String> arrayList = new ArrayList<String>(this.namespaceCodes.length);
        for (int i2 = 0; i2 < this.namespaceCodes.length; ++i2) {
            arrayList.add(this.namePool.getPrefixFromNamespaceCode(this.namespaceCodes[i2]));
        }
        return arrayList.iterator();
    }
}

