/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.instruct;

import javax.xml.transform.SourceLocator;
import net.sf.saxon.Controller;
import net.sf.saxon.event.PipelineConfiguration;
import net.sf.saxon.event.SequenceOutputter;
import net.sf.saxon.event.SequenceReceiver;
import net.sf.saxon.expr.ComputedExpression;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.ExpressionLocation;
import net.sf.saxon.expr.PromotionOffer;
import net.sf.saxon.expr.StaticContext;
import net.sf.saxon.expr.UserFunctionCall;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.expr.XPathContextMinor;
import net.sf.saxon.instruct.InstructionDetails;
import net.sf.saxon.instruct.ParameterSet;
import net.sf.saxon.instruct.TailCall;
import net.sf.saxon.instruct.TailCallReturner;
import net.sf.saxon.instruct.TerminationException;
import net.sf.saxon.instruct.WithParam;
import net.sf.saxon.om.EmptyIterator;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.om.SingletonIterator;
import net.sf.saxon.om.ValueRepresentation;
import net.sf.saxon.trace.InstructionInfo;
import net.sf.saxon.trans.DynamicError;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.type.ItemType;
import net.sf.saxon.type.Type;
import net.sf.saxon.type.TypeHierarchy;
import net.sf.saxon.value.Value;

public abstract class Instruction
extends ComputedExpression
implements SourceLocator,
TailCallReturner {
    public int getImplementationMethod() {
        return 4;
    }

    public int getInstructionNameCode() {
        return -1;
    }

    public ItemType getItemType(TypeHierarchy typeHierarchy) {
        return Type.ITEM_TYPE;
    }

    public int computeCardinality() {
        return 57344;
    }

    public abstract TailCall processLeavingTail(XPathContext var1) throws XPathException;

    public void process(XPathContext xPathContext) throws XPathException {
        for (TailCall tailCall = this.processLeavingTail(xPathContext); tailCall != null; tailCall = tailCall.processLeavingTail()) {
        }
    }

    public SourceLocator getSourceLocator() {
        return this;
    }

    protected static XPathException dynamicError(SourceLocator sourceLocator, XPathException xPathException, XPathContext xPathContext) {
        if (xPathException instanceof TerminationException) {
            return xPathException;
        }
        if (xPathException.getLocator() == null || xPathException.getLocator() instanceof ExpressionLocation && xPathContext.getController().getExecutable().getHostLanguage() != 51 || xPathException.getLocator().getLineNumber() == -1) {
            try {
                DynamicError dynamicError = new DynamicError(xPathException.getMessage(), sourceLocator, xPathException.getException());
                if (xPathException instanceof DynamicError) {
                    dynamicError.setErrorCode(xPathException.getErrorCodeLocalPart());
                    if (((DynamicError)xPathException).getXPathContext() == null) {
                        dynamicError.setXPathContext(xPathContext);
                    } else {
                        dynamicError.setXPathContext(((DynamicError)xPathException).getXPathContext());
                    }
                }
                return dynamicError;
            }
            catch (Exception exception) {
                return xPathException;
            }
        }
        return xPathException;
    }

    protected static ParameterSet assembleParams(XPathContext xPathContext, WithParam[] withParamArray) throws XPathException {
        if (withParamArray == null || withParamArray.length == 0) {
            return null;
        }
        ParameterSet parameterSet = new ParameterSet(withParamArray.length);
        for (int i2 = 0; i2 < withParamArray.length; ++i2) {
            parameterSet.put(withParamArray[i2].getVariableFingerprint(), withParamArray[i2].getSelectValue(xPathContext));
        }
        return parameterSet;
    }

    protected static ParameterSet assembleTunnelParams(XPathContext xPathContext, WithParam[] withParamArray) throws XPathException {
        ParameterSet parameterSet = xPathContext.getTunnelParameters();
        if (parameterSet == null) {
            return Instruction.assembleParams(xPathContext, withParamArray);
        }
        ParameterSet parameterSet2 = new ParameterSet(parameterSet, withParamArray == null ? 0 : withParamArray.length);
        if (withParamArray == null || withParamArray.length == 0) {
            return parameterSet2;
        }
        for (int i2 = 0; i2 < withParamArray.length; ++i2) {
            parameterSet2.put(withParamArray[i2].getVariableFingerprint(), withParamArray[i2].getSelectValue(xPathContext));
        }
        return parameterSet2;
    }

    public abstract Expression simplify(StaticContext var1) throws XPathException;

    public int computeSpecialProperties() {
        int n2 = super.computeSpecialProperties();
        if (this.createsNewNodes()) {
            return n2;
        }
        return n2 | 0x400000;
    }

    public boolean createsNewNodes() {
        return false;
    }

    protected void promoteInst(PromotionOffer promotionOffer) throws XPathException {
    }

    public Expression promote(PromotionOffer promotionOffer) throws XPathException {
        Expression expression = promotionOffer.accept(this);
        if (expression != null) {
            return expression;
        }
        this.promoteInst(promotionOffer);
        return this;
    }

    public Item evaluateItem(XPathContext xPathContext) throws XPathException {
        int n2 = this.getImplementationMethod();
        if ((n2 & 1) != 0) {
            throw new AssertionError((Object)("evaluateItem() is not implemented in the subclass " + this.getClass()));
        }
        if ((n2 & 2) != 0) {
            return this.iterate(xPathContext).next();
        }
        Controller controller = xPathContext.getController();
        XPathContextMinor xPathContextMinor = xPathContext.newMinorContext();
        xPathContextMinor.setOrigin(this);
        SequenceOutputter sequenceOutputter = controller.allocateSequenceOutputter(1);
        PipelineConfiguration pipelineConfiguration = controller.makePipelineConfiguration();
        pipelineConfiguration.setHostLanguage(this.getHostLanguage());
        sequenceOutputter.setPipelineConfiguration(pipelineConfiguration);
        xPathContextMinor.setTemporaryReceiver(sequenceOutputter);
        this.process(xPathContextMinor);
        sequenceOutputter.close();
        Item item = sequenceOutputter.getFirstItem();
        sequenceOutputter.reset();
        return item;
    }

    public SequenceIterator iterate(XPathContext xPathContext) throws XPathException {
        int n2 = this.getImplementationMethod();
        if ((n2 & 1) != 0) {
            Item item = this.evaluateItem(xPathContext);
            if (item == null) {
                return EmptyIterator.getInstance();
            }
            return SingletonIterator.makeIterator(item);
        }
        if ((n2 & 2) != 0) {
            throw new AssertionError((Object)("iterate() is not implemented in the subclass " + this.getClass()));
        }
        Controller controller = xPathContext.getController();
        XPathContextMinor xPathContextMinor = xPathContext.newMinorContext();
        xPathContextMinor.setOrigin(this);
        SequenceOutputter sequenceOutputter = controller.allocateSequenceOutputter(20);
        PipelineConfiguration pipelineConfiguration = controller.makePipelineConfiguration();
        pipelineConfiguration.setHostLanguage(this.getHostLanguage());
        sequenceOutputter.setPipelineConfiguration(pipelineConfiguration);
        xPathContextMinor.setTemporaryReceiver(sequenceOutputter);
        this.process(xPathContextMinor);
        sequenceOutputter.close();
        return sequenceOutputter.iterate();
    }

    public final String evaluateAsString(XPathContext xPathContext) throws XPathException {
        Item item = this.evaluateItem(xPathContext);
        if (item == null) {
            return "";
        }
        return item.getStringValue();
    }

    public InstructionInfo getInstructionInfo() {
        InstructionDetails instructionDetails = new InstructionDetails();
        instructionDetails.setSystemId(this.getSystemId());
        instructionDetails.setLineNumber(this.getLineNumber());
        instructionDetails.setConstructType(this.getInstructionNameCode());
        return instructionDetails;
    }

    public static void appendItem(Item item, SequenceReceiver sequenceReceiver, int n2) throws XPathException {
        block0: while (true) {
            if (item == null) {
                return;
            }
            if (!(item instanceof UserFunctionCall.FunctionCallPackage)) break;
            UserFunctionCall.FunctionCallPackage functionCallPackage = (UserFunctionCall.FunctionCallPackage)item;
            ValueRepresentation valueRepresentation = functionCallPackage.call();
            SequenceIterator sequenceIterator = Value.getIterator(valueRepresentation);
            while (true) {
                Item item2;
                if ((item2 = sequenceIterator.next()) == null) {
                    item = null;
                    continue block0;
                }
                if (item2 instanceof UserFunctionCall.FunctionCallPackage) {
                    item = item2;
                    continue block0;
                }
                sequenceReceiver.append(item2, n2, 2);
            }
            break;
        }
        sequenceReceiver.append(item, n2, 2);
    }

    public boolean isXSLT() {
        return this.getHostLanguage() == 50;
    }
}

