/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.instruct;

import java.io.PrintStream;
import net.sf.saxon.Configuration;
import net.sf.saxon.Controller;
import net.sf.saxon.event.PipelineConfiguration;
import net.sf.saxon.event.SequenceReceiver;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.ExpressionTool;
import net.sf.saxon.expr.StaticContext;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.expr.XPathContextMinor;
import net.sf.saxon.instruct.ParentNodeConstructor;
import net.sf.saxon.instruct.TailCall;
import net.sf.saxon.om.AtomizableIterator;
import net.sf.saxon.om.DocumentInfo;
import net.sf.saxon.om.FastStringBuffer;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.pattern.NodeKindTest;
import net.sf.saxon.pull.UnconstructedDocument;
import net.sf.saxon.tinytree.TinyBuilder;
import net.sf.saxon.trans.DynamicError;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.type.ItemType;
import net.sf.saxon.type.TypeHierarchy;
import net.sf.saxon.value.TextFragmentValue;

public class DocumentInstr
extends ParentNodeConstructor {
    private boolean textOnly;
    private String constantText;
    private String baseURI;

    public DocumentInstr(boolean bl, String string, String string2) {
        this.textOnly = bl;
        this.constantText = string;
        this.baseURI = string2;
    }

    public int getImplementationMethod() {
        return 1;
    }

    public void setValidationAction(int n2) {
        this.validation = n2;
    }

    public Expression simplify(StaticContext staticContext) throws XPathException {
        this.setLazyConstruction(staticContext.getConfiguration().isLazyConstructionMode());
        return super.simplify(staticContext);
    }

    public Expression typeCheck(StaticContext staticContext, ItemType itemType) throws XPathException {
        Expression expression = super.typeCheck(staticContext, itemType);
        return expression;
    }

    public ItemType getItemType(TypeHierarchy typeHierarchy) {
        return NodeKindTest.DOCUMENT;
    }

    public TailCall processLeavingTail(XPathContext xPathContext) throws XPathException {
        Item item = this.evaluateItem(xPathContext);
        if (item != null) {
            SequenceReceiver sequenceReceiver = xPathContext.getReceiver();
            sequenceReceiver.append(item, this.locationId, 2);
        }
        return null;
    }

    public Item evaluateItem(XPathContext xPathContext) throws XPathException {
        DocumentInfo documentInfo;
        if (this.isLazyConstruction()) {
            return new UnconstructedDocument(this, xPathContext);
        }
        Controller controller = xPathContext.getController();
        if (this.textOnly) {
            CharSequence charSequence;
            if (this.constantText != null) {
                charSequence = this.constantText;
            } else {
                Item item;
                FastStringBuffer fastStringBuffer = new FastStringBuffer(100);
                SequenceIterator sequenceIterator = this.content.iterate(xPathContext);
                if (sequenceIterator instanceof AtomizableIterator) {
                    ((AtomizableIterator)sequenceIterator).setIsAtomizing(true);
                }
                while ((item = sequenceIterator.next()) != null) {
                    fastStringBuffer.append(item.getStringValueCS());
                }
                charSequence = fastStringBuffer.condense();
            }
            documentInfo = new TextFragmentValue(charSequence, this.baseURI);
            documentInfo.setConfiguration(controller.getConfiguration());
        } else {
            try {
                XPathContextMinor xPathContextMinor = xPathContext.newMinorContext();
                xPathContextMinor.setOrigin(this);
                TinyBuilder tinyBuilder = new TinyBuilder();
                tinyBuilder.setLineNumbering(controller.getConfiguration().isLineNumbering());
                TinyBuilder tinyBuilder2 = tinyBuilder;
                tinyBuilder2.setSystemId(this.baseURI);
                PipelineConfiguration pipelineConfiguration = controller.makePipelineConfiguration();
                pipelineConfiguration.setHostLanguage(this.getHostLanguage());
                tinyBuilder2.setPipelineConfiguration(pipelineConfiguration);
                xPathContextMinor.changeOutputDestination(null, tinyBuilder2, false, this.getHostLanguage(), this.validation, this.getSchemaType());
                SequenceReceiver sequenceReceiver = xPathContextMinor.getReceiver();
                sequenceReceiver.open();
                sequenceReceiver.startDocument(0);
                this.content.process(xPathContextMinor);
                sequenceReceiver.endDocument();
                sequenceReceiver.close();
                documentInfo = (DocumentInfo)tinyBuilder.getCurrentRoot();
            }
            catch (XPathException xPathException) {
                if (xPathException.getLocator() == null) {
                    xPathException.setLocator(this);
                }
                if (xPathException instanceof DynamicError && ((DynamicError)xPathException).getXPathContext() == null) {
                    ((DynamicError)xPathException).setXPathContext(xPathContext);
                }
                throw xPathException;
            }
        }
        return documentInfo;
    }

    public int getInstructionNameCode() {
        return 142;
    }

    public void display(int n2, PrintStream printStream, Configuration configuration) {
        printStream.println(ExpressionTool.indent(n2) + "document-constructor");
        this.content.display(n2 + 1, printStream, configuration);
    }
}

