/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.instruct;

import java.io.PrintStream;
import java.util.Iterator;
import net.sf.saxon.Configuration;
import net.sf.saxon.Controller;
import net.sf.saxon.event.CopyNamespaceSensitiveException;
import net.sf.saxon.event.NoOpenStartTagException;
import net.sf.saxon.event.PipelineConfiguration;
import net.sf.saxon.event.Receiver;
import net.sf.saxon.event.SequenceOutputter;
import net.sf.saxon.event.SequenceReceiver;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.ExpressionTool;
import net.sf.saxon.expr.ItemMappingFunction;
import net.sf.saxon.expr.ItemMappingIterator;
import net.sf.saxon.expr.MonoIterator;
import net.sf.saxon.expr.Optimizer;
import net.sf.saxon.expr.PromotionOffer;
import net.sf.saxon.expr.StaticContext;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.expr.XPathContextMinor;
import net.sf.saxon.instruct.DummyNamespaceResolver;
import net.sf.saxon.instruct.Executable;
import net.sf.saxon.instruct.Instruction;
import net.sf.saxon.instruct.TailCall;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.om.Validation;
import net.sf.saxon.om.VirtualCopy;
import net.sf.saxon.pattern.ContentTypeTest;
import net.sf.saxon.pattern.NodeKindTest;
import net.sf.saxon.trans.DynamicError;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.type.AtomicType;
import net.sf.saxon.type.ItemType;
import net.sf.saxon.type.SchemaType;
import net.sf.saxon.type.SimpleType;
import net.sf.saxon.type.TypeHierarchy;
import net.sf.saxon.type.UnresolvedReferenceException;
import net.sf.saxon.type.ValidationException;
import net.sf.saxon.value.AtomicValue;
import net.sf.saxon.value.Value;

public class CopyOf
extends Instruction {
    private Expression select;
    private boolean copyNamespaces;
    private int validation;
    private SchemaType schemaType;
    private boolean requireDocumentOrElement = false;
    private boolean rejectDuplicateAttributes;
    private boolean readOnce = false;

    public CopyOf(Expression expression, boolean bl, int n2, SchemaType schemaType, boolean bl2) {
        this.select = expression;
        this.copyNamespaces = bl;
        this.validation = n2;
        this.schemaType = schemaType;
        this.rejectDuplicateAttributes = bl2;
        this.adoptChildExpression(expression);
    }

    public void setReadOnce(boolean bl) {
        this.readOnce = bl;
    }

    public final boolean createsNewNodes() {
        Executable executable = this.getExecutable();
        if (executable == null) {
            return true;
        }
        TypeHierarchy typeHierarchy = executable.getConfiguration().getTypeHierarchy();
        return !this.select.getItemType(typeHierarchy).isAtomicType();
    }

    public int getInstructionNameCode() {
        return 140;
    }

    public void setRequireDocumentOrElement(boolean bl) {
        this.requireDocumentOrElement = bl;
    }

    public int getImplementationMethod() {
        return 6;
    }

    public TailCall processLeavingTail(XPathContext xPathContext) throws XPathException {
        Item item;
        Controller controller = xPathContext.getController();
        SequenceReceiver sequenceReceiver = xPathContext.getReceiver();
        int n2 = this.copyNamespaces ? 2 : 0;
        SequenceIterator sequenceIterator = this.select.iterate(xPathContext);
        block17: while ((item = sequenceIterator.next()) != null) {
            if (item instanceof NodeInfo) {
                Object object;
                NodeInfo nodeInfo = (NodeInfo)item;
                int n3 = nodeInfo.getNodeKind();
                if (this.requireDocumentOrElement && n3 != 1 && n3 != 9) {
                    object = new DynamicError("Operand of validate expression must be a document or element node");
                    ((DynamicError)object).setXPathContext(xPathContext);
                    ((XPathException)object).setErrorCode("XQTY0030");
                    throw object;
                }
                switch (n3) {
                    case 1: {
                        object = controller.getConfiguration().getElementValidator(sequenceReceiver, nodeInfo.getNameCode(), this.locationId, this.schemaType, this.validation, controller.getNamePool());
                        try {
                            nodeInfo.copy((Receiver)object, n2, true, this.locationId);
                            continue block17;
                        }
                        catch (CopyNamespaceSensitiveException copyNamespaceSensitiveException) {
                            copyNamespaceSensitiveException.setErrorCode(this.getHostLanguage() == 50 ? "XTTE0950" : "XQTY0086");
                            throw copyNamespaceSensitiveException;
                        }
                    }
                    case 2: {
                        try {
                            CopyOf.copyAttribute(nodeInfo, this.schemaType, this.validation, this, xPathContext, this.rejectDuplicateAttributes);
                            continue block17;
                        }
                        catch (NoOpenStartTagException noOpenStartTagException) {
                            DynamicError dynamicError = new DynamicError(noOpenStartTagException.getMessage());
                            dynamicError.setLocator(this);
                            dynamicError.setXPathContext(xPathContext);
                            dynamicError.setErrorCode(noOpenStartTagException.getErrorCodeLocalPart());
                            throw CopyOf.dynamicError(this, dynamicError, xPathContext);
                        }
                    }
                    case 3: {
                        sequenceReceiver.characters(nodeInfo.getStringValueCS(), this.locationId, 0);
                        continue block17;
                    }
                    case 7: {
                        sequenceReceiver.processingInstruction(nodeInfo.getDisplayName(), nodeInfo.getStringValueCS(), this.locationId, 0);
                        continue block17;
                    }
                    case 8: {
                        sequenceReceiver.comment(nodeInfo.getStringValueCS(), this.locationId, 0);
                        continue block17;
                    }
                    case 13: {
                        try {
                            nodeInfo.copy(sequenceReceiver, 0, false, this.locationId);
                            continue block17;
                        }
                        catch (NoOpenStartTagException noOpenStartTagException) {
                            DynamicError dynamicError = new DynamicError(noOpenStartTagException.getMessage());
                            dynamicError.setXPathContext(xPathContext);
                            dynamicError.setErrorCode(noOpenStartTagException.getErrorCodeLocalPart());
                            throw CopyOf.dynamicError(this, dynamicError, xPathContext);
                        }
                    }
                    case 9: {
                        Receiver receiver = controller.getConfiguration().getDocumentValidator(sequenceReceiver, nodeInfo.getBaseURI(), controller.getNamePool(), this.validation, 10, this.schemaType);
                        receiver.setPipelineConfiguration(sequenceReceiver.getPipelineConfiguration());
                        try {
                            nodeInfo.copy(receiver, n2, true, this.locationId);
                            continue block17;
                        }
                        catch (CopyNamespaceSensitiveException copyNamespaceSensitiveException) {
                            copyNamespaceSensitiveException.setErrorCode(this.getHostLanguage() == 50 ? "XTTE0950" : "XQTY0086");
                            throw copyNamespaceSensitiveException;
                        }
                    }
                }
                throw new IllegalArgumentException("Unknown node kind " + nodeInfo.getNodeKind());
            }
            sequenceReceiver.append(item, this.locationId, 2);
        }
        return null;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected static void copyAttribute(NodeInfo nodeInfo, SchemaType schemaType, int n2, Instruction instruction, XPathContext xPathContext, boolean bl) throws XPathException {
        SchemaType schemaType2;
        int n3 = nodeInfo.getNameCode();
        int n4 = 642;
        int n5 = 0;
        if (bl) {
            n5 |= 0x20;
        }
        CharSequence charSequence = nodeInfo.getStringValueCS();
        if (schemaType != null) {
            if (!schemaType.isSimpleType()) {
                DynamicError dynamicError = new DynamicError("Cannot validate an attribute against a complex type");
                dynamicError.setXPathContext(xPathContext);
                dynamicError.setErrorCode("XTSE1530");
                throw dynamicError;
            }
            if (((SimpleType)schemaType).isNamespaceSensitive()) {
                DynamicError dynamicError = new DynamicError("Cannot create a parentless attribute whose type is namespace-sensitive (such as xs:QName)");
                dynamicError.setErrorCode("XTTE1545");
                dynamicError.setXPathContext(xPathContext);
                dynamicError.setLocator(instruction);
                throw dynamicError;
            }
            try {
                ValidationException validationException = ((SimpleType)schemaType).validateContent(charSequence, DummyNamespaceResolver.getInstance(), xPathContext.getConfiguration().getNameChecker());
                if (validationException != null) {
                    throw new ValidationException("Attribute being copied does not match the required type. " + validationException.getMessage());
                }
                n4 = schemaType.getFingerprint();
            }
            catch (UnresolvedReferenceException unresolvedReferenceException) {
                throw new ValidationException(unresolvedReferenceException);
            }
        } else if (n2 == 1 || n2 == 2) {
            try {
                n4 = xPathContext.getConfiguration().validateAttribute(n3, charSequence, n2);
            }
            catch (ValidationException validationException) {
                DynamicError dynamicError = DynamicError.makeDynamicError(validationException);
                dynamicError.setErrorCode(validationException.getErrorCodeLocalPart());
                dynamicError.setXPathContext(xPathContext);
                dynamicError.setLocator(instruction);
                dynamicError.setIsTypeError(true);
                throw dynamicError;
            }
        } else if (n2 == 3 && (n4 = nodeInfo.getTypeAnnotation() & 0xFFFFF) != 642 && ((AtomicType)(schemaType2 = xPathContext.getConfiguration().getSchemaType(n4))).isNamespaceSensitive()) {
            DynamicError dynamicError = new DynamicError("Cannot preserve type annotation when copying an attribute with namespace-sensitive content");
            dynamicError.setErrorCode("XTTE0950");
            dynamicError.setIsTypeError(true);
            dynamicError.setXPathContext(xPathContext);
            throw dynamicError;
        }
        xPathContext.getReceiver().attribute(n3, n4, charSequence, instruction.getLocationId(), n5);
    }

    public Expression simplify(StaticContext staticContext) throws XPathException {
        this.select = this.select.simplify(staticContext);
        return this;
    }

    public ItemType getItemType(TypeHierarchy typeHierarchy) {
        if (this.schemaType != null) {
            Configuration configuration = this.getExecutable().getConfiguration();
            ItemType itemType = this.select.getItemType(typeHierarchy);
            int n2 = typeHierarchy.relationship(itemType, NodeKindTest.ELEMENT);
            if (n2 == 0 || n2 == 2) {
                return new ContentTypeTest(1, this.schemaType, configuration);
            }
            int n3 = typeHierarchy.relationship(itemType, NodeKindTest.ATTRIBUTE);
            if (n3 == 0 || n3 == 2) {
                return new ContentTypeTest(2, this.schemaType, configuration);
            }
        }
        return this.select.getItemType(typeHierarchy);
    }

    public int getCardinality() {
        return this.select.getCardinality();
    }

    public int getDependencies() {
        return this.select.getDependencies();
    }

    protected void promoteInst(PromotionOffer promotionOffer) throws XPathException {
        this.select = this.doPromotion(this.select, promotionOffer);
    }

    public Expression typeCheck(StaticContext staticContext, ItemType itemType) throws XPathException {
        this.select = this.select.typeCheck(staticContext, itemType);
        this.adoptChildExpression(this.select);
        return this;
    }

    public Expression optimize(Optimizer optimizer, StaticContext staticContext, ItemType itemType) throws XPathException {
        Expression expression;
        this.select = this.select.optimize(optimizer, staticContext, itemType);
        this.adoptChildExpression(this.select);
        if (this.readOnce && (expression = optimizer.optimizeCopy(this.select)) != null) {
            return expression;
        }
        return this;
    }

    public void display(int n2, PrintStream printStream, Configuration configuration) {
        printStream.println(ExpressionTool.indent(n2) + "copyOf " + "validation=" + Validation.toString(this.validation));
        this.select.display(n2 + 1, printStream, configuration);
    }

    public Iterator iterateSubExpressions() {
        return new MonoIterator(this.select);
    }

    public Item evaluateItem(XPathContext xPathContext) throws XPathException {
        return super.evaluateItem(xPathContext);
    }

    public SequenceIterator iterate(final XPathContext xPathContext) throws XPathException {
        if (this.validation == 3 && this.schemaType == null && this.copyNamespaces) {
            ItemMappingFunction itemMappingFunction = new ItemMappingFunction(){

                public Item map(Item item) {
                    if (item instanceof AtomicValue) {
                        return item;
                    }
                    VirtualCopy virtualCopy = VirtualCopy.makeVirtualCopy((NodeInfo)item, (NodeInfo)item);
                    int n2 = xPathContext.getController().getConfiguration().getDocumentNumberAllocator().allocateDocumentNumber();
                    virtualCopy.setDocumentNumber(n2);
                    return virtualCopy;
                }
            };
            return new ItemMappingIterator(this.select.iterate(xPathContext), itemMappingFunction);
        }
        Controller controller = xPathContext.getController();
        XPathContextMinor xPathContextMinor = xPathContext.newMinorContext();
        xPathContextMinor.setOrigin(this);
        SequenceOutputter sequenceOutputter = new SequenceOutputter();
        PipelineConfiguration pipelineConfiguration = controller.makePipelineConfiguration();
        pipelineConfiguration.setHostLanguage(this.getHostLanguage());
        sequenceOutputter.setPipelineConfiguration(pipelineConfiguration);
        xPathContextMinor.setReceiver(sequenceOutputter);
        try {
            this.process(xPathContextMinor);
            return Value.getIterator(sequenceOutputter.getSequence());
        }
        catch (XPathException xPathException) {
            if (xPathException instanceof ValidationException) {
                ((ValidationException)xPathException).setSourceLocator(this);
                ((ValidationException)xPathException).setSystemId(this.getSystemId());
            }
            if (xPathException.getLocator() == null) {
                xPathException.setLocator(this);
            }
            throw xPathException;
        }
    }
}

