/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.instruct;

import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Iterator;
import net.sf.saxon.Configuration;
import net.sf.saxon.expr.ComputedExpression;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.ExpressionTool;
import net.sf.saxon.expr.Optimizer;
import net.sf.saxon.expr.PromotionOffer;
import net.sf.saxon.expr.StaticContext;
import net.sf.saxon.expr.TypeChecker;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.instruct.Instruction;
import net.sf.saxon.instruct.TailCall;
import net.sf.saxon.instruct.TailCallReturner;
import net.sf.saxon.om.EmptyIterator;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.type.ItemType;
import net.sf.saxon.type.SchemaType;
import net.sf.saxon.type.Type;
import net.sf.saxon.type.TypeHierarchy;
import net.sf.saxon.value.EmptySequence;
import net.sf.saxon.value.Value;

public class Choose
extends Instruction {
    private Expression[] conditions;
    private Expression[] actions;

    public Choose(Expression[] expressionArray, Expression[] expressionArray2) {
        int n2;
        this.conditions = expressionArray;
        this.actions = expressionArray2;
        for (n2 = 0; n2 < expressionArray.length; ++n2) {
            this.adoptChildExpression(expressionArray[n2]);
        }
        for (n2 = 0; n2 < expressionArray2.length; ++n2) {
            this.adoptChildExpression(expressionArray2[n2]);
        }
    }

    public int getInstructionNameCode() {
        return this.conditions.length == 1 ? 150 : 135;
    }

    public Expression simplify(StaticContext staticContext) throws XPathException {
        int n2;
        for (n2 = 0; n2 < this.conditions.length; ++n2) {
            this.conditions[n2] = this.conditions[n2].simplify(staticContext);
        }
        for (n2 = 0; n2 < this.actions.length; ++n2) {
            this.actions[n2] = this.actions[n2].simplify(staticContext);
        }
        return this;
    }

    public Expression typeCheck(StaticContext staticContext, ItemType itemType) throws XPathException {
        int n2;
        for (n2 = 0; n2 < this.conditions.length; ++n2) {
            this.conditions[n2] = this.conditions[n2].typeCheck(staticContext, itemType);
            this.adoptChildExpression(this.conditions[n2]);
            XPathException xPathException = TypeChecker.ebvError(this.conditions[n2], staticContext.getConfiguration().getTypeHierarchy());
            if (xPathException == null) continue;
            if (this.conditions[n2] instanceof ComputedExpression) {
                xPathException.setLocator((ComputedExpression)this.conditions[n2]);
            } else if (this.actions[n2] instanceof ComputedExpression) {
                xPathException.setLocator((ComputedExpression)this.actions[n2]);
            } else {
                xPathException.setLocator(this);
            }
            throw xPathException;
        }
        for (n2 = 0; n2 < this.actions.length; ++n2) {
            this.actions[n2] = this.actions[n2].typeCheck(staticContext, itemType);
            this.adoptChildExpression(this.actions[n2]);
        }
        return this;
    }

    public Expression optimize(Optimizer optimizer, StaticContext staticContext, ItemType itemType) throws XPathException {
        int n2;
        for (n2 = 0; n2 < this.conditions.length; ++n2) {
            Expression[] expressionArray;
            Expression[] expressionArray2;
            boolean bl;
            this.conditions[n2] = this.conditions[n2].optimize(optimizer, staticContext, itemType);
            if (!(this.conditions[n2] instanceof Value)) continue;
            try {
                bl = this.conditions[n2].effectiveBooleanValue(staticContext.makeEarlyEvaluationContext());
            }
            catch (XPathException xPathException) {
                xPathException.setLocator(this);
                throw xPathException;
            }
            if (bl) {
                if (n2 == 0) {
                    if (this.actions[0] instanceof ComputedExpression) {
                        ((ComputedExpression)this.actions[0]).setParentExpression(this.getParentExpression());
                    }
                    return this.actions[0];
                }
                if (n2 == this.conditions.length - 1) continue;
                expressionArray2 = new Expression[n2 + 1];
                expressionArray = new Expression[n2 + 1];
                System.arraycopy(this.conditions, 0, expressionArray2, 0, n2 + 1);
                System.arraycopy(this.actions, 0, expressionArray, 0, n2 + 1);
                this.conditions = expressionArray2;
                this.actions = expressionArray;
                break;
            }
            expressionArray2 = new Expression[this.conditions.length - 1];
            expressionArray = new Expression[this.conditions.length - 1];
            System.arraycopy(this.conditions, 0, expressionArray2, 0, n2);
            System.arraycopy(this.actions, 0, expressionArray, 0, n2);
            System.arraycopy(this.conditions, n2 + 1, expressionArray2, n2, this.conditions.length - n2 - 1);
            System.arraycopy(this.actions, n2 + 1, expressionArray, n2, this.conditions.length - n2 - 1);
            this.conditions = expressionArray2;
            this.actions = expressionArray;
            --n2;
        }
        for (n2 = 0; n2 < this.actions.length; ++n2) {
            this.actions[n2] = this.actions[n2].optimize(optimizer, staticContext, itemType);
        }
        if (this.actions.length == 0) {
            return EmptySequence.getInstance();
        }
        return this;
    }

    public int getImplementationMethod() {
        return 6;
    }

    public boolean markTailFunctionCalls() {
        boolean bl = false;
        for (int i2 = 0; i2 < this.actions.length; ++i2) {
            if (!(this.actions[i2] instanceof ComputedExpression)) continue;
            bl |= ((ComputedExpression)this.actions[i2]).markTailFunctionCalls();
        }
        return bl;
    }

    public ItemType getItemType(TypeHierarchy typeHierarchy) {
        ItemType itemType = this.actions[0].getItemType(typeHierarchy);
        for (int i2 = 1; i2 < this.actions.length; ++i2) {
            itemType = Type.getCommonSuperType(itemType, this.actions[i2].getItemType(typeHierarchy), typeHierarchy);
        }
        return itemType;
    }

    public final boolean createsNewNodes() {
        for (int i2 = 0; i2 < this.actions.length; ++i2) {
            int n2 = this.actions[i2].getSpecialProperties();
            if ((n2 & 0x400000) != 0) continue;
            return true;
        }
        return false;
    }

    public Iterator iterateSubExpressions() {
        int n2;
        ArrayList<Expression> arrayList = new ArrayList<Expression>(this.conditions.length + this.actions.length);
        for (n2 = 0; n2 < this.conditions.length; ++n2) {
            arrayList.add(this.conditions[n2]);
        }
        for (n2 = 0; n2 < this.actions.length; ++n2) {
            arrayList.add(this.actions[n2]);
        }
        return arrayList.iterator();
    }

    protected void promoteInst(PromotionOffer promotionOffer) throws XPathException {
        if (promotionOffer.action == 13 || promotionOffer.action == 12 || promotionOffer.action == 14) {
            int n2;
            for (n2 = 0; n2 < this.conditions.length; ++n2) {
                this.conditions[n2] = this.doPromotion(this.conditions[n2], promotionOffer);
            }
            for (n2 = 0; n2 < this.actions.length; ++n2) {
                this.actions[n2] = this.doPromotion(this.actions[n2], promotionOffer);
            }
        } else {
            this.conditions[0] = this.doPromotion(this.conditions[0], promotionOffer);
        }
    }

    public void checkPermittedContents(SchemaType schemaType, StaticContext staticContext, boolean bl) throws XPathException {
        for (int i2 = 0; i2 < this.actions.length; ++i2) {
            this.actions[i2].checkPermittedContents(schemaType, staticContext, bl);
        }
    }

    public void display(int n2, PrintStream printStream, Configuration configuration) {
        for (int i2 = 0; i2 < this.conditions.length; ++i2) {
            printStream.println(ExpressionTool.indent(n2) + (i2 == 0 ? "if" : "else if"));
            this.conditions[i2].display(n2 + 1, printStream, configuration);
            printStream.println(ExpressionTool.indent(n2) + "then");
            this.actions[i2].display(n2 + 1, printStream, configuration);
        }
    }

    public TailCall processLeavingTail(XPathContext xPathContext) throws XPathException {
        for (int i2 = 0; i2 < this.conditions.length; ++i2) {
            boolean bl;
            try {
                bl = this.conditions[i2].effectiveBooleanValue(xPathContext);
            }
            catch (XPathException xPathException) {
                xPathException.setLocator(this);
                throw xPathException;
            }
            if (!bl) continue;
            if (this.actions[i2] instanceof TailCallReturner) {
                return ((TailCallReturner)((Object)this.actions[i2])).processLeavingTail(xPathContext);
            }
            this.actions[i2].process(xPathContext);
            return null;
        }
        return null;
    }

    public Item evaluateItem(XPathContext xPathContext) throws XPathException {
        for (int i2 = 0; i2 < this.conditions.length; ++i2) {
            boolean bl;
            try {
                bl = this.conditions[i2].effectiveBooleanValue(xPathContext);
            }
            catch (XPathException xPathException) {
                xPathException.setLocator(this);
                throw xPathException;
            }
            if (!bl) continue;
            return this.actions[i2].evaluateItem(xPathContext);
        }
        return null;
    }

    public SequenceIterator iterate(XPathContext xPathContext) throws XPathException {
        for (int i2 = 0; i2 < this.conditions.length; ++i2) {
            boolean bl;
            try {
                bl = this.conditions[i2].effectiveBooleanValue(xPathContext);
            }
            catch (XPathException xPathException) {
                xPathException.setLocator(this);
                throw xPathException;
            }
            if (!bl) continue;
            return this.actions[i2].iterate(xPathContext);
        }
        return EmptyIterator.getInstance();
    }
}

