/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.functions;

import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.functions.SystemFunction;
import net.sf.saxon.om.FastStringBuffer;
import net.sf.saxon.om.Item;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.value.AtomicValue;
import net.sf.saxon.value.StringValue;

public class Translate
extends SystemFunction {
    public Item evaluateItem(XPathContext xPathContext) throws XPathException {
        AtomicValue atomicValue = (AtomicValue)this.argument[0].evaluateItem(xPathContext);
        if (atomicValue == null) {
            return StringValue.EMPTY_STRING;
        }
        CharSequence charSequence = atomicValue.getStringValueCS();
        atomicValue = (AtomicValue)this.argument[1].evaluateItem(xPathContext);
        CharSequence charSequence2 = atomicValue.getStringValueCS();
        atomicValue = (AtomicValue)this.argument[2].evaluateItem(xPathContext);
        CharSequence charSequence3 = atomicValue.getStringValueCS();
        return StringValue.makeStringValue(Translate.translate(charSequence, charSequence2, charSequence3));
    }

    private static CharSequence translate(CharSequence charSequence, CharSequence charSequence2, CharSequence charSequence3) {
        int n2 = StringValue.getStringLength(charSequence);
        int n3 = StringValue.getStringLength(charSequence2);
        int n4 = StringValue.getStringLength(charSequence3);
        if (charSequence.length() != n2 || charSequence2.length() != n3 || charSequence3.length() != n4) {
            return Translate.slowTranslate(charSequence, charSequence2, charSequence3);
        }
        String string = ((Object)charSequence2).toString();
        FastStringBuffer fastStringBuffer = new FastStringBuffer(charSequence.length());
        int n5 = charSequence3.length();
        for (int i2 = 0; i2 < charSequence.length(); ++i2) {
            char c2 = charSequence.charAt(i2);
            int n6 = string.indexOf(c2);
            if (n6 >= n5) continue;
            fastStringBuffer.append(n6 < 0 ? c2 : charSequence3.charAt(n6));
        }
        return fastStringBuffer;
    }

    private static CharSequence slowTranslate(CharSequence charSequence, CharSequence charSequence2, CharSequence charSequence3) {
        int[] nArray = StringValue.expand(charSequence);
        int[] nArray2 = StringValue.expand(charSequence2);
        int[] nArray3 = StringValue.expand(charSequence3);
        StringBuffer stringBuffer = new StringBuffer(charSequence.length());
        for (int i2 = 0; i2 < nArray.length; ++i2) {
            int n2;
            int n3 = nArray[i2];
            int n4 = -1;
            for (n2 = 0; n2 < nArray2.length; ++n2) {
                if (nArray2[n2] != n3) continue;
                n4 = n2;
                break;
            }
            n2 = -1;
            if (n4 < 0) {
                n2 = nArray[i2];
            } else if (n4 < nArray3.length) {
                n2 = nArray3[n4];
            }
            if (n2 < 0) continue;
            if (n2 < 65536) {
                stringBuffer.append((char)n2);
                continue;
            }
            stringBuffer.append((char)((n2 -= 65536) / 1024 + 55296));
            stringBuffer.append((char)(n2 % 1024 + 56320));
        }
        return stringBuffer;
    }
}

