/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.functions;

import net.sf.saxon.expr.PositionIterator;
import net.sf.saxon.expr.TailExpression;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.functions.SystemFunction;
import net.sf.saxon.om.EmptyIterator;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.type.ItemType;
import net.sf.saxon.type.TypeHierarchy;
import net.sf.saxon.value.AtomicValue;
import net.sf.saxon.value.IntegerValue;
import net.sf.saxon.value.NumericValue;

public class Subsequence
extends SystemFunction {
    public ItemType getItemType(TypeHierarchy typeHierarchy) {
        return this.argument[0].getItemType(typeHierarchy);
    }

    public int computeSpecialProperties() {
        return this.argument[0].getSpecialProperties();
    }

    public SequenceIterator iterate(XPathContext xPathContext) throws XPathException {
        SequenceIterator sequenceIterator = this.argument[0].iterate(xPathContext);
        AtomicValue atomicValue = (AtomicValue)this.argument[1].evaluateItem(xPathContext);
        NumericValue numericValue = (NumericValue)atomicValue.getPrimitiveValue();
        if (this.argument.length == 2) {
            long l2;
            if (numericValue instanceof IntegerValue) {
                l2 = ((IntegerValue)numericValue).longValue();
                if (l2 <= 1L) {
                    return sequenceIterator;
                }
            } else {
                if ((numericValue = numericValue.round()).compareTo(IntegerValue.PLUS_ONE) <= 0) {
                    return sequenceIterator;
                }
                if (numericValue.compareTo(IntegerValue.MAX_LONG) > 0) {
                    return EmptyIterator.getInstance();
                }
                if (numericValue.isNaN()) {
                    return EmptyIterator.getInstance();
                }
                l2 = numericValue.longValue();
            }
            if (l2 > Integer.MAX_VALUE) {
                return EmptyIterator.getInstance();
            }
            return new TailExpression.TailIterator(sequenceIterator, (int)l2);
        }
        AtomicValue atomicValue2 = (AtomicValue)this.argument[2].evaluateItem(xPathContext);
        NumericValue numericValue2 = (NumericValue)atomicValue2.getPrimitiveValue();
        if (numericValue instanceof IntegerValue && numericValue2 instanceof IntegerValue) {
            long l3 = ((IntegerValue)numericValue).longValue();
            if (l3 > Integer.MAX_VALUE) {
                return EmptyIterator.getInstance();
            }
            long l4 = ((IntegerValue)numericValue2).longValue();
            if (l4 > Integer.MAX_VALUE) {
                l4 = Integer.MAX_VALUE;
            }
            if (l4 < 1L) {
                return EmptyIterator.getInstance();
            }
            long l5 = l3 + l4 - 1L;
            if (l5 < 1L) {
                return EmptyIterator.getInstance();
            }
            int n2 = l3 < 1L ? 1 : (int)l3;
            return PositionIterator.make(sequenceIterator, n2, (int)l5);
        }
        if (numericValue.isNaN()) {
            return EmptyIterator.getInstance();
        }
        if (numericValue.compareTo(IntegerValue.MAX_LONG) > 0) {
            return EmptyIterator.getInstance();
        }
        numericValue = numericValue.round();
        if (numericValue2.isNaN()) {
            return EmptyIterator.getInstance();
        }
        if ((numericValue2 = numericValue2.round()).compareTo(IntegerValue.ZERO) <= 0) {
            return EmptyIterator.getInstance();
        }
        NumericValue numericValue3 = numericValue.arithmetic(15, numericValue2, xPathContext).arithmetic(16, IntegerValue.PLUS_ONE, xPathContext);
        if (numericValue3.compareTo(IntegerValue.ZERO) <= 0) {
            return EmptyIterator.getInstance();
        }
        long l6 = numericValue.compareTo(IntegerValue.PLUS_ONE) <= 0 ? 1L : numericValue.longValue();
        if (l6 > Integer.MAX_VALUE) {
            return EmptyIterator.getInstance();
        }
        long l7 = numericValue3.compareTo(IntegerValue.MAX_LONG) >= 0 ? Integer.MAX_VALUE : numericValue3.longValue();
        return PositionIterator.make(sequenceIterator, (int)l6, (int)l7);
    }
}

