/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.functions;

import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.ExpressionTool;
import net.sf.saxon.expr.MappingFunction;
import net.sf.saxon.expr.MappingIterator;
import net.sf.saxon.expr.Optimizer;
import net.sf.saxon.expr.StaticContext;
import net.sf.saxon.expr.StringTokenIterator;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.functions.SystemFunction;
import net.sf.saxon.om.DocumentInfo;
import net.sf.saxon.om.EmptyIterator;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.om.SingletonIterator;
import net.sf.saxon.sort.DocumentOrderIterator;
import net.sf.saxon.sort.LocalOrderComparer;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.value.AtomicValue;
import net.sf.saxon.value.Cardinality;

public class Id
extends SystemFunction {
    private boolean isSingletonId = false;

    public Expression simplify(StaticContext staticContext) throws XPathException {
        Id id = (Id)super.simplify(staticContext);
        if (this.argument.length == 1) {
            id.addContextDocumentArgument(1, "id");
        }
        return id;
    }

    public void checkArguments(StaticContext staticContext) throws XPathException {
        super.checkArguments(staticContext);
        Optimizer optimizer = staticContext.getConfiguration().getOptimizer();
        this.argument[0] = ExpressionTool.unsorted(optimizer, this.argument[0], false);
        this.isSingletonId = !Cardinality.allowsMany(this.argument[0].getCardinality());
    }

    public Expression preEvaluate(StaticContext staticContext) {
        return this;
    }

    public int computeSpecialProperties() {
        int n2 = 0xC20000;
        if (this.getNumberOfArguments() == 1 || (this.argument[1].getSpecialProperties() & 0x10000) != 0) {
            n2 |= 0x10000;
        }
        return n2;
    }

    public SequenceIterator iterate(XPathContext xPathContext) throws XPathException {
        NodeInfo nodeInfo = (NodeInfo)this.argument[1].evaluateItem(xPathContext);
        if ((nodeInfo = nodeInfo.getRoot()).getNodeKind() != 9) {
            this.dynamicError("In the id() function, the tree being searched must be one whose root is a document node", "FODC0001", xPathContext);
            return null;
        }
        DocumentInfo documentInfo = (DocumentInfo)nodeInfo;
        if (this.isSingletonId) {
            AtomicValue atomicValue = (AtomicValue)this.argument[0].evaluateItem(xPathContext);
            if (atomicValue == null) {
                return EmptyIterator.getInstance();
            }
            String string = atomicValue.getStringValue();
            if (string.indexOf(32) >= 0 || string.indexOf(9) >= 0 || string.indexOf(10) >= 0 || string.indexOf(13) >= 0) {
                StringTokenIterator stringTokenIterator = new StringTokenIterator(string);
                IdMappingFunction idMappingFunction = new IdMappingFunction();
                idMappingFunction.document = documentInfo;
                MappingIterator mappingIterator = new MappingIterator(stringTokenIterator, idMappingFunction);
                return new DocumentOrderIterator(mappingIterator, LocalOrderComparer.getInstance());
            }
            return SingletonIterator.makeIterator(documentInfo.selectID(string));
        }
        SequenceIterator sequenceIterator = this.argument[0].iterate(xPathContext);
        IdMappingFunction idMappingFunction = new IdMappingFunction();
        idMappingFunction.document = documentInfo;
        MappingIterator mappingIterator = new MappingIterator(sequenceIterator, idMappingFunction);
        return new DocumentOrderIterator(mappingIterator, LocalOrderComparer.getInstance());
    }

    private static class IdMappingFunction
    implements MappingFunction {
        public DocumentInfo document;

        private IdMappingFunction() {
        }

        public Object map(Item item) throws XPathException {
            String string = item.getStringValue().trim();
            if (string.indexOf(32) >= 0 || string.indexOf(9) >= 0 || string.indexOf(10) >= 0 || string.indexOf(13) >= 0) {
                StringTokenIterator stringTokenIterator = new StringTokenIterator(string);
                IdMappingFunction idMappingFunction = new IdMappingFunction();
                idMappingFunction.document = this.document;
                return new MappingIterator(stringTokenIterator, idMappingFunction);
            }
            return this.document.selectID(string);
        }
    }
}

