/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.functions;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Locale;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.sf.saxon.expr.ExpressionTool;
import net.sf.saxon.expr.StaticContext;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.functions.SystemFunction;
import net.sf.saxon.functions.XSLTFunction;
import net.sf.saxon.instruct.NumberInstruction;
import net.sf.saxon.number.Numberer;
import net.sf.saxon.om.FastStringBuffer;
import net.sf.saxon.om.Item;
import net.sf.saxon.trans.DynamicError;
import net.sf.saxon.trans.StaticError;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.value.AtomicValue;
import net.sf.saxon.value.CalendarValue;
import net.sf.saxon.value.DateTimeValue;
import net.sf.saxon.value.DateValue;
import net.sf.saxon.value.DecimalValue;
import net.sf.saxon.value.IntegerValue;
import net.sf.saxon.value.StringValue;
import net.sf.saxon.value.TimeValue;
import net.sf.saxon.value.Whitespace;

public class FormatDate
extends SystemFunction
implements XSLTFunction {
    private static Pattern componentPattern = Pattern.compile("([YMDdWwFHhmsfZzPCE])\\s*(.*)");
    private static Pattern formatPattern = Pattern.compile("([^,]*)(,.*)?");
    private static Pattern widthPattern = Pattern.compile(",(\\*|[0-9]+)(\\-(\\*|[0-9]+))?");
    private static Pattern alphanumericPattern = Pattern.compile("([A-Za-z0-9]|\\p{L}|\\p{N})*");
    private static Pattern digitsPattern = Pattern.compile("\\p{Nd}*");

    public void checkArguments(StaticContext staticContext) throws XPathException {
        int n2 = this.argument.length;
        if (n2 != 2 && n2 != 5) {
            throw new StaticError("Function " + this.getDisplayName(staticContext.getNamePool()) + " must have either two or five arguments", ExpressionTool.getLocator(this));
        }
        super.checkArguments(staticContext);
    }

    public Item evaluateItem(XPathContext xPathContext) throws XPathException {
        String string;
        String string2;
        Object object;
        CalendarValue calendarValue = (CalendarValue)this.argument[0].evaluateItem(xPathContext);
        if (calendarValue == null) {
            return null;
        }
        String string3 = this.argument[1].evaluateItem(xPathContext).getStringValue();
        StringValue stringValue = null;
        StringValue stringValue2 = null;
        if (this.argument.length > 2) {
            object = (AtomicValue)this.argument[2].evaluateItem(xPathContext);
            stringValue = (StringValue)this.argument[3].evaluateItem(xPathContext);
            stringValue2 = (StringValue)this.argument[4].evaluateItem(xPathContext);
            string2 = object == null ? Locale.getDefault().getLanguage() : ((string2 = ((AtomicValue)object).getStringValue()).length() >= 2 ? string2.substring(0, 2) : Locale.getDefault().getLanguage());
        } else {
            string2 = Locale.getDefault().getLanguage();
            if (!string2.equals("en") && !(object = NumberInstruction.makeNumberer(string2, "us", xPathContext)).getClass().getName().endsWith("Numberer_" + string2)) {
                string2 = "en";
            }
        }
        object = stringValue2 == null ? null : stringValue2.getStringValue();
        CharSequence charSequence = FormatDate.formatDate(calendarValue, string3, string2, (String)object, xPathContext);
        if (stringValue != null && !(string = stringValue.getStringValue()).equals("AD") && !string.equals("ISO")) {
            charSequence = "[Calendar: AD]" + ((Object)charSequence).toString();
        }
        return new StringValue(charSequence);
    }

    private static CharSequence formatDate(CalendarValue calendarValue, String string, String string2, String string3, XPathContext xPathContext) throws XPathException {
        Numberer numberer = NumberInstruction.makeNumberer(string2, string3, xPathContext);
        FastStringBuffer fastStringBuffer = new FastStringBuffer(32);
        if (!numberer.getClass().getName().endsWith("Numberer_" + string2)) {
            fastStringBuffer.append("[Language: en]");
        }
        int n2 = 0;
        while (true) {
            Object object;
            int n3;
            if (n2 < string.length() && string.charAt(n2) != '[') {
                fastStringBuffer.append(string.charAt(n2));
                if (string.charAt(n2) == ']' && (++n2 == string.length() || string.charAt(n2) != ']')) {
                    DynamicError dynamicError = new DynamicError("Closing ']' in date picture must be written as ']]'");
                    dynamicError.setErrorCode("XTDE1340");
                    dynamicError.setXPathContext(xPathContext);
                    throw dynamicError;
                }
                ++n2;
                continue;
            }
            if (n2 == string.length()) break;
            if (++n2 < string.length() && string.charAt(n2) == '[') {
                fastStringBuffer.append('[');
                ++n2;
                continue;
            }
            int n4 = n3 = n2 < string.length() ? string.indexOf("]", n2) : -1;
            if (n3 == -1) {
                object = new DynamicError("Date format contains a '[' with no matching ']'");
                ((XPathException)object).setErrorCode("XTDE1340");
                ((DynamicError)object).setXPathContext(xPathContext);
                throw object;
            }
            object = string.substring(n2, n3);
            fastStringBuffer.append(FormatDate.formatComponent(calendarValue, Whitespace.removeAllWhitespace((CharSequence)object), numberer, xPathContext));
            n2 = n3 + 1;
        }
        return fastStringBuffer;
    }

    private static CharSequence formatComponent(CalendarValue calendarValue, CharSequence charSequence, Numberer numberer, XPathContext xPathContext) throws XPathException {
        boolean bl = calendarValue instanceof TimeValue;
        boolean bl2 = calendarValue instanceof DateValue;
        DateTimeValue dateTimeValue = calendarValue.toDateTime();
        Matcher matcher = componentPattern.matcher(charSequence);
        if (!matcher.matches()) {
            DynamicError dynamicError = new DynamicError("Unrecognized date/time component [" + charSequence + ']');
            dynamicError.setErrorCode("XTDE1340");
            dynamicError.setXPathContext(xPathContext);
            throw dynamicError;
        }
        String string = matcher.group(1);
        String string2 = matcher.group(2);
        if (string2 == null) {
            string2 = "";
        }
        boolean bl3 = false;
        if ("".equals(string2) || string2.startsWith(",")) {
            bl3 = true;
            switch (string.charAt(0)) {
                case 'F': {
                    string2 = "Nn" + string2;
                    break;
                }
                case 'P': {
                    string2 = 'n' + string2;
                    break;
                }
                case 'C': 
                case 'E': {
                    string2 = 'N' + string2;
                    break;
                }
                case 'm': 
                case 's': {
                    string2 = "01" + string2;
                    break;
                }
                default: {
                    string2 = '1' + string2;
                }
            }
        }
        switch (string.charAt(0)) {
            case 'Y': {
                if (bl) {
                    DynamicError dynamicError = new DynamicError("In formatTime(): an xs:time value does not contain a year component");
                    dynamicError.setErrorCode("XTDE1350");
                    dynamicError.setXPathContext(xPathContext);
                    throw dynamicError;
                }
                int n2 = dateTimeValue.getYear();
                if (n2 < 0) {
                    n2 = 1 - n2;
                }
                return FormatDate.formatNumber(string, n2, string2, bl3, numberer, xPathContext);
            }
            case 'M': {
                if (bl) {
                    DynamicError dynamicError = new DynamicError("In formatTime(): an xs:time value does not contain a month component");
                    dynamicError.setErrorCode("XTDE1350");
                    dynamicError.setXPathContext(xPathContext);
                    throw dynamicError;
                }
                byte by = dateTimeValue.getMonth();
                return FormatDate.formatNumber(string, by, string2, bl3, numberer, xPathContext);
            }
            case 'D': {
                if (bl) {
                    DynamicError dynamicError = new DynamicError("In formatTime(): an xs:time value does not contain a day component");
                    dynamicError.setErrorCode("XTDE1350");
                    dynamicError.setXPathContext(xPathContext);
                    throw dynamicError;
                }
                byte by = dateTimeValue.getDay();
                return FormatDate.formatNumber(string, by, string2, bl3, numberer, xPathContext);
            }
            case 'd': {
                if (bl) {
                    DynamicError dynamicError = new DynamicError("In formatTime(): an xs:time value does not contain a day component");
                    dynamicError.setErrorCode("XTDE1350");
                    dynamicError.setXPathContext(xPathContext);
                    throw dynamicError;
                }
                int n3 = DateValue.getDayWithinYear(dateTimeValue.getYear(), dateTimeValue.getMonth(), dateTimeValue.getDay());
                return FormatDate.formatNumber(string, n3, string2, bl3, numberer, xPathContext);
            }
            case 'W': {
                if (bl) {
                    DynamicError dynamicError = new DynamicError("In formatTime(): cannot obtain the week number from an xs:time value");
                    dynamicError.setErrorCode("XTDE1350");
                    dynamicError.setXPathContext(xPathContext);
                    throw dynamicError;
                }
                int n4 = DateValue.getWeekNumber(dateTimeValue.getYear(), dateTimeValue.getMonth(), dateTimeValue.getDay());
                return FormatDate.formatNumber(string, n4, string2, bl3, numberer, xPathContext);
            }
            case 'w': {
                if (bl) {
                    DynamicError dynamicError = new DynamicError("In formatTime(): cannot obtain the week number from an xs:time value");
                    dynamicError.setErrorCode("XTDE1350");
                    dynamicError.setXPathContext(xPathContext);
                    throw dynamicError;
                }
                int n5 = DateValue.getWeekNumberWithinMonth(dateTimeValue.getYear(), dateTimeValue.getMonth(), dateTimeValue.getDay());
                return FormatDate.formatNumber(string, n5, string2, bl3, numberer, xPathContext);
            }
            case 'H': {
                if (bl2) {
                    DynamicError dynamicError = new DynamicError("In formatDate(): an xs:date value does not contain an hour component");
                    dynamicError.setErrorCode("XTDE1350");
                    dynamicError.setXPathContext(xPathContext);
                    throw dynamicError;
                }
                IntegerValue integerValue = (IntegerValue)calendarValue.getComponent(4);
                return FormatDate.formatNumber(string, (int)integerValue.longValue(), string2, bl3, numberer, xPathContext);
            }
            case 'h': {
                if (bl2) {
                    DynamicError dynamicError = new DynamicError("In formatDate(): an xs:date value does not contain an hour component");
                    dynamicError.setErrorCode("XTDE1350");
                    dynamicError.setXPathContext(xPathContext);
                    throw dynamicError;
                }
                IntegerValue integerValue = (IntegerValue)calendarValue.getComponent(4);
                int n6 = (int)integerValue.longValue();
                if (n6 > 12) {
                    n6 -= 12;
                }
                if (n6 == 0) {
                    n6 = 12;
                }
                return FormatDate.formatNumber(string, n6, string2, bl3, numberer, xPathContext);
            }
            case 'm': {
                if (bl2) {
                    DynamicError dynamicError = new DynamicError("In formatDate(): an xs:date value does not contain a minutes component");
                    dynamicError.setErrorCode("XTDE1350");
                    dynamicError.setXPathContext(xPathContext);
                    throw dynamicError;
                }
                IntegerValue integerValue = (IntegerValue)calendarValue.getComponent(5);
                return FormatDate.formatNumber(string, (int)integerValue.longValue(), string2, bl3, numberer, xPathContext);
            }
            case 's': {
                if (bl2) {
                    DynamicError dynamicError = new DynamicError("In formatDate(): an xs:date value does not contain a seconds component");
                    dynamicError.setErrorCode("XTDE1350");
                    dynamicError.setXPathContext(xPathContext);
                    throw dynamicError;
                }
                DecimalValue decimalValue = (DecimalValue)calendarValue.getComponent(6);
                return FormatDate.formatNumber(string, decimalValue.getValue().intValue(), string2, bl3, numberer, xPathContext);
            }
            case 'f': {
                if (bl2) {
                    DynamicError dynamicError = new DynamicError("In formatDate(): an xs:date value does not contain a fractional seconds component");
                    dynamicError.setErrorCode("XTDE1350");
                    dynamicError.setXPathContext(xPathContext);
                    throw dynamicError;
                }
                int n7 = (int)((IntegerValue)calendarValue.getComponent(11)).longValue();
                return FormatDate.formatNumber(string, n7, string2, bl3, numberer, xPathContext);
            }
            case 'Z': {
                if (calendarValue.hasTimezone()) {
                    if (string2.startsWith("N")) {
                        return numberer.getTimezoneName(calendarValue.getTimezoneInMinutes());
                    }
                    if (string2.startsWith("n")) {
                        return numberer.getTimezoneName(calendarValue.getTimezoneInMinutes()).toLowerCase();
                    }
                    FastStringBuffer fastStringBuffer = new FastStringBuffer(8);
                    calendarValue.appendTimezone(fastStringBuffer);
                    return fastStringBuffer.toString();
                }
                return "";
            }
            case 'z': {
                if (calendarValue.hasTimezone()) {
                    int n8 = calendarValue.getTimezoneInMinutes();
                    return "GMT" + (n8 == 0 ? "" : (n8 > 0 ? "+" : "-") + Math.abs(n8 / 60) + (n8 % 60 == 0 ? "" : ".5"));
                }
                return "";
            }
            case 'F': {
                if (bl) {
                    DynamicError dynamicError = new DynamicError("In formatTime(): an xs:time value does not contain day-of-week component");
                    dynamicError.setErrorCode("XTDE1350");
                    dynamicError.setXPathContext(xPathContext);
                    throw dynamicError;
                }
                int n9 = DateValue.getDayOfWeek(dateTimeValue.getYear(), dateTimeValue.getMonth(), dateTimeValue.getDay());
                return FormatDate.formatNumber(string, n9, string2, bl3, numberer, xPathContext);
            }
            case 'P': {
                if (bl2) {
                    DynamicError dynamicError = new DynamicError("In formatDate(): an xs:date value does not contain an am/pm component");
                    dynamicError.setErrorCode("XTDE1350");
                    dynamicError.setXPathContext(xPathContext);
                    throw dynamicError;
                }
                int n10 = dateTimeValue.getHour() * 60 + dateTimeValue.getMinute();
                return FormatDate.formatNumber(string, n10, string2, bl3, numberer, xPathContext);
            }
            case 'C': {
                return numberer.getCalendarName("AD");
            }
            case 'E': {
                if (bl) {
                    DynamicError dynamicError = new DynamicError("In formatTime(): an xs:time value does not contain an AD/BC component");
                    dynamicError.setErrorCode("XTDE1350");
                    dynamicError.setXPathContext(xPathContext);
                    throw dynamicError;
                }
                int n11 = dateTimeValue.getYear();
                return numberer.getEraName(n11);
            }
        }
        DynamicError dynamicError = new DynamicError("Unknown formatDate/time component specifier '" + string2.charAt(0) + '\'');
        dynamicError.setErrorCode("XTDE1340");
        dynamicError.setXPathContext(xPathContext);
        throw dynamicError;
    }

    private static CharSequence formatNumber(String string, int n2, String string2, boolean bl, Numberer numberer, XPathContext xPathContext) throws XPathException {
        Serializable serializable;
        Matcher matcher = formatPattern.matcher(string2);
        if (!matcher.matches()) {
            DynamicError dynamicError = new DynamicError("Unrecognized format picture [" + string + string2 + ']');
            dynamicError.setErrorCode("XTDE1340");
            dynamicError.setXPathContext(xPathContext);
            throw dynamicError;
        }
        String string3 = matcher.group(1);
        String string4 = null;
        if (string3.endsWith("t")) {
            string3 = string3.substring(0, string3.length() - 1);
            string4 = "t";
        } else if (string3.endsWith("o")) {
            string3 = string3.substring(0, string3.length() - 1);
            string4 = "o";
        }
        String string5 = "t".equals(string4) ? "traditional" : null;
        String string6 = "o".equals(string4) ? numberer.getOrdinalSuffixForDateTime(string) : null;
        String string7 = matcher.group(2);
        if (!alphanumericPattern.matcher(string3).matches()) {
            DynamicError dynamicError = new DynamicError("In format picture at '" + string3 + "', primary format must be alphanumeric");
            dynamicError.setErrorCode("XTDE1340");
            dynamicError.setXPathContext(xPathContext);
            throw dynamicError;
        }
        int n3 = 1;
        int n4 = Integer.MAX_VALUE;
        if (string7 == null || "".equals(string7)) {
            int n5;
            if (digitsPattern.matcher(string3).matches() && (n5 = StringValue.getStringLength(string3)) > 1) {
                n3 = n5;
                n4 = n5;
            }
        } else if (string3.equals("I") || string3.equals("i")) {
            n3 = 1;
            n4 = Integer.MAX_VALUE;
        } else {
            int[] nArray = FormatDate.getWidths(string7, xPathContext);
            n3 = nArray[0];
            n4 = nArray[1];
            if (bl && string3.endsWith("1") && n3 != string3.length()) {
                serializable = new FastStringBuffer(n3 + 1);
                for (int i2 = 1; i2 < n3; ++i2) {
                    ((FastStringBuffer)serializable).append('0');
                }
                ((FastStringBuffer)serializable).append('1');
                string3 = ((FastStringBuffer)serializable).toString();
            }
        }
        if ("P".equals(string)) {
            if (!("N".equals(string3) || "n".equals(string3) || "Nn".equals(string3))) {
                string3 = "n";
            }
        } else if ("f".equals(string)) {
            String string8;
            if (n2 == 0) {
                string8 = "0";
            } else {
                string8 = (1000000 + n2 + "").substring(1);
                if (string8.length() > n4) {
                    serializable = new DecimalValue(new BigDecimal("0." + string8));
                    string8 = ((DecimalValue)(serializable = (DecimalValue)((DecimalValue)serializable).roundHalfToEven(n4))).getStringValue();
                    string8 = string8.length() > 2 ? string8.substring(2) : "";
                }
            }
            while (string8.length() < n3) {
                string8 = string8 + '0';
            }
            while (string8.length() > n3 && string8.charAt(string8.length() - 1) == '0') {
                string8 = string8.substring(0, string8.length() - 1);
            }
            return string8;
        }
        if ("N".equals(string3) || "n".equals(string3) || "Nn".equals(string3)) {
            String string9 = "";
            if ("M".equals(string)) {
                string9 = numberer.monthName(n2, n3, n4);
            } else if ("F".equals(string)) {
                string9 = numberer.dayName(n2, n3, n4);
            } else if ("P".equals(string)) {
                string9 = numberer.halfDayName(n2, n3, n4);
            } else {
                string3 = "1";
            }
            if ("N".equals(string3)) {
                return string9.toUpperCase();
            }
            if ("n".equals(string3)) {
                return string9.toLowerCase();
            }
            return string9;
        }
        String string10 = numberer.format(n2, string3, 0, ",", string5, string6);
        int n6 = StringValue.getStringLength(string10);
        while (n6 < n3) {
            string10 = ("00000000" + string10).substring(string10.length() + 8 - n3);
            n6 = StringValue.getStringLength(string10);
        }
        if (n6 > n4 && string.charAt(0) == 'Y') {
            string10 = n6 == string10.length() ? string10.substring(string10.length() - n4) : string10.substring(string10.length() - 2 * n4);
        }
        return string10;
    }

    private static int[] getWidths(String string, XPathContext xPathContext) throws XPathException {
        try {
            Object object;
            int n2 = -1;
            int n3 = -1;
            if (!"".equals(string)) {
                object = widthPattern.matcher(string);
                if (((Matcher)object).matches()) {
                    String string2 = ((Matcher)object).group(1);
                    n2 = string2 == null || "".equals(string2) || "*".equals(string2) ? 1 : Integer.parseInt(string2);
                    String string3 = ((Matcher)object).group(3);
                    n3 = string3 == null || "".equals(string3) || "*".equals(string3) ? Integer.MAX_VALUE : Integer.parseInt(string3);
                } else {
                    DynamicError dynamicError = new DynamicError("Unrecognized width specifier");
                    dynamicError.setErrorCode("XTDE1340");
                    dynamicError.setXPathContext(xPathContext);
                    throw dynamicError;
                }
            }
            if (n2 > n3 && n3 != -1) {
                object = new DynamicError("Minimum width in date/time picture exceeds maximum width");
                ((XPathException)object).setErrorCode("XTDE1340");
                ((DynamicError)object).setXPathContext(xPathContext);
                throw object;
            }
            object = new int[2];
            object[0] = n2;
            object[1] = n3;
            return object;
        }
        catch (NumberFormatException numberFormatException) {
            DynamicError dynamicError = new DynamicError("Invalid integer used as width in date/time picture");
            dynamicError.setErrorCode("XTDE1340");
            dynamicError.setXPathContext(xPathContext);
            throw dynamicError;
        }
    }
}

