/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.functions;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Properties;
import javax.xml.transform.Templates;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.stream.StreamResult;
import net.sf.saxon.Configuration;
import net.sf.saxon.Controller;
import net.sf.saxon.Err;
import net.sf.saxon.TransformerFactoryImpl;
import net.sf.saxon.charcode.UnicodeCharacterSet;
import net.sf.saxon.expr.ContextItemExpression;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.FilterIterator;
import net.sf.saxon.expr.IdentityComparison;
import net.sf.saxon.expr.StringTokenIterator;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.expr.XPathContextMinor;
import net.sf.saxon.exslt.Math;
import net.sf.saxon.functions.DeepEqual;
import net.sf.saxon.functions.Evaluate;
import net.sf.saxon.om.DocumentInfo;
import net.sf.saxon.om.EmptyIterator;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.NameChecker;
import net.sf.saxon.om.NamePool;
import net.sf.saxon.om.Navigator;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.om.Orphan;
import net.sf.saxon.om.ProcInstParser;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.om.SingletonIterator;
import net.sf.saxon.om.XMLChar;
import net.sf.saxon.query.QueryResult;
import net.sf.saxon.sort.AtomicComparer;
import net.sf.saxon.sort.GlobalOrderComparer;
import net.sf.saxon.tinytree.TinyBuilder;
import net.sf.saxon.trans.DynamicError;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.type.SchemaType;
import net.sf.saxon.value.Base64BinaryValue;
import net.sf.saxon.value.DoubleValue;
import net.sf.saxon.value.HexBinaryValue;
import net.sf.saxon.value.MonthDurationValue;
import net.sf.saxon.value.NumericValue;
import net.sf.saxon.value.SecondsDurationValue;
import net.sf.saxon.value.SingletonNode;
import net.sf.saxon.value.Value;

public class Extensions {
    private Extensions() {
    }

    public static void pauseTracing(XPathContext xPathContext) {
        xPathContext.getController().pauseTracing(true);
    }

    public static void resumeTracing(XPathContext xPathContext) {
        xPathContext.getController().pauseTracing(false);
    }

    public static String systemId(XPathContext xPathContext) throws XPathException {
        Item item = xPathContext.getContextItem();
        if (item == null) {
            DynamicError dynamicError = new DynamicError("The context item for saxon:systemId() is not set");
            dynamicError.setXPathContext(xPathContext);
            throw dynamicError;
        }
        if (item instanceof NodeInfo) {
            return ((NodeInfo)item).getSystemId();
        }
        return "";
    }

    public static int lineNumber(XPathContext xPathContext) {
        Item item = xPathContext.getCurrentIterator().current();
        if (item instanceof NodeInfo) {
            return ((NodeInfo)item).getLineNumber();
        }
        return -1;
    }

    public static int lineNumber(NodeInfo nodeInfo) {
        if (nodeInfo == null) {
            return -1;
        }
        return nodeInfo.getLineNumber();
    }

    public static DocumentInfo discardDocument(XPathContext xPathContext, DocumentInfo documentInfo) {
        if (documentInfo == null) {
            return null;
        }
        return xPathContext.getController().getDocumentPool().discard(documentInfo);
    }

    public static boolean hasSameNodes(SequenceIterator sequenceIterator, SequenceIterator sequenceIterator2) throws XPathException {
        NodeInfo nodeInfo;
        NodeInfo nodeInfo2;
        SequenceIterator sequenceIterator3 = sequenceIterator;
        SequenceIterator sequenceIterator4 = sequenceIterator2;
        if (sequenceIterator3 == null) {
            sequenceIterator3 = EmptyIterator.getInstance();
        }
        if (sequenceIterator4 == null) {
            sequenceIterator4 = EmptyIterator.getInstance();
        }
        do {
            nodeInfo2 = (NodeInfo)sequenceIterator3.next();
            nodeInfo = (NodeInfo)sequenceIterator4.next();
            if (nodeInfo2 != null && nodeInfo != null) continue;
            return nodeInfo2 == nodeInfo;
        } while (nodeInfo2.isSameNodeInfo(nodeInfo));
        return false;
    }

    public static double sum(XPathContext xPathContext, SequenceIterator sequenceIterator, Evaluate.PreparedExpression preparedExpression) throws XPathException {
        Item item;
        if (sequenceIterator == null) {
            sequenceIterator = EmptyIterator.getInstance();
        }
        if (preparedExpression == null) {
            return Double.NaN;
        }
        double d2 = 0.0;
        XPathContextMinor xPathContextMinor = xPathContext.newMinorContext();
        xPathContextMinor.setOriginatingConstructType(2052);
        xPathContextMinor.setCurrentIterator(sequenceIterator);
        while ((item = sequenceIterator.next()) != null) {
            Serializable serializable;
            Item item2 = preparedExpression.expression.evaluateItem(xPathContextMinor);
            if (item2 instanceof NumericValue) {
                serializable = (DoubleValue)((NumericValue)item2).convert(517, xPathContext);
                d2 += ((DoubleValue)serializable).getDoubleValue();
                continue;
            }
            serializable = new DynamicError("expression in saxon:sum() must return numeric values");
            ((DynamicError)serializable).setXPathContext(xPathContextMinor);
            throw serializable;
        }
        return d2;
    }

    public static double max(XPathContext xPathContext, SequenceIterator sequenceIterator, Evaluate.PreparedExpression preparedExpression) throws XPathException {
        Item item;
        if (sequenceIterator == null) {
            sequenceIterator = EmptyIterator.getInstance();
        }
        if (preparedExpression == null) {
            return Double.NaN;
        }
        double d2 = Double.NEGATIVE_INFINITY;
        XPathContextMinor xPathContextMinor = xPathContext.newMinorContext();
        xPathContextMinor.setOriginatingConstructType(2052);
        xPathContextMinor.setCurrentIterator(sequenceIterator);
        while ((item = sequenceIterator.next()) != null) {
            Serializable serializable;
            Item item2 = preparedExpression.expression.evaluateItem(xPathContextMinor);
            if (item2 instanceof NumericValue) {
                serializable = (DoubleValue)((NumericValue)item2).convert(517, xPathContext);
                if (!(((DoubleValue)serializable).getDoubleValue() > d2)) continue;
                d2 = ((DoubleValue)serializable).getDoubleValue();
                continue;
            }
            serializable = new DynamicError("expression in saxon:max() must return numeric values");
            ((DynamicError)serializable).setXPathContext(xPathContextMinor);
            throw serializable;
        }
        return d2;
    }

    public static double min(XPathContext xPathContext, SequenceIterator sequenceIterator, Evaluate.PreparedExpression preparedExpression) throws XPathException {
        Item item;
        if (sequenceIterator == null) {
            sequenceIterator = EmptyIterator.getInstance();
        }
        if (preparedExpression == null) {
            return Double.NaN;
        }
        double d2 = Double.POSITIVE_INFINITY;
        XPathContextMinor xPathContextMinor = xPathContext.newMinorContext();
        xPathContextMinor.setOriginatingConstructType(2052);
        xPathContextMinor.setCurrentIterator(sequenceIterator);
        while ((item = sequenceIterator.next()) != null) {
            Serializable serializable;
            Item item2 = preparedExpression.expression.evaluateItem(xPathContextMinor);
            if (item2 instanceof NumericValue) {
                serializable = (DoubleValue)((NumericValue)item2).convert(517, xPathContext);
                if (!(((DoubleValue)serializable).getDoubleValue() < d2)) continue;
                d2 = ((DoubleValue)serializable).getDoubleValue();
                continue;
            }
            serializable = new DynamicError("expression in saxon:min() must return numeric values");
            ((DynamicError)serializable).setXPathContext(xPathContext);
            throw serializable;
        }
        return d2;
    }

    public static Value highest(SequenceIterator sequenceIterator) throws XPathException {
        return Math.highest(sequenceIterator);
    }

    public static SequenceIterator highest(XPathContext xPathContext, SequenceIterator sequenceIterator, Evaluate.PreparedExpression preparedExpression) throws XPathException {
        Item item;
        if (sequenceIterator == null) {
            return EmptyIterator.getInstance();
        }
        if (preparedExpression == null) {
            return EmptyIterator.getInstance();
        }
        double d2 = Double.NEGATIVE_INFINITY;
        XPathContextMinor xPathContextMinor = xPathContext.newMinorContext();
        xPathContextMinor.setOriginatingConstructType(2052);
        Item item2 = null;
        xPathContextMinor.setCurrentIterator(sequenceIterator);
        while ((item = sequenceIterator.next()) != null) {
            Serializable serializable;
            Item item3 = preparedExpression.expression.evaluateItem(xPathContextMinor);
            if (item3 instanceof NumericValue) {
                serializable = (DoubleValue)((NumericValue)item3).convert(517, xPathContext);
                if (!(((DoubleValue)serializable).getDoubleValue() > d2)) continue;
                d2 = ((DoubleValue)serializable).getDoubleValue();
                item2 = sequenceIterator.current();
                continue;
            }
            serializable = new DynamicError("expression in saxon:highest() must return numeric values");
            ((DynamicError)serializable).setXPathContext(xPathContext);
            throw serializable;
        }
        return SingletonIterator.makeIterator(item2);
    }

    public static Value lowest(SequenceIterator sequenceIterator) throws XPathException {
        return Math.lowest(sequenceIterator);
    }

    public static SequenceIterator lowest(XPathContext xPathContext, SequenceIterator sequenceIterator, Evaluate.PreparedExpression preparedExpression) throws XPathException {
        Item item;
        if (sequenceIterator == null) {
            return EmptyIterator.getInstance();
        }
        if (preparedExpression == null) {
            return EmptyIterator.getInstance();
        }
        double d2 = Double.POSITIVE_INFINITY;
        XPathContextMinor xPathContextMinor = xPathContext.newMinorContext();
        xPathContextMinor.setOriginatingConstructType(2052);
        Item item2 = null;
        xPathContextMinor.setCurrentIterator(sequenceIterator);
        while ((item = sequenceIterator.next()) != null) {
            Serializable serializable;
            Item item3 = preparedExpression.expression.evaluateItem(xPathContextMinor);
            if (item3 instanceof NumericValue) {
                serializable = (DoubleValue)((NumericValue)item3).convert(517, xPathContext);
                if (!(((DoubleValue)serializable).getDoubleValue() < d2)) continue;
                d2 = ((DoubleValue)serializable).getDoubleValue();
                item2 = sequenceIterator.current();
                continue;
            }
            serializable = new DynamicError("expression in saxon:lowest() must return numeric values");
            ((DynamicError)serializable).setXPathContext(xPathContext);
            throw serializable;
        }
        return SingletonIterator.makeIterator(item2);
    }

    public static SequenceIterator leading(XPathContext xPathContext, SequenceIterator sequenceIterator, Evaluate.PreparedExpression preparedExpression) {
        if (sequenceIterator == null) {
            return EmptyIterator.getInstance();
        }
        if (preparedExpression == null) {
            return EmptyIterator.getInstance();
        }
        XPathContextMinor xPathContextMinor = xPathContext.newMinorContext();
        xPathContextMinor.setOriginatingConstructType(2052);
        return new FilterIterator.Leading(sequenceIterator, preparedExpression.expression, xPathContextMinor);
    }

    public static SequenceIterator after(XPathContext xPathContext, SequenceIterator sequenceIterator, SequenceIterator sequenceIterator2) throws XPathException {
        Object object;
        Object object2;
        block4: {
            Object object3;
            object2 = null;
            GlobalOrderComparer globalOrderComparer = GlobalOrderComparer.getInstance();
            while (true) {
                if ((object = sequenceIterator2.next()) == null) {
                    if (object2 == null) {
                        return sequenceIterator;
                    }
                    break block4;
                }
                if (!(object instanceof NodeInfo)) break;
                object3 = (NodeInfo)object;
                if (object2 == null) {
                    object2 = object3;
                    continue;
                }
                if (globalOrderComparer.compare((NodeInfo)object3, (NodeInfo)object2) >= 0) continue;
                object2 = object3;
            }
            object3 = new DynamicError("Operand of after() contains an item that is not a node");
            ((DynamicError)object3).setXPathContext(xPathContext);
            throw object3;
        }
        object = new IdentityComparison(new ContextItemExpression(), 38, new SingletonNode((NodeInfo)object2));
        return new FilterIterator(sequenceIterator, (Expression)object, xPathContext);
    }

    public static SequenceIterator tokenize(String string) {
        if (string == null) {
            return EmptyIterator.getInstance();
        }
        return new StringTokenIterator(string);
    }

    public static SequenceIterator tokenize(String string, String string2) {
        if (string == null) {
            return EmptyIterator.getInstance();
        }
        if (string2 == null) {
            return new StringTokenIterator(string);
        }
        return new StringTokenIterator(string, string2);
    }

    public static String path(XPathContext xPathContext) throws XPathException {
        Item item = xPathContext.getContextItem();
        if (item == null) {
            DynamicError dynamicError = new DynamicError("The context item for saxon:path() is not set");
            dynamicError.setXPathContext(xPathContext);
            throw dynamicError;
        }
        if (item instanceof NodeInfo) {
            return Navigator.getPath((NodeInfo)item);
        }
        return "";
    }

    public static String typeAnnotation(XPathContext xPathContext, NodeInfo nodeInfo) {
        if (nodeInfo == null) {
            return null;
        }
        int n2 = nodeInfo.getTypeAnnotation();
        if ((n2 & 0x40000000) != 0) {
            n2 = 642;
        }
        if (n2 == -1) {
            int n3 = nodeInfo.getNodeKind();
            if (n3 == 1 || n3 == 9) {
                return "untyped";
            }
            return "untypedAtomic";
        }
        SchemaType schemaType = xPathContext.getConfiguration().getSchemaType(n2 & 0xFFFFF);
        if (schemaType == null) {
            return xPathContext.getNamePool().getDisplayName(n2);
        }
        return "type " + schemaType.getDescription();
    }

    public static XPathContext getContext(XPathContext xPathContext) {
        return xPathContext;
    }

    public static Controller getController(XPathContext xPathContext) {
        return xPathContext.getController();
    }

    public static Configuration getConfiguration(XPathContext xPathContext) {
        return xPathContext.getConfiguration();
    }

    public static String getPseudoAttribute(XPathContext xPathContext, String string) throws XPathException {
        if (string == null) {
            return null;
        }
        Item item = xPathContext.getContextItem();
        if (item == null) {
            DynamicError dynamicError = new DynamicError("The context item for saxon:getPseudoAttribute() is not set");
            dynamicError.setXPathContext(xPathContext);
            throw dynamicError;
        }
        String string2 = ProcInstParser.getPseudoAttribute(item.getStringValue(), string);
        if (string2 == null) {
            return "";
        }
        return string2;
    }

    public static SecondsDurationValue dayTimeDurationFromSeconds(BigDecimal bigDecimal) throws XPathException {
        return SecondsDurationValue.fromSeconds(bigDecimal);
    }

    public static MonthDurationValue yearMonthDurationFromMonths(int n2) {
        return MonthDurationValue.fromMonths(n2);
    }

    public static BigDecimal decimalDivide(BigDecimal bigDecimal, BigDecimal bigDecimal2, int n2) {
        if (bigDecimal == null || bigDecimal2 == null) {
            return null;
        }
        return bigDecimal.divide(bigDecimal2, n2, 1);
    }

    public static List stringToUtf8(String string) {
        if (string == null) {
            return Collections.EMPTY_LIST;
        }
        ArrayList<Integer> arrayList = new ArrayList<Integer>(string.length() * 2);
        byte[] byArray = new byte[4];
        for (int i2 = 0; i2 < string.length(); ++i2) {
            int n2 = UnicodeCharacterSet.getUTF8Encoding(string.charAt(i2), i2 + 1 < string.length() ? string.charAt(i2 + 1) : (char)'\u0000', byArray);
            for (int i3 = 0; i3 < n2; ++i3) {
                arrayList.add(new Integer(0xFF & byArray[i3]));
            }
        }
        return arrayList;
    }

    public static Base64BinaryValue octetsToBase64Binary(byte[] byArray) {
        if (byArray == null) {
            return null;
        }
        return new Base64BinaryValue(byArray);
    }

    public static HexBinaryValue octetsToHexBinary(byte[] byArray) {
        if (byArray == null) {
            return null;
        }
        return new HexBinaryValue(byArray);
    }

    public static byte[] base64BinaryToOctets(Base64BinaryValue base64BinaryValue) {
        if (base64BinaryValue == null) {
            return null;
        }
        return base64BinaryValue.getBinaryValue();
    }

    public static byte[] hexBinaryToOctets(HexBinaryValue hexBinaryValue) {
        if (hexBinaryValue == null) {
            return null;
        }
        return hexBinaryValue.getBinaryValue();
    }

    public static String base64BinaryToString(XPathContext xPathContext, Base64BinaryValue base64BinaryValue, String string) throws Exception {
        if (base64BinaryValue == null) {
            return null;
        }
        if (string == null) {
            string = "UTF-8";
        }
        byte[] byArray = base64BinaryValue.getBinaryValue();
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
        InputStreamReader inputStreamReader = new InputStreamReader((InputStream)byteArrayInputStream, string);
        char[] cArray = new char[byArray.length];
        int n2 = inputStreamReader.read(cArray, 0, cArray.length);
        Extensions.checkBytes(cArray, 0, n2, xPathContext.getConfiguration().getNameChecker());
        return new String(cArray, 0, n2);
    }

    public static Base64BinaryValue stringToBase64Binary(String string, String string2) throws UnsupportedEncodingException, IOException {
        if (string == null) {
            return null;
        }
        if (string2 == null) {
            string2 = "UTF-8";
        }
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(string.length());
        OutputStreamWriter outputStreamWriter = new OutputStreamWriter((OutputStream)byteArrayOutputStream, string2);
        outputStreamWriter.write(string);
        outputStreamWriter.close();
        byte[] byArray = byteArrayOutputStream.toByteArray();
        return Extensions.octetsToBase64Binary(byArray);
    }

    public static String hexBinaryToString(XPathContext xPathContext, HexBinaryValue hexBinaryValue, String string) throws Exception {
        if (hexBinaryValue == null) {
            return null;
        }
        if (string == null) {
            string = "UTF-8";
        }
        byte[] byArray = hexBinaryValue.getBinaryValue();
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
        InputStreamReader inputStreamReader = new InputStreamReader((InputStream)byteArrayInputStream, string);
        char[] cArray = new char[byArray.length];
        int n2 = inputStreamReader.read(cArray, 0, cArray.length);
        Extensions.checkBytes(cArray, 0, n2, xPathContext.getConfiguration().getNameChecker());
        return new String(cArray, 0, n2);
    }

    private static void checkBytes(char[] cArray, int n2, int n3, NameChecker nameChecker) throws XPathException {
        for (int i2 = n2; i2 < n3; ++i2) {
            int n4 = cArray[i2];
            if (XMLChar.isHighSurrogate(n4)) {
                char c2 = cArray[i2++];
                n4 = XMLChar.supplemental((char)n4, c2);
            }
            if (nameChecker.isValidChar(n4)) continue;
            DynamicError dynamicError = new DynamicError("The byte sequence contains a character not allowed by XML (hex " + Integer.toHexString(n4) + ')');
            dynamicError.setErrorCode("XTDE1180");
            throw dynamicError;
        }
    }

    public static HexBinaryValue stringToHexBinary(String string, String string2) throws Exception {
        if (string == null) {
            return null;
        }
        if (string2 == null) {
            string2 = "UTF-8";
        }
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(string.length());
        OutputStreamWriter outputStreamWriter = new OutputStreamWriter((OutputStream)byteArrayOutputStream, string2);
        outputStreamWriter.write(string);
        outputStreamWriter.close();
        byte[] byArray = byteArrayOutputStream.toByteArray();
        return Extensions.octetsToHexBinary(byArray);
    }

    public static boolean validCharacter(XPathContext xPathContext, int n2) {
        return xPathContext.getConfiguration().getNameChecker().isValidChar(n2);
    }

    public static NodeInfo namespaceNode(XPathContext xPathContext, String string, String string2) throws XPathException {
        if (string == null) {
            string = "";
        }
        if (!"".equals(string) && !xPathContext.getConfiguration().getNameChecker().isValidNCName(string)) {
            DynamicError dynamicError = new DynamicError("Namespace prefix " + Err.wrap(string) + " is not a valid NCName");
            throw dynamicError;
        }
        if (string2 == null || "".equals(string2)) {
            DynamicError dynamicError = new DynamicError("URI of namespace node must not be empty");
            throw dynamicError;
        }
        NamePool namePool = xPathContext.getNamePool();
        Orphan orphan = new Orphan(xPathContext.getConfiguration());
        orphan.setNodeKind((short)13);
        orphan.setNameCode(namePool.allocate("", "", string));
        orphan.setStringValue(string2);
        return orphan;
    }

    public static boolean deepEqual(XPathContext xPathContext, SequenceIterator sequenceIterator, SequenceIterator sequenceIterator2, String string, String string2) throws XPathException {
        Serializable serializable;
        if (string2.indexOf(33) >= 0) {
            serializable = new Properties();
            serializable.setProperty("indent", "yes");
            System.err.println("DeepEqual: first argument:");
            QueryResult.serialize(QueryResult.wrap(sequenceIterator.getAnother(), xPathContext.getConfiguration()), new StreamResult(System.err), serializable, xPathContext.getConfiguration());
            System.err.println("DeepEqual: second argument:");
            QueryResult.serialize(QueryResult.wrap(sequenceIterator2.getAnother(), xPathContext.getConfiguration()), new StreamResult(System.err), serializable, xPathContext.getConfiguration());
        }
        serializable = string == null ? new AtomicComparer(xPathContext.getDefaultCollation(), xPathContext) : new AtomicComparer(xPathContext.getCollation(string), xPathContext);
        int n2 = 0;
        if (string2.indexOf("N") >= 0) {
            n2 |= 1;
        }
        if (string2.indexOf("C") >= 0) {
            n2 |= 4;
        }
        if (string2.indexOf("P") >= 0) {
            n2 |= 8;
        }
        if (string2.indexOf("F") >= 0) {
            n2 |= 2;
        }
        if (string2.indexOf("S") >= 0) {
            n2 |= 0x20;
        }
        if (string2.indexOf("A") >= 0) {
            n2 |= 0x40;
        }
        if (string2.indexOf("w") >= 0) {
            n2 |= 0x10;
        }
        if (string2.indexOf("?") >= 0) {
            n2 |= 0x80;
        }
        return DeepEqual.deepEquals(sequenceIterator, sequenceIterator2, (AtomicComparer)serializable, xPathContext.getConfiguration(), n2);
    }

    public static Templates compileStylesheet(XPathContext xPathContext, DocumentInfo documentInfo) throws XPathException {
        if (documentInfo == null) {
            return null;
        }
        try {
            TransformerFactoryImpl transformerFactoryImpl = new TransformerFactoryImpl(xPathContext.getConfiguration());
            Templates templates = transformerFactoryImpl.newTemplates(documentInfo);
            return templates;
        }
        catch (TransformerConfigurationException transformerConfigurationException) {
            throw DynamicError.makeDynamicError(transformerConfigurationException);
        }
    }

    public static DocumentInfo transform(XPathContext xPathContext, Templates templates, NodeInfo nodeInfo) throws XPathException {
        if (templates == null) {
            return null;
        }
        if (nodeInfo == null) {
            return null;
        }
        try {
            Transformer transformer = templates.newTransformer();
            TinyBuilder tinyBuilder = new TinyBuilder();
            tinyBuilder.setPipelineConfiguration(xPathContext.getController().makePipelineConfiguration());
            transformer.transform(nodeInfo, tinyBuilder);
            return (DocumentInfo)tinyBuilder.getCurrentRoot();
        }
        catch (TransformerException transformerException) {
            throw DynamicError.makeDynamicError(transformerException);
        }
    }
}

