/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.expr;

import net.sf.saxon.om.Item;
import net.sf.saxon.om.LookaheadIterator;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.sort.NodeOrderComparer;
import net.sf.saxon.trans.XPathException;

public class UnionEnumeration
implements SequenceIterator,
LookaheadIterator {
    private SequenceIterator e1;
    private SequenceIterator e2;
    private NodeInfo nextNode1 = null;
    private NodeInfo nextNode2 = null;
    private NodeOrderComparer comparer;
    private NodeInfo current = null;
    private int position = 0;

    public UnionEnumeration(SequenceIterator sequenceIterator, SequenceIterator sequenceIterator2, NodeOrderComparer nodeOrderComparer) throws XPathException {
        this.e1 = sequenceIterator;
        this.e2 = sequenceIterator2;
        this.comparer = nodeOrderComparer;
        this.nextNode1 = this.next(this.e1);
        this.nextNode2 = this.next(this.e2);
    }

    private NodeInfo next(SequenceIterator sequenceIterator) throws XPathException {
        return (NodeInfo)sequenceIterator.next();
    }

    public boolean hasNext() {
        return this.nextNode1 != null || this.nextNode2 != null;
    }

    public Item next() throws XPathException {
        ++this.position;
        if (this.nextNode1 != null && this.nextNode2 != null) {
            int n2 = this.comparer.compare(this.nextNode1, this.nextNode2);
            if (n2 < 0) {
                this.current = this.nextNode1;
                this.nextNode1 = this.next(this.e1);
                return this.current;
            }
            if (n2 > 0) {
                this.current = this.nextNode2;
                this.nextNode2 = this.next(this.e2);
                return this.current;
            }
            this.current = this.nextNode2;
            this.nextNode2 = this.next(this.e2);
            this.nextNode1 = this.next(this.e1);
            return this.current;
        }
        if (this.nextNode1 != null) {
            this.current = this.nextNode1;
            this.nextNode1 = this.next(this.e1);
            return this.current;
        }
        if (this.nextNode2 != null) {
            this.current = this.nextNode2;
            this.nextNode2 = this.next(this.e2);
            return this.current;
        }
        this.current = null;
        this.position = -1;
        return null;
    }

    public Item current() {
        return this.current;
    }

    public int position() {
        return this.position;
    }

    public SequenceIterator getAnother() throws XPathException {
        return new UnionEnumeration(this.e1.getAnother(), this.e2.getAnother(), this.comparer);
    }

    public int getProperties() {
        return 4;
    }
}

