/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.expr;

import java.io.PrintStream;
import java.util.Iterator;
import net.sf.saxon.Configuration;
import net.sf.saxon.expr.ComputedExpression;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.ExpressionTool;
import net.sf.saxon.expr.LastPositionFinder;
import net.sf.saxon.expr.MonoIterator;
import net.sf.saxon.expr.Optimizer;
import net.sf.saxon.expr.PromotionOffer;
import net.sf.saxon.expr.StaticContext;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.om.ArrayIterator;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.LookaheadIterator;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.type.ItemType;
import net.sf.saxon.type.TypeHierarchy;

public class TailExpression
extends ComputedExpression {
    Expression base;
    int start;

    public TailExpression(Expression expression, int n2) {
        this.base = expression;
        this.start = n2;
        this.adoptChildExpression(expression);
    }

    public Expression typeCheck(StaticContext staticContext, ItemType itemType) throws XPathException {
        this.base = this.base.typeCheck(staticContext, itemType);
        return this;
    }

    public Expression optimize(Optimizer optimizer, StaticContext staticContext, ItemType itemType) throws XPathException {
        this.base = this.base.optimize(optimizer, staticContext, itemType);
        return this;
    }

    public Expression promote(PromotionOffer promotionOffer) throws XPathException {
        Expression expression = promotionOffer.accept(this);
        if (expression != null) {
            return expression;
        }
        if (promotionOffer.action != 13) {
            this.base = this.doPromotion(this.base, promotionOffer);
        }
        return this;
    }

    public int computeSpecialProperties() {
        return this.base.getSpecialProperties();
    }

    public ItemType getItemType(TypeHierarchy typeHierarchy) {
        return this.base.getItemType(typeHierarchy);
    }

    public int computeCardinality() {
        return this.base.getCardinality() | 0x2000;
    }

    public Iterator iterateSubExpressions() {
        return new MonoIterator(this.base);
    }

    public Expression getBaseExpression() {
        return this.base;
    }

    public int getStart() {
        return this.start;
    }

    public boolean equals(Object object) {
        return object instanceof TailExpression && this.base.equals(((TailExpression)object).base) && this.start == ((TailExpression)object).start;
    }

    public int hashCode() {
        return this.base.hashCode();
    }

    public SequenceIterator iterate(XPathContext xPathContext) throws XPathException {
        SequenceIterator sequenceIterator = this.base.iterate(xPathContext);
        if (sequenceIterator instanceof ArrayIterator) {
            return ((ArrayIterator)sequenceIterator).makeSliceIterator(this.start, Integer.MAX_VALUE);
        }
        return new TailIterator(sequenceIterator, this.start);
    }

    public void display(int n2, PrintStream printStream, Configuration configuration) {
        printStream.println(ExpressionTool.indent(n2) + "tail " + this.start);
        this.base.display(n2 + 1, printStream, configuration);
    }

    public static class TailIterator
    implements SequenceIterator,
    LastPositionFinder,
    LookaheadIterator {
        private SequenceIterator base;
        private int start;

        public TailIterator(SequenceIterator sequenceIterator, int n2) throws XPathException {
            this.base = sequenceIterator;
            this.start = n2;
            for (int i2 = 0; i2 < n2 - 1; ++i2) {
                sequenceIterator.next();
            }
        }

        public Item next() throws XPathException {
            return this.base.next();
        }

        public Item current() {
            return this.base.current();
        }

        public int position() {
            return this.base.position() - this.start + 1;
        }

        public boolean hasNext() {
            return ((LookaheadIterator)this.base).hasNext();
        }

        public int getLastPosition() throws XPathException {
            return ((LastPositionFinder)this.base).getLastPosition() - this.start + 1;
        }

        public SequenceIterator getAnother() throws XPathException {
            return new TailIterator(this.base.getAnother(), this.start);
        }

        public int getProperties() {
            return this.base.getProperties() & 6;
        }
    }
}

