/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.expr;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import net.sf.saxon.expr.Binding;
import net.sf.saxon.expr.BindingReference;
import net.sf.saxon.expr.ComputedExpression;
import net.sf.saxon.expr.Container;
import net.sf.saxon.expr.ExpressionTool;
import net.sf.saxon.expr.FilterExpression;
import net.sf.saxon.expr.StaticContext;
import net.sf.saxon.expr.VariableDeclaration;
import net.sf.saxon.expr.VariableReference;
import net.sf.saxon.instruct.UserFunction;
import net.sf.saxon.instruct.UserFunctionParameter;
import net.sf.saxon.type.ItemType;
import net.sf.saxon.type.TypeHierarchy;
import net.sf.saxon.value.SequenceType;
import net.sf.saxon.value.Value;

public class RangeVariableDeclaration
implements VariableDeclaration {
    private int nameCode;
    private SequenceType requiredType;
    private String variableName;
    private List references = new ArrayList(5);
    public static final int FILTERED = 10000;

    public void setNameCode(int n2) {
        this.nameCode = n2;
    }

    public int getNameCode() {
        return this.nameCode;
    }

    public SequenceType getRequiredType() {
        return this.requiredType;
    }

    public void setRequiredType(SequenceType sequenceType) {
        this.requiredType = sequenceType;
    }

    public void setVariableName(String string) {
        this.variableName = string;
    }

    public String getVariableName() {
        return this.variableName;
    }

    public void registerReference(BindingReference bindingReference) {
        this.references.add(bindingReference);
    }

    public void setReferenceList(List list) {
        this.references = list;
    }

    public List getReferenceList() {
        return this.references;
    }

    public int getReferenceCount(Binding binding, StaticContext staticContext) {
        return RangeVariableDeclaration.getReferenceCount(this.references, binding, staticContext, true);
    }

    public static int getReferenceCount(List list, Binding binding, StaticContext staticContext, boolean bl) {
        int n2;
        if (bl) {
            for (n2 = list.size() - 1; n2 >= 0; --n2) {
                if (((VariableReference)list.get(n2)).getBinding() != null) continue;
                list.remove(n2);
            }
        }
        n2 = 0;
        block1: for (int i2 = list.size() - 1; i2 >= 0; --i2) {
            BindingReference bindingReference = (BindingReference)list.get(i2);
            if (bindingReference instanceof VariableReference) {
                VariableReference variableReference = (VariableReference)bindingReference;
                ComputedExpression computedExpression = variableReference;
                Container container = variableReference.getParentExpression();
                boolean bl2 = container instanceof FilterExpression && computedExpression == ((FilterExpression)container).getBaseExpression();
                int n3 = 0;
                while (container instanceof ComputedExpression) {
                    if (container == binding) {
                        ++n2;
                        continue block1;
                    }
                    if (bl2 && container instanceof FilterExpression && computedExpression == ((FilterExpression)container).getBaseExpression()) {
                        return 10000;
                    }
                    if (ExpressionTool.isRepeatedSubexpression((ComputedExpression)container, computedExpression, staticContext)) {
                        n2 += 10;
                        continue block1;
                    }
                    computedExpression = (ComputedExpression)container;
                    if ((container = computedExpression.getParentExpression()) == null) {
                        n2 += 10;
                        continue block1;
                    }
                    if (n3++ <= 10000) continue;
                    throw new IllegalStateException("The expression tree appears to contain a cycle");
                }
                if (container instanceof UserFunction) {
                    UserFunctionParameter[] userFunctionParameterArray = ((UserFunction)container).getParameterDefinitions();
                    for (int i3 = 0; i3 < userFunctionParameterArray.length; ++i3) {
                        if (userFunctionParameterArray[i3] != binding) continue;
                        int n4 = userFunctionParameterArray[i3].getReferenceCount();
                        n2 += n4;
                    }
                    n2 += 10;
                    continue;
                }
                n2 += 10;
                continue;
            }
            ++n2;
        }
        return n2;
    }

    public void fixupReferences(Binding binding) {
        Iterator iterator = this.references.iterator();
        while (iterator.hasNext()) {
            BindingReference bindingReference = (BindingReference)iterator.next();
            bindingReference.setStaticType(this.requiredType, null, 0);
            bindingReference.fixup(binding);
        }
    }

    public void refineTypeInformation(ItemType itemType, int n2, Value value, int n3, StaticContext staticContext) {
        Iterator iterator = this.references.iterator();
        while (iterator.hasNext()) {
            int n4;
            ItemType itemType2;
            BindingReference bindingReference = (BindingReference)iterator.next();
            if (!(bindingReference instanceof VariableReference)) continue;
            TypeHierarchy typeHierarchy = staticContext.getConfiguration().getTypeHierarchy();
            ItemType itemType3 = itemType2 = ((VariableReference)bindingReference).getItemType(typeHierarchy);
            if (staticContext.getConfiguration().getTypeHierarchy().isSubType(itemType, itemType2)) {
                itemType3 = itemType;
            }
            if ((n4 = n2 & ((VariableReference)bindingReference).getCardinality()) == 0) {
                n4 = ((VariableReference)bindingReference).getCardinality();
            }
            SequenceType sequenceType = SequenceType.makeSequenceType(itemType3, n4);
            bindingReference.setStaticType(sequenceType, value, n3);
            ((VariableReference)bindingReference).resetStaticProperties();
        }
    }
}

