/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.expr;

import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import net.sf.saxon.Configuration;
import net.sf.saxon.expr.ComputedExpression;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.ExpressionTool;
import net.sf.saxon.expr.Optimizer;
import net.sf.saxon.expr.PairIterator;
import net.sf.saxon.expr.PromotionOffer;
import net.sf.saxon.expr.StaticContext;
import net.sf.saxon.expr.Token;
import net.sf.saxon.trans.DynamicError;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.type.ItemType;
import net.sf.saxon.value.Cardinality;
import net.sf.saxon.value.Value;

public abstract class BinaryExpression
extends ComputedExpression {
    protected Expression operand0;
    protected Expression operand1;
    protected int operator;

    public BinaryExpression(Expression expression, int n2, Expression expression2) {
        this.operator = n2;
        this.operand0 = expression;
        this.operand1 = expression2;
        this.adoptChildExpression(expression);
        this.adoptChildExpression(expression2);
    }

    public Expression simplify(StaticContext staticContext) throws XPathException {
        this.operand0 = this.operand0.simplify(staticContext);
        this.operand1 = this.operand1.simplify(staticContext);
        return this;
    }

    public Expression typeCheck(StaticContext staticContext, ItemType itemType) throws XPathException {
        this.operand0 = this.operand0.typeCheck(staticContext, itemType);
        this.operand1 = this.operand1.typeCheck(staticContext, itemType);
        try {
            if (this.operand0 instanceof Value && this.operand1 instanceof Value) {
                return ExpressionTool.eagerEvaluate(this, staticContext.makeEarlyEvaluationContext());
            }
        }
        catch (DynamicError dynamicError) {
            // empty catch block
        }
        return this;
    }

    public Expression optimize(Optimizer optimizer, StaticContext staticContext, ItemType itemType) throws XPathException {
        this.operand0 = this.operand0.optimize(optimizer, staticContext, itemType);
        this.operand1 = this.operand1.optimize(optimizer, staticContext, itemType);
        try {
            if (this.operand0 instanceof Value && this.operand1 instanceof Value) {
                return ExpressionTool.eagerEvaluate(this, staticContext.makeEarlyEvaluationContext());
            }
        }
        catch (DynamicError dynamicError) {
            // empty catch block
        }
        return this;
    }

    public Expression promote(PromotionOffer promotionOffer) throws XPathException {
        Expression expression = promotionOffer.accept(this);
        if (expression != null) {
            return expression;
        }
        if (promotionOffer.action != 13) {
            this.operand0 = this.doPromotion(this.operand0, promotionOffer);
            this.operand1 = this.doPromotion(this.operand1, promotionOffer);
        }
        return this;
    }

    public Iterator iterateSubExpressions() {
        return new PairIterator(this.operand0, this.operand1);
    }

    public int getOperator() {
        return this.operator;
    }

    public Expression[] getOperands() {
        Expression[] expressionArray = new Expression[]{this.operand0, this.operand1};
        return expressionArray;
    }

    public int computeCardinality() {
        if (Cardinality.allowsZero(this.operand0.getCardinality()) || Cardinality.allowsZero(this.operand1.getCardinality())) {
            return 24576;
        }
        return 16384;
    }

    public int computeSpecialProperties() {
        int n2 = super.computeSpecialProperties();
        return n2 | 0x400000;
    }

    protected static boolean isCommutative(int n2) {
        return n2 == 10 || n2 == 9 || n2 == 1 || n2 == 23 || n2 == 15 || n2 == 17 || n2 == 6 || n2 == 44 || n2 == 22 || n2 == 45;
    }

    protected static boolean isAssociative(int n2) {
        return n2 == 10 || n2 == 9 || n2 == 1 || n2 == 23 || n2 == 15 || n2 == 17;
    }

    protected static boolean isInverse(int n2, int n3) {
        return n2 != n3 && n2 == Token.inverse(n3);
    }

    public boolean equals(Object object) {
        if (object instanceof BinaryExpression) {
            BinaryExpression binaryExpression = (BinaryExpression)object;
            if (this.operator == binaryExpression.operator) {
                if (this.operand0.equals(binaryExpression.operand0) && this.operand1.equals(binaryExpression.operand1)) {
                    return true;
                }
                if (BinaryExpression.isCommutative(this.operator) && this.operand0.equals(binaryExpression.operand1) && this.operand1.equals(binaryExpression.operand0)) {
                    return true;
                }
                if (BinaryExpression.isAssociative(this.operator) && this.pairwiseEqual(this.flattenExpression(new ArrayList(4)), binaryExpression.flattenExpression(new ArrayList(4)))) {
                    return true;
                }
            }
            if (BinaryExpression.isInverse(this.operator, binaryExpression.operator) && this.operand0.equals(binaryExpression.operand1) && this.operand1.equals(binaryExpression.operand0)) {
                return true;
            }
        }
        return false;
    }

    private List flattenExpression(List list) {
        int n2;
        int n3;
        if (this.operand0 instanceof BinaryExpression && ((BinaryExpression)this.operand0).operator == this.operator) {
            ((BinaryExpression)this.operand0).flattenExpression(list);
        } else {
            n3 = this.operand0.hashCode();
            list.add(this.operand0);
            for (n2 = list.size() - 1; n2 > 0 && n3 > list.get(n2 - 1).hashCode(); --n2) {
                list.set(n2, list.get(n2 - 1));
                list.set(n2 - 1, this.operand0);
            }
        }
        if (this.operand1 instanceof BinaryExpression && ((BinaryExpression)this.operand1).operator == this.operator) {
            ((BinaryExpression)this.operand1).flattenExpression(list);
        } else {
            n3 = this.operand1.hashCode();
            list.add(this.operand1);
            for (n2 = list.size() - 1; n2 > 0 && n3 > list.get(n2 - 1).hashCode(); --n2) {
                list.set(n2, list.get(n2 - 1));
                list.set(n2 - 1, this.operand1);
            }
        }
        return list;
    }

    private boolean pairwiseEqual(List list, List list2) {
        if (list.size() != list2.size()) {
            return false;
        }
        for (int i2 = 0; i2 < list.size(); ++i2) {
            if (list.get(i2).equals(list2.get(i2))) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        int n2 = Math.min(this.operator, Token.inverse(this.operator));
        return ("BinaryExpression " + n2).hashCode() ^ this.operand0.hashCode() ^ this.operand1.hashCode();
    }

    public void display(int n2, PrintStream printStream, Configuration configuration) {
        printStream.println(ExpressionTool.indent(n2) + "operator " + this.displayOperator());
        this.operand0.display(n2 + 1, printStream, configuration);
        this.operand1.display(n2 + 1, printStream, configuration);
    }

    protected String displayOperator() {
        return Token.tokens[this.operator];
    }
}

