/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.event;

import net.sf.saxon.Controller;
import net.sf.saxon.event.PipelineConfiguration;
import net.sf.saxon.event.ProxyReceiver;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.om.Orphan;
import net.sf.saxon.trans.Mode;
import net.sf.saxon.trans.Rule;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.type.ComplexType;
import net.sf.saxon.value.Whitespace;

public class Stripper
extends ProxyReceiver {
    private boolean preserveAll;
    private boolean stripAll;
    private byte[] stripStack = new byte[100];
    private int top = 0;
    private Mode stripperMode;
    private Orphan element;
    private XPathContext context;
    public static final byte ALWAYS_PRESERVE = 1;
    public static final byte ALWAYS_STRIP = 2;
    public static final byte STRIP_DEFAULT = 0;
    public static final byte PRESERVE_PARENT = 4;
    public static final byte CANNOT_STRIP = 8;

    protected Stripper() {
    }

    public Stripper(Mode mode) {
        this.stripperMode = mode;
        this.preserveAll = mode == null;
        this.stripAll = false;
    }

    public Stripper getAnother() {
        Stripper stripper = new Stripper(this.stripperMode);
        stripper.setPipelineConfiguration(this.getPipelineConfiguration());
        stripper.stripAll = this.stripAll;
        stripper.preserveAll = this.preserveAll;
        return stripper;
    }

    public void setStripAll() {
        this.preserveAll = false;
        this.stripAll = true;
    }

    public boolean getStripAll() {
        return this.stripAll;
    }

    public void setPipelineConfiguration(PipelineConfiguration pipelineConfiguration) {
        Controller controller;
        super.setPipelineConfiguration(pipelineConfiguration);
        if (this.context == null && (controller = pipelineConfiguration.getController()) != null) {
            this.context = controller.newXPathContext();
        }
        if (this.element == null) {
            this.element = new Orphan(pipelineConfiguration.getConfiguration());
            this.element.setNodeKind((short)1);
        }
    }

    public byte isSpacePreserving(int n2) {
        try {
            if (this.preserveAll) {
                return 1;
            }
            if (this.stripAll) {
                return 0;
            }
            this.element.setNameCode(n2);
            Rule rule = this.stripperMode.getRule(this.element, this.context);
            if (rule == null) {
                return 1;
            }
            return (Boolean)rule.getAction() != false ? (byte)1 : 0;
        }
        catch (XPathException xPathException) {
            return 1;
        }
    }

    public byte isSpacePreserving(NodeInfo nodeInfo) {
        try {
            if (this.preserveAll) {
                return 1;
            }
            if (this.stripAll) {
                return 0;
            }
            Rule rule = this.stripperMode.getRule(nodeInfo, this.context);
            if (rule == null) {
                return 1;
            }
            return (Boolean)rule.getAction() != false ? (byte)1 : 0;
        }
        catch (XPathException xPathException) {
            return 1;
        }
    }

    public void open() throws XPathException {
        this.top = 0;
        this.stripStack[this.top] = 1;
        super.open();
    }

    public void startElement(int n2, int n3, int n4, int n5) throws XPathException {
        Object object;
        super.startElement(n2, n3, n4, n5);
        byte by = this.stripStack[this.top];
        byte by2 = (byte)(by & 4);
        byte by3 = this.isSpacePreserving(n2);
        if (by3 == 1) {
            by2 = (byte)(by2 | 1);
        } else if (by3 == 2) {
            by2 = (byte)(by2 | 2);
        }
        if (by2 == 0 && n3 != -1 && n3 != 641 && ((object = this.getConfiguration().getSchemaType(n3)).isSimpleType() || ((ComplexType)object).isSimpleContent())) {
            by2 = (byte)(by2 | 8);
        }
        ++this.top;
        if (this.top >= this.stripStack.length) {
            object = new byte[this.top * 2];
            System.arraycopy(this.stripStack, 0, object, 0, this.top);
            this.stripStack = (byte[])object;
        }
        this.stripStack[this.top] = by2;
    }

    public void attribute(int n2, int n3, CharSequence charSequence, int n4, int n5) throws XPathException {
        if ((n2 & 0xFFFFF) == 386) {
            if (((Object)charSequence).toString().equals("preserve")) {
                int n6 = this.top;
                this.stripStack[n6] = (byte)(this.stripStack[n6] | 4);
            } else {
                int n7 = this.top;
                this.stripStack[n7] = (byte)(this.stripStack[n7] & 0xFFFFFFFB);
            }
        }
        super.attribute(n2, n3, charSequence, n4, n5);
    }

    public void endElement() throws XPathException {
        super.endElement();
        --this.top;
    }

    public void characters(CharSequence charSequence, int n2, int n3) throws XPathException {
        if (charSequence.length() > 0 && ((this.stripStack[this.top] & 0xD) != 0 && (this.stripStack[this.top] & 2) == 0 || !Whitespace.isWhite(charSequence))) {
            super.characters(charSequence, n2, n3);
        }
    }
}

