/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.event;

import java.util.ArrayList;
import java.util.Iterator;
import net.sf.saxon.event.PipelineConfiguration;
import net.sf.saxon.event.ProxyReceiver;
import net.sf.saxon.om.AttributeCollectionImpl;
import net.sf.saxon.om.NamePool;
import net.sf.saxon.om.NamespaceResolver;
import net.sf.saxon.trans.XPathException;

public class StartTagBuffer
extends ProxyReceiver
implements NamespaceResolver {
    int elementNameCode;
    int elementTypeCode;
    int elementLocationId;
    int elementProperties;
    AttributeCollectionImpl bufferedAttributes;
    private int[] namespaces = new int[50];
    private int namespacesSize = 0;
    private int[] countStack = new int[50];
    private int depth = 0;

    public void setPipelineConfiguration(PipelineConfiguration pipelineConfiguration) {
        super.setPipelineConfiguration(pipelineConfiguration);
        this.bufferedAttributes = new AttributeCollectionImpl(this.getNamePool());
    }

    public void startElement(int n2, int n3, int n4, int n5) throws XPathException {
        this.elementNameCode = n2;
        this.elementTypeCode = n3;
        this.elementLocationId = n4;
        this.elementProperties = n5;
        this.bufferedAttributes.clear();
        this.countStack[this.depth] = 0;
        if (++this.depth >= this.countStack.length) {
            int[] nArray = new int[this.depth * 2];
            System.arraycopy(this.countStack, 0, nArray, 0, this.depth);
            this.countStack = nArray;
        }
    }

    public void namespace(int n2, int n3) throws XPathException {
        this.addToStack(n2);
        int n4 = this.depth - 1;
        this.countStack[n4] = this.countStack[n4] + 1;
    }

    public void attribute(int n2, int n3, CharSequence charSequence, int n4, int n5) throws XPathException {
        this.bufferedAttributes.addAttribute(n2, n3, ((Object)charSequence).toString(), n4, n5);
    }

    private void addToStack(int n2) {
        if (this.namespacesSize + 1 >= this.namespaces.length) {
            int[] nArray = new int[this.namespacesSize * 2];
            System.arraycopy(this.namespaces, 0, nArray, 0, this.namespacesSize);
            this.namespaces = nArray;
        }
        this.namespaces[this.namespacesSize++] = n2;
    }

    public void startContent() throws XPathException {
        super.startElement(this.elementNameCode, this.elementTypeCode, this.elementLocationId, this.elementProperties);
        this.declareNamespacesForStartElement();
        int n2 = this.bufferedAttributes.getLength();
        for (int i2 = 0; i2 < n2; ++i2) {
            super.attribute(this.bufferedAttributes.getNameCode(i2), this.bufferedAttributes.getTypeAnnotation(i2), this.bufferedAttributes.getValue(i2), this.bufferedAttributes.getLocationId(i2), this.bufferedAttributes.getProperties(i2));
        }
        super.startContent();
    }

    protected void declareNamespacesForStartElement() throws XPathException {
        for (int i2 = this.namespacesSize - this.countStack[this.depth - 1]; i2 < this.namespacesSize; ++i2) {
            super.namespace(this.namespaces[i2], 0);
        }
    }

    protected void declareAllNamespaces() throws XPathException {
        for (int i2 = 0; i2 < this.namespacesSize; ++i2) {
            super.namespace(this.namespaces[i2], 0);
        }
    }

    public void endElement() throws XPathException {
        super.endElement();
        this.undeclareNamespacesForElement();
    }

    protected void undeclareNamespacesForElement() {
        int n2 = this.countStack[--this.depth];
        this.namespacesSize -= n2;
    }

    public int getElementNameCode() {
        return this.elementNameCode;
    }

    public boolean hasAttributes() {
        return this.bufferedAttributes.getLength() > 0;
    }

    public String getAttribute(int n2) {
        return this.bufferedAttributes.getValueByFingerprint(n2 & 0xFFFFF);
    }

    protected short getURICode(short s2) {
        for (int i2 = this.namespacesSize - 1; i2 >= 0; --i2) {
            if (this.namespaces[i2] >> 16 != s2) continue;
            short s3 = (short)(this.namespaces[i2] & 0xFFFF);
            if (s3 == 0) break;
            return s3;
        }
        if (s2 == 0) {
            return 0;
        }
        return -1;
    }

    public String getURIForPrefix(String string, boolean bl) {
        NamePool namePool = this.getNamePool();
        if ("".equals(string) && !bl) {
            return "";
        }
        if ("xml".equals(string)) {
            return "http://www.w3.org/XML/1998/namespace";
        }
        short s2 = namePool.getCodeForPrefix(string);
        short s3 = this.getURICode(s2);
        if (s3 == -1) {
            return null;
        }
        return namePool.getURIFromURICode(s3);
    }

    public Iterator iteratePrefixes() {
        NamePool namePool = this.getNamePool();
        ArrayList<String> arrayList = new ArrayList<String>(this.namespacesSize);
        for (int i2 = this.namespacesSize - 1; i2 >= 0; --i2) {
            String string = namePool.getPrefixFromNamespaceCode(this.namespaces[i2]);
            if (arrayList.contains(string)) continue;
            arrayList.add(string);
        }
        arrayList.add("xml");
        return arrayList.iterator();
    }
}

