/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.dom;

import net.sf.saxon.Configuration;
import net.sf.saxon.type.AnyType;
import net.sf.saxon.type.SchemaType;
import org.w3c.dom.TypeInfo;

public class TypeInfoImpl
implements TypeInfo {
    private Configuration config;
    private SchemaType schemaType;

    public TypeInfoImpl(Configuration configuration, SchemaType schemaType) {
        this.config = configuration;
        this.schemaType = schemaType;
    }

    public String getTypeName() {
        return this.config.getNamePool().getLocalName(this.schemaType.getNameCode());
    }

    public String getTypeNamespace() {
        return this.config.getNamePool().getURI(this.schemaType.getNameCode());
    }

    public boolean isDerivedFrom(String string, String string2, int n2) throws IllegalStateException {
        SchemaType schemaType = this.schemaType.getBaseType();
        int n3 = this.config.getNamePool().allocate("", string, string2);
        if (n2 == 0 || (n2 & this.schemaType.getDerivationMethod()) != 0) {
            if (schemaType.getFingerprint() == n3) {
                return true;
            }
            if (schemaType instanceof AnyType) {
                return false;
            }
            return new TypeInfoImpl(this.config, schemaType).isDerivedFrom(string, string2, n2);
        }
        return false;
    }
}

