/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.charcode;

import net.sf.saxon.charcode.CharacterSet;

public final class UnicodeCharacterSet
implements CharacterSet {
    private static UnicodeCharacterSet theInstance = new UnicodeCharacterSet();

    private UnicodeCharacterSet() {
    }

    public static UnicodeCharacterSet getInstance() {
        return theInstance;
    }

    public boolean inCharset(int n2) {
        return true;
    }

    public static int getUTF8Encoding(char c2, char c3, byte[] byArray) {
        char c4 = c2;
        if (c4 <= '\u007f') {
            byArray[0] = (byte)c4;
            return 1;
        }
        if (c4 <= '\u07ff') {
            byArray[0] = (byte)(0xC0 | c2 >> 6 & 0x1F);
            byArray[1] = (byte)(0x80 | c2 & 0x3F);
            return 2;
        }
        if (c4 >= '\ud800' && c4 <= '\udbff') {
            char c5 = c3;
            if (c5 < '\udc00' || c5 > '\udfff') {
                throw new IllegalArgumentException("Malformed Unicode Surrogate Pair (" + c4 + ',' + c5 + ')');
            }
            byte by = (byte)(c5 & 0x3F);
            byte by2 = (byte)((c4 & 3) << 4 | c5 >> 6 & 0xF);
            byte by3 = (byte)(c4 >> 2 & 0xF);
            byte by4 = (byte)((c4 >> 6 & 0xF) + 1);
            byArray[0] = (byte)(0xF0 | by4 >> 2 & 7);
            byArray[1] = (byte)(0x80 | (by4 & 3) << 4 | by3);
            byArray[2] = (byte)(0x80 | by2);
            byArray[3] = (byte)(0x80 | by);
            return 4;
        }
        if (c4 >= '\udc00' && c4 <= '\udfff') {
            return 0;
        }
        byArray[0] = (byte)(0xE0 | c2 >> 12 & 0xF);
        byArray[1] = (byte)(0x80 | c2 >> 6 & 0x3F);
        byArray[2] = (byte)(0x80 | c2 & 0x3F);
        return 3;
    }
}

