/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Reader;
import java.util.Date;
import java.util.Properties;
import javax.xml.transform.Source;
import javax.xml.transform.TransformerFactoryConfigurationError;
import javax.xml.transform.sax.SAXSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import net.sf.saxon.CollectionURIResolver;
import net.sf.saxon.Configuration;
import net.sf.saxon.JavaPlatform;
import net.sf.saxon.Transform;
import net.sf.saxon.instruct.TerminationException;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.query.DynamicQueryContext;
import net.sf.saxon.query.QueryReader;
import net.sf.saxon.query.QueryResult;
import net.sf.saxon.query.StaticQueryContext;
import net.sf.saxon.query.XQueryExpression;
import net.sf.saxon.trace.TraceListener;
import net.sf.saxon.trace.XQueryTraceListener;
import net.sf.saxon.trans.DynamicError;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.value.UntypedAtomicValue;
import org.xml.sax.InputSource;

public class Query {
    protected Configuration config;

    protected Configuration makeConfiguration(boolean bl) {
        if (bl) {
            this.config = Configuration.makeSchemaAwareConfiguration(null);
        } else {
            this.config = new Configuration();
            this.config.setAllNodesUntyped(true);
        }
        return this.config;
    }

    protected Configuration getConfiguration() {
        return this.config;
    }

    public static void main(String[] stringArray) throws Exception {
        new Query().doQuery(stringArray, "java net.sf.saxon.Query");
    }

    protected void doQuery(String[] stringArray, String string) {
        boolean bl = false;
        int n2 = 1;
        String string2 = null;
        String string3 = null;
        boolean bl2 = false;
        String string4 = null;
        boolean bl3 = false;
        boolean bl4 = false;
        boolean bl5 = false;
        boolean bl6 = false;
        for (int i2 = 0; i2 < stringArray.length; ++i2) {
            if (stringArray[i2].equals("-sa")) {
                bl6 = true;
                continue;
            }
            if (stringArray[i2].equals("-val")) {
                bl6 = true;
                continue;
            }
            if (stringArray[i2].equals("-vlax")) {
                bl6 = true;
                continue;
            }
            if (!stringArray[i2].equals("-p")) continue;
            bl6 = true;
        }
        this.config = this.makeConfiguration(bl6);
        this.config.setHostLanguage(51);
        StaticQueryContext staticQueryContext = new StaticQueryContext(this.config);
        DynamicQueryContext dynamicQueryContext = new DynamicQueryContext(this.config);
        Properties properties = new Properties();
        try {
            OutputStream outputStream;
            Object object;
            Object object2;
            Object object3;
            Object object4;
            Object object5;
            int n3 = 0;
            while (n3 < stringArray.length && stringArray[n3].charAt(0) == '-') {
                Object object6;
                if (stringArray[n3].equals("-cr")) {
                    if (stringArray.length < ++n3 + 1) {
                        this.badUsage(string, "No output file name");
                    }
                    if (!((object5 = this.config.getInstance((String)(object6 = stringArray[n3++]), null)) instanceof CollectionURIResolver)) {
                        Query.quit((String)object6 + " is not a CollectionURIResolver", 2);
                    }
                    this.config.setCollectionURIResolver((CollectionURIResolver)object5);
                    continue;
                }
                if (stringArray[n3].equals("-ds")) {
                    this.config.setTreeModel(0);
                    ++n3;
                    continue;
                }
                if (stringArray[n3].equals("-dt")) {
                    this.config.setTreeModel(1);
                    ++n3;
                    continue;
                }
                if (stringArray[n3].equals("-e")) {
                    bl3 = true;
                    ++n3;
                    continue;
                }
                if (stringArray[n3].equals("-l")) {
                    this.config.setLineNumbering(true);
                    ++n3;
                    continue;
                }
                if (stringArray[n3].equals("-3")) {
                    ++n3;
                    n2 = 3;
                    continue;
                }
                if (stringArray[n3].equals("-9")) {
                    ++n3;
                    n2 = 9;
                    continue;
                }
                if (stringArray[n3].equals("-mr")) {
                    if (stringArray.length < ++n3 + 1) {
                        this.badUsage(string, "No ModuleURIResolver class");
                    }
                    object6 = stringArray[n3++];
                    this.config.setModuleURIResolver((String)object6);
                    continue;
                }
                if (stringArray[n3].equals("-noext")) {
                    ++n3;
                    this.config.setAllowExternalFunctions(false);
                    continue;
                }
                if (stringArray[n3].equals("-o")) {
                    if (stringArray.length < ++n3 + 1) {
                        this.badUsage(string, "No output file name");
                    }
                    string4 = stringArray[n3++];
                    continue;
                }
                if (stringArray[n3].equals("-p")) {
                    ++n3;
                    this.setPOption(this.config);
                    bl2 = true;
                    continue;
                }
                if (stringArray[n3].equals("-pull")) {
                    ++n3;
                    bl5 = true;
                    continue;
                }
                if (stringArray[n3].equals("-r")) {
                    if (stringArray.length < ++n3 + 1) {
                        this.badUsage(string, "No URIResolver class");
                    }
                    object6 = stringArray[n3++];
                    this.config.setURIResolver(this.config.makeURIResolver((String)object6));
                    dynamicQueryContext.setURIResolver(this.config.makeURIResolver((String)object6));
                    continue;
                }
                if (stringArray[n3].equals("-s")) {
                    if (stringArray.length < ++n3 + 1) {
                        this.badUsage(string, "No source file name");
                    }
                    string2 = stringArray[n3++];
                    continue;
                }
                if (stringArray[n3].equals("-sa")) {
                    ++n3;
                    continue;
                }
                if (stringArray[n3].equals("-snone")) {
                    this.config.setStripsWhiteSpace(10);
                    ++n3;
                    continue;
                }
                if (stringArray[n3].equals("-sall")) {
                    this.config.setStripsWhiteSpace(12);
                    ++n3;
                    continue;
                }
                if (stringArray[n3].equals("-signorable")) {
                    this.config.setStripsWhiteSpace(11);
                    ++n3;
                    continue;
                }
                if (stringArray[n3].equals("-strip")) {
                    this.config.setStripsWhiteSpace(12);
                    ++n3;
                    continue;
                }
                if (stringArray[n3].equals("-t")) {
                    System.err.println(this.config.getProductTitle());
                    System.err.println(this.config.getPlatform().getPlatformVersion());
                    this.config.setTiming(true);
                    bl = true;
                    ++n3;
                    continue;
                }
                if (stringArray[n3].equals("-T")) {
                    this.config.setTraceListener(new XQueryTraceListener());
                    ++n3;
                    continue;
                }
                if (stringArray[n3].equals("-TJ")) {
                    ++n3;
                    this.config.setTraceExternalFunctions(true);
                    continue;
                }
                if (stringArray[n3].equals("-TL")) {
                    if (stringArray.length < n3 + 2) {
                        this.badUsage(string, "No TraceListener class specified");
                    }
                    object6 = this.config.makeTraceListener(stringArray[++n3]);
                    this.config.setTraceListener((TraceListener)object6);
                    this.config.setLineNumbering(true);
                    ++n3;
                    continue;
                }
                if (stringArray[n3].equals("-u")) {
                    bl2 = true;
                    ++n3;
                    continue;
                }
                if (stringArray[n3].equals("-untyped")) {
                    this.config.setAllNodesUntyped(true);
                    ++n3;
                    continue;
                }
                if (stringArray[n3].equals("-v")) {
                    this.config.setValidation(true);
                    ++n3;
                    continue;
                }
                if (stringArray[n3].equals("-val")) {
                    if (bl6) {
                        this.config.setSchemaValidationMode(1);
                    } else {
                        Query.quit("The -val option requires a schema-aware processor", 2);
                    }
                    ++n3;
                    continue;
                }
                if (stringArray[n3].equals("-vlax")) {
                    if (bl6) {
                        this.config.setSchemaValidationMode(2);
                    } else {
                        Query.quit("The -vlax option requires a schema-aware processor", 2);
                    }
                    ++n3;
                    continue;
                }
                if (stringArray[n3].equals("-vw")) {
                    if (bl6) {
                        this.config.setValidationWarnings(true);
                    } else {
                        Query.quit("The -vw option requires a schema-aware processor", 2);
                    }
                    ++n3;
                    continue;
                }
                if (stringArray[n3].equals("-wrap")) {
                    bl4 = true;
                    ++n3;
                    continue;
                }
                if (stringArray[n3].equals("-1.1")) {
                    this.config.setXMLVersion(11);
                    ++n3;
                    continue;
                }
                if (stringArray[n3].equals("-?")) {
                    this.badUsage(string, "");
                    continue;
                }
                if (stringArray[n3].equals("-")) {
                    string3 = "-";
                    ++n3;
                    continue;
                }
                this.badUsage(string, "Unknown option " + stringArray[n3]);
            }
            if (!"-".equals(string3)) {
                if (stringArray.length < n3 + 1) {
                    this.badUsage(string, "No query file name");
                }
                string3 = stringArray[n3++];
            }
            for (int i3 = n3; i3 < stringArray.length; ++i3) {
                object5 = stringArray[i3];
                int n4 = ((String)object5).indexOf("=");
                if (n4 < 1 || n4 >= ((String)object5).length() - 1) {
                    this.badUsage(string, "Bad param=value pair on command line: " + (String)object5);
                }
                if (((String)(object4 = ((String)object5).substring(0, n4))).startsWith("!")) {
                    properties.setProperty(((String)object4).substring(1), ((String)object5).substring(n4 + 1));
                    continue;
                }
                if (((String)object4).startsWith("+")) {
                    object3 = Transform.loadDocuments(((String)object5).substring(n4 + 1), bl2, this.config, true);
                    dynamicQueryContext.setParameter(((String)object4).substring(1), object3);
                    continue;
                }
                dynamicQueryContext.setParameter((String)object4, new UntypedAtomicValue(((String)object5).substring(n4 + 1)));
            }
            this.config.displayLicenseMessage();
            if (bl5) {
                this.config.setLazyConstructionMode(true);
            }
            Source source = null;
            if (string2 != null) {
                if (bl2 || string2.startsWith("http:") || string2.startsWith("file:")) {
                    source = this.config.getURIResolver().resolve(string2, null);
                    if (source == null) {
                        source = this.config.getSystemURIResolver().resolve(string2, null);
                    }
                } else if (string2.equals("-")) {
                    source = new StreamSource(System.in);
                } else {
                    File file = new File(string2);
                    if (!file.exists()) {
                        Query.quit("Source file " + file + " does not exist", 2);
                    }
                    if (this.config.getPlatform() instanceof JavaPlatform) {
                        object5 = new InputSource(file.toURI().toString());
                        source = new SAXSource((InputSource)object5);
                    } else {
                        source = new StreamSource(file.toURI().toString());
                    }
                }
            }
            long l2 = new Date().getTime();
            if (bl) {
                System.err.println("Compiling query from " + string3);
            }
            try {
                if (string3.equals("-")) {
                    object3 = new InputStreamReader(System.in);
                    object4 = staticQueryContext.compileQuery((Reader)object3);
                } else if (string3.startsWith("{") && string3.endsWith("}")) {
                    object3 = string3.substring(1, string3.length() - 1);
                    object4 = staticQueryContext.compileQuery((String)object3);
                } else if (bl2 || string3.startsWith("http:") || string3.startsWith("file:")) {
                    String[] stringArray2;
                    object3 = this.config.getModuleURIResolver();
                    object2 = object3.resolve(null, null, stringArray2 = new String[]{string3});
                    if (((StreamSource[])object2).length != 1 || !(object2[0] instanceof StreamSource)) {
                        Query.quit("Module URI Resolver must return a single StreamSource", 2);
                    }
                    object = QueryReader.readSourceQuery(object2[0], this.config.getNameChecker());
                    object4 = staticQueryContext.compileQuery((String)object);
                } else {
                    object3 = new FileInputStream(string3);
                    staticQueryContext.setBaseURI(new File(string3).toURI().toString());
                    object4 = staticQueryContext.compileQuery((InputStream)object3, null);
                }
                staticQueryContext = ((XQueryExpression)object4).getStaticContext();
                if (bl) {
                    long l3 = new Date().getTime();
                    System.err.println("Compilation time: " + (l3 - l2) + " milliseconds");
                    l2 = l3;
                }
            }
            catch (XPathException xPathException) {
                int n5 = -1;
                object2 = null;
                if (xPathException.getLocator() != null) {
                    n5 = xPathException.getLocator().getLineNumber();
                    object2 = xPathException.getLocator().getSystemId();
                }
                if (xPathException.hasBeenReported()) {
                    Query.quit("Failed to compile query", 2);
                } else if (n5 == -1) {
                    System.err.println("Failed to compile query: " + xPathException.getMessage());
                } else {
                    System.err.println("Static error at line " + n5 + " of " + (String)object2 + ':');
                    System.err.println(xPathException.getMessage());
                }
                object4 = null;
                System.exit(2);
            }
            if (bl3) {
                staticQueryContext.explainGlobalVariables();
                staticQueryContext.explainGlobalFunctions();
                ((XQueryExpression)object4).explain(staticQueryContext.getConfiguration());
            }
            if (string4 != null) {
                File file = new File(string4);
                if (file.isDirectory()) {
                    Query.quit("Output is a directory", 2);
                }
                outputStream = new FileOutputStream(file);
            } else {
                outputStream = System.out;
            }
            for (int i4 = 0; i4 < n2; ++i4) {
                block104: {
                    if (source != null) {
                        if (bl) {
                            System.err.println("Processing " + source.getSystemId());
                        }
                        object2 = staticQueryContext.buildDocument(source);
                        dynamicQueryContext.setContextItem((Item)object2);
                    }
                    try {
                        if (bl4) {
                            object2 = ((XQueryExpression)object4).iterator(dynamicQueryContext);
                            object = QueryResult.wrap((SequenceIterator)object2, this.config);
                            QueryResult.serialize((NodeInfo)object, new StreamResult(outputStream), properties, this.config);
                            outputStream.close();
                            break block104;
                        }
                        if (bl5) {
                            if (bl4) {
                                properties.setProperty("{http://saxon.sf.net/}wrap-result-sequence", "yes");
                            }
                            try {
                                ((XQueryExpression)object4).pull(dynamicQueryContext, new StreamResult(outputStream), properties);
                                break block104;
                            }
                            catch (XPathException xPathException) {
                                this.config.reportFatalError(xPathException);
                                throw xPathException;
                            }
                        }
                        ((XQueryExpression)object4).run(dynamicQueryContext, new StreamResult(outputStream), properties);
                    }
                    catch (TerminationException terminationException) {
                        throw terminationException;
                    }
                    catch (XPathException xPathException) {
                        if (xPathException.hasBeenReported()) {
                            throw new DynamicError("Run-time errors were reported");
                        }
                        throw xPathException;
                    }
                }
                if (!bl) continue;
                long l4 = new Date().getTime();
                System.err.println("Execution time: " + (l4 - l2) + " milliseconds");
                l2 = l4;
            }
        }
        catch (TerminationException terminationException) {
            Query.quit(terminationException.getMessage(), 1);
        }
        catch (XPathException xPathException) {
            Query.quit("Query processing failed: " + xPathException.getMessage(), 2);
        }
        catch (TransformerFactoryConfigurationError transformerFactoryConfigurationError) {
            transformerFactoryConfigurationError.printStackTrace();
            Query.quit("Query processing failed", 2);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            Query.quit("Fatal error during transformation: " + exception.getMessage(), 2);
        }
    }

    protected static void quit(String string, int n2) {
        System.err.println(string);
        System.exit(n2);
    }

    public void setPOption(Configuration configuration) {
        configuration.getSystemURIResolver().setRecognizeQueryParameters(true);
    }

    protected void badUsage(String string, String string2) {
        if (!"".equals(string2)) {
            System.err.println(string2);
        }
        System.err.println(this.config.getProductTitle());
        System.err.println("Usage: " + string + " [options] query {param=value}...");
        System.err.println("Options: ");
        System.err.println("  -cr classname   Use specified CollectionURIResolver class");
        System.err.println("  -ds             Use linked tree data structure");
        System.err.println("  -dt             Use tiny tree data structure (default)");
        System.err.println("  -e              Explain optimized query expression");
        System.err.println("  -mr classname   Use specified ModuleURIResolver class");
        System.err.println("  -noext          Disallow calls to Java methods");
        System.err.println("  -o filename     Send output to named file");
        System.err.println("  -p              Recognize Saxon file extensions and query parameters");
        System.err.println("  -pull           Run query in pull mode");
        System.err.println("  -r classname    Use specified URIResolver class");
        System.err.println("  -s file|URI     Provide initial context document");
        System.err.println("  -sa             Schema-aware query (requires Saxon-SA)");
        System.err.println("  -sall           Strip all whitespace text nodes");
        System.err.println("  -signorable     Strip ignorable whitespace text nodes (default)");
        System.err.println("  -snone          Strip no whitespace text nodes");
        System.err.println("  -t              Display version and timing information");
        System.err.println("  -T              Trace query execution");
        System.err.println("  -TJ             Trace calls to external Java functions");
        System.err.println("  -TL classname   Trace query execution to user-defined trace listener");
        System.err.println("  -u              Names are URLs not filenames");
        System.err.println("  -v              Validate source documents using DTD");
        System.err.println("  -val            Validate source documents using schema");
        System.err.println("  -vlax           Lax validation of source documents using schema");
        System.err.println("  -vw             Treat validation errors on result document as warnings");
        System.err.println("  -wrap           Wrap result sequence in XML elements");
        System.err.println("  -1.1            Allow XML 1.1 documents");
        System.err.println("  -?              Display this message ");
        System.err.println("  param=value     Set query string parameter");
        System.err.println("  +param=value    Set query document parameter");
        System.err.println("  !option=value   Set serialization option");
        if ("".equals(string2)) {
            System.exit(0);
        } else {
            System.exit(2);
        }
    }
}

