/*
 * Decompiled with CFR 0.152.
 */
package jdiff.util;

import java.io.IOException;
import jdiff.util.Diff;
import jdiff.util.DiffOutput;

public class DiffNormalOutput
extends DiffOutput {
    public DiffNormalOutput(Object[] a2, Object[] b2) {
        super(a2, b2);
    }

    public void writeScript(Diff.change script) throws IOException {
        Diff.change hunk = script;
        while (hunk != null) {
            this.writeHunk(hunk);
            hunk = hunk.link;
        }
        this.out.flush();
    }

    protected void writeHunk(Diff.change hunk) throws IOException {
        int i2;
        int deletes = hunk.deleted;
        int inserts = hunk.inserted;
        if (deletes == 0 && inserts == 0) {
            return;
        }
        int first0 = hunk.line0;
        int first1 = hunk.line1;
        int last0 = hunk.line0 + hunk.deleted - 1;
        int last1 = hunk.line1 + hunk.inserted - 1;
        this.writeNumberRange(',', first0, last0);
        this.out.write(DiffOutput.changeLetter(inserts, deletes));
        this.writeNumberRange(',', first1, last1);
        this.out.write(this.lineSeparator);
        if (deletes != 0) {
            i2 = first0;
            while (i2 <= last0) {
                this.writeLine("< ", this.file0[i2]);
                ++i2;
            }
        }
        if (inserts != 0 && deletes != 0) {
            this.out.write("---" + this.lineSeparator);
        }
        if (inserts != 0) {
            i2 = first1;
            while (i2 <= last1) {
                this.writeLine("> ", this.file1[i2]);
                ++i2;
            }
        }
    }
}

