/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.vdb.internal.edit.materialization;

import com.metamatrix.core.MetaMatrixRuntimeException;
import com.metamatrix.vdb.edit.materialization.DatabaseDialect;
import com.metamatrix.vdb.internal.edit.materialization.MaterializedViewScriptGenerator;
import com.metamatrix.vdb.internal.edit.materialization.template.engine.ExpandedTemplate;
import com.metamatrix.vdb.internal.edit.materialization.template.engine.TemplateData;
import com.metamatrix.vdb.internal.edit.materialization.template.engine.TemplateExpander;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;

public class MaterializedViewScriptGeneratorImpl
implements MaterializedViewScriptGenerator {
    private static final String TEMPLATE_PATH = "com/metamatrix/vdb/internal/edit/materialization/template/";
    private static final String PARENT_TEMPLATE = "scriptMaterializedView";
    private static final String PLATFORM_SPECIALIZED_TEMPLATE = "loadMaterializedView_";
    private static final String TEMPLATE_EXT = ".stg";
    private TemplateData templateData;
    static /* synthetic */ Class class$com$metamatrix$vdb$internal$edit$materialization$MaterializedViewScriptGeneratorImpl;

    public MaterializedViewScriptGeneratorImpl(TemplateData materializedViewTemplateData) {
        this.templateData = materializedViewTemplateData;
    }

    public void generateMaterializationTruncateScript(OutputStream stream, DatabaseDialect dialect) throws IOException {
        this.generateTemplate("truncate", this.templateData, dialect, stream);
    }

    public void generateMaterializationLoadScript(OutputStream stream) throws IOException {
        this.generateTemplate("load", this.templateData, DatabaseDialect.METAMATRIX, stream);
    }

    public void generateMaterializationSwapScript(OutputStream stream, DatabaseDialect dialect) throws IOException {
        this.generateTemplate("swap", this.templateData, dialect, stream);
    }

    public void generateMaterializationConnectionPropFile(OutputStream stream) throws IOException {
        this.generateTemplate("connectionProps", this.templateData, DatabaseDialect.CONNECTION_PROPS, stream);
    }

    private void generateTemplate(String command, TemplateData data, DatabaseDialect database, OutputStream stream) throws IOException {
        String name = database.getType() + "_" + command;
        TemplateExpander expander = new TemplateExpander(data, database);
        Reader[] templateReaders = this.getTemplateReaders(command, database);
        ExpandedTemplate template = expander.expand(name, templateReaders, command);
        this.closeReaders(templateReaders);
        this.toStream(template, stream);
    }

    private Reader[] getTemplateReaders(String command, DatabaseDialect database) throws IOException {
        InputStreamReader parent = this.getReader(PARENT_TEMPLATE);
        InputStreamReader child = this.getReader(PLATFORM_SPECIALIZED_TEMPLATE + database);
        return new Reader[]{parent, child};
    }

    private void closeReaders(Reader[] readers) throws IOException {
        for (int i2 = 0; i2 < readers.length; ++i2) {
            readers[i2].close();
        }
    }

    private InputStreamReader getReader(String fileName) throws IOException {
        String templateName = TEMPLATE_PATH + fileName + TEMPLATE_EXT;
        InputStream inputStream = (class$com$metamatrix$vdb$internal$edit$materialization$MaterializedViewScriptGeneratorImpl == null ? (class$com$metamatrix$vdb$internal$edit$materialization$MaterializedViewScriptGeneratorImpl = MaterializedViewScriptGeneratorImpl.class$("com.metamatrix.vdb.internal.edit.materialization.MaterializedViewScriptGeneratorImpl")) : class$com$metamatrix$vdb$internal$edit$materialization$MaterializedViewScriptGeneratorImpl).getClassLoader().getResourceAsStream(templateName);
        if (inputStream == null) {
            throw new MetaMatrixRuntimeException("Unable to find resource: " + templateName);
        }
        return new InputStreamReader(inputStream);
    }

    private void toStream(ExpandedTemplate template, OutputStream stream) throws IOException {
        OutputStreamWriter writer = new OutputStreamWriter(stream);
        writer.write(template.contents, 0, template.contents.length());
        writer.flush();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

