/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.vdb.internal.edit;

import com.metamatrix.core.util.ArgCheck;
import com.metamatrix.core.util.EnhancedStringTokenizer;
import com.metamatrix.core.util.StringUtil;
import com.metamatrix.core.util.UriUtil;
import com.metamatrix.metamodels.xmlservice.XmlInput;
import com.metamatrix.metamodels.xmlservice.XmlOperation;
import com.metamatrix.metamodels.xmlservice.util.ReferencedXSDSchemaFinder;
import com.metamatrix.modeler.core.ModelerCoreException;
import com.metamatrix.modeler.core.util.ModelVisitor;
import com.metamatrix.modeler.core.util.ModelVisitorProcessor;
import com.metamatrix.modeler.core.workspace.ModelWorkspaceException;
import com.metamatrix.modeler.internal.core.resource.EmfResource;
import com.metamatrix.modeler.webservice.IWsdlGenerator;
import com.metamatrix.modeler.webservice.WebServicePlugin;
import com.metamatrix.vdb.edit.VdbEditException;
import com.metamatrix.vdb.edit.VdbEditPlugin;
import com.metamatrix.vdb.edit.VdbWsdlGenerationOptions;
import com.metamatrix.vdb.edit.manifest.WsdlOptions;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.xerces.util.URI;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.xsd.XSDSchema;
import org.eclipse.xsd.XSDSimpleTypeDefinition;

public class WsdlGenerationOptionsHelper
implements VdbWsdlGenerationOptions {
    private static final String XML_LITERAL_TYPE_URI_STRING = org.eclipse.emf.common.util.URI.createURI("http://www.metamatrix.com/metamodels/SimpleDatatypes-instance").appendFragment("XMLLiteral").toString();
    private final List eResources;
    private final WsdlOptions wsdlOptions;
    private final Map eResourceToPath;

    public WsdlGenerationOptionsHelper(List eResources, WsdlOptions wsdlOptions, Map eResourceToPath) {
        ArgCheck.isNotNull(eResources);
        ArgCheck.isNotNull(wsdlOptions);
        ArgCheck.isNotNull(eResourceToPath);
        this.eResources = eResources;
        this.wsdlOptions = wsdlOptions;
        this.eResourceToPath = eResourceToPath;
    }

    public List getWebServiceModelReferences() {
        throw new UnsupportedOperationException();
    }

    public void setDefaultNamespaceUri(String namespaceUri) {
        if (namespaceUri != null && namespaceUri.trim().length() != 0) {
            try {
                new URI(namespaceUri);
            }
            catch (URI.MalformedURIException err) {
                throw new IllegalArgumentException(err.getLocalizedMessage());
            }
        }
        if (this.wsdlOptions != null) {
            this.wsdlOptions.setDefaultNamespaceUri(namespaceUri);
        }
    }

    public void setTargetNamespaceUri(String namespaceUri) {
        if (this.wsdlOptions != null) {
            this.wsdlOptions.setTargetNamespaceUri(namespaceUri);
        }
        if ("".equals(this.getDefaultNamespaceUri())) {
            this.setDefaultNamespaceUri(namespaceUri);
        }
        if (namespaceUri != null && namespaceUri.trim().length() != 0) {
            try {
                new URI(namespaceUri);
            }
            catch (URI.MalformedURIException err) {
                throw new IllegalArgumentException(err.getLocalizedMessage());
            }
        }
    }

    public boolean isValidUri(String str) {
        try {
            new URI(str);
        }
        catch (URI.MalformedURIException e2) {
            return false;
        }
        return true;
    }

    public boolean canWsdlBeGenerated() {
        Iterator i2 = this.eResources.iterator();
        while (i2.hasNext()) {
            Resource r2 = (Resource)i2.next();
            if (!(r2 instanceof EmfResource)) continue;
            if (((EmfResource)r2).getPrimaryMetamodelUri() == null) {
                return false;
            }
            String primaryMetamodelUri = ((EmfResource)r2).getPrimaryMetamodelUri().toString();
            if ("http://www.metamatrix.com/metamodels/WebService".equals(primaryMetamodelUri)) {
                return true;
            }
            if (!"http://www.metamatrix.com/metamodels/XmlService".equals(primaryMetamodelUri) || !this.exposeXmlServiceInWsdl(r2)) continue;
            return true;
        }
        return false;
    }

    public String getTargetNamespaceUri() {
        String result = null;
        if (this.wsdlOptions != null) {
            result = this.wsdlOptions.getTargetNamespaceUri();
        }
        if (result == null) {
            result = "";
        }
        return result;
    }

    public String[] getAllNamespaceUris() throws ModelWorkspaceException {
        List xsResources = this.getXmlServiceResources();
        List wsResources = this.getWebServiceResources();
        if (xsResources.isEmpty() && wsResources.isEmpty()) {
            return new String[0];
        }
        com.metamatrix.metamodels.webservice.util.ReferencedXSDSchemaFinder wsVisitor = new com.metamatrix.metamodels.webservice.util.ReferencedXSDSchemaFinder();
        this.executeModelVisitor(wsResources, (ModelVisitor)wsVisitor);
        ReferencedXSDSchemaFinder xsVisitor = new ReferencedXSDSchemaFinder();
        this.executeModelVisitor(xsResources, (ModelVisitor)xsVisitor);
        HashSet<String> uniqueNamespaceUris = new HashSet<String>();
        uniqueNamespaceUris.addAll(wsVisitor.getXsdTargetNamespaces());
        uniqueNamespaceUris.addAll(xsVisitor.getXsdTargetNamespaces());
        String tns = this.getTargetNamespaceUri();
        if (tns != null && tns.trim().length() != 0) {
            uniqueNamespaceUris.add(this.getTargetNamespaceUri());
        }
        uniqueNamespaceUris.add("http://schemas.xmlsoap.org/wsdl/");
        HashSet schemas = new HashSet();
        schemas.addAll(wsVisitor.getXsdSchemas());
        schemas.addAll(xsVisitor.getXsdSchemas());
        Iterator i2 = schemas.iterator();
        while (i2.hasNext()) {
            XSDSchema schema = (XSDSchema)i2.next();
            String sosNamespace = schema.getSchemaForSchemaNamespace();
            uniqueNamespaceUris.add(sosNamespace);
        }
        ArrayList namespaceUris = new ArrayList(uniqueNamespaceUris);
        Collections.sort(namespaceUris, StringUtil.CASE_SENSITIVE_ORDER);
        return namespaceUris.toArray(new String[namespaceUris.size()]);
    }

    public String getDefaultNamespaceUri() {
        String result = null;
        if (this.wsdlOptions != null) {
            result = this.wsdlOptions.getDefaultNamespaceUri();
        }
        if (result == null) {
            result = "";
        }
        return result;
    }

    public InputStream getWsdl(IProgressMonitor monitor) throws IOException, VdbEditException {
        String result = this.getWsdlAsString(monitor);
        return new ByteArrayInputStream(result.getBytes());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getWsdlAsString(IProgressMonitor monitor) throws IOException, VdbEditException {
        ByteArrayOutputStream bas = new ByteArrayOutputStream();
        BufferedOutputStream stream = new BufferedOutputStream(bas);
        IStatus status = null;
        try {
            status = this.generateWsdl(monitor, stream);
        }
        finally {
            if (stream != null) {
                stream.close();
            }
        }
        if (status.getSeverity() == 4) {
            throw new VdbEditException(status);
        }
        return bas.toString();
    }

    public List getXmlServiceResources() {
        ArrayList<Resource> results = new ArrayList<Resource>();
        Iterator i2 = this.eResources.iterator();
        while (i2.hasNext()) {
            String primaryMetamodelUri;
            Resource r2 = (Resource)i2.next();
            if (!(r2 instanceof EmfResource) || ((EmfResource)r2).getPrimaryMetamodelUri() == null || !"http://www.metamatrix.com/metamodels/XmlService".equals(primaryMetamodelUri = ((EmfResource)r2).getPrimaryMetamodelUri().toString()) || !this.exposeXmlServiceInWsdl(r2)) continue;
            results.add(r2);
        }
        return results;
    }

    public List getWebServiceResources() {
        ArrayList<Resource> results = new ArrayList<Resource>();
        Iterator i2 = this.eResources.iterator();
        while (i2.hasNext()) {
            String primaryMetamodelUri;
            Resource r2 = (Resource)i2.next();
            if (!(r2 instanceof EmfResource) || ((EmfResource)r2).getPrimaryMetamodelUri() == null || !"http://www.metamatrix.com/metamodels/WebService".equals(primaryMetamodelUri = ((EmfResource)r2).getPrimaryMetamodelUri().toString())) continue;
            results.add(r2);
        }
        return results;
    }

    public Collection getReferencedXsds() throws ModelWorkspaceException {
        List xsResources = this.getXmlServiceResources();
        List wsResources = this.getWebServiceResources();
        if (xsResources.isEmpty() && wsResources.isEmpty()) {
            return Collections.EMPTY_LIST;
        }
        com.metamatrix.metamodels.webservice.util.ReferencedXSDSchemaFinder wsVisitor = new com.metamatrix.metamodels.webservice.util.ReferencedXSDSchemaFinder();
        this.executeModelVisitor(wsResources, (ModelVisitor)wsVisitor);
        ReferencedXSDSchemaFinder xsVisitor = new ReferencedXSDSchemaFinder();
        this.executeModelVisitor(xsResources, (ModelVisitor)xsVisitor);
        HashSet schemas = new HashSet();
        schemas.addAll(wsVisitor.getXsdSchemas());
        schemas.addAll(xsVisitor.getXsdSchemas());
        return schemas;
    }

    public IStatus generateWsdl(IProgressMonitor monitor, OutputStream stream) {
        String msg;
        ArrayList<IStatus> problems = new ArrayList<IStatus>();
        if (this.canWsdlBeGenerated()) {
            IWsdlGenerator wsdlGenerator = WebServicePlugin.createWsdlGenerator();
            wsdlGenerator.setName("MetaMatrixDataServices");
            wsdlGenerator.setTargetNamespace(this.getTargetNamespaceUri());
            wsdlGenerator.setDefaultNamespaceUri(this.getDefaultNamespaceUri());
            wsdlGenerator.setUrlRootForReferences("http://vdb.metamatrix.com");
            wsdlGenerator.setUrlSuffixForReferences("?vdbToken=true");
            wsdlGenerator.setUrlForWsdlService("http://vdb.dataservice.metamatrix.com");
            wsdlGenerator.setXmlEncoding("UTF-8");
            ArrayList eResources = new ArrayList();
            eResources.addAll(this.getWebServiceResources());
            eResources.addAll(this.getXmlServiceResources());
            Iterator i2 = eResources.iterator();
            while (i2.hasNext()) {
                Resource wsResource = (Resource)i2.next();
                if (wsResource == null) continue;
                wsdlGenerator.addWebServiceModel(wsResource);
            }
            try {
                Collection xsdSchemas = this.getReferencedXsds();
                Iterator i3 = xsdSchemas.iterator();
                while (i3.hasNext()) {
                    Resource eResource;
                    XSDSchema schema = (XSDSchema)i3.next();
                    if (schema == null || (eResource = schema.eResource()) == null) continue;
                    IPath pathToSchema = (IPath)this.eResourceToPath.get(eResource);
                    if (pathToSchema != null) {
                        IPath pathWithEncoding = this.encodePathForUseInUri(pathToSchema);
                        wsdlGenerator.addXsdModel(schema, pathWithEncoding);
                        continue;
                    }
                    wsdlGenerator.addXsdModel(schema, null);
                }
            }
            catch (ModelWorkspaceException e2) {
                String msg2 = VdbEditPlugin.Util.getString("VdbWsdlGenerationOptionsImpl.ErrorAccessingXSDs");
                problems.add(new Status(4, "com.metamatrix.vdb.edit", 0, msg2, e2));
            }
            IStatus status = wsdlGenerator.generate(monitor);
            if (status.getSeverity() != 4) {
                try {
                    wsdlGenerator.write(stream);
                }
                catch (IOException e3) {
                    String msg3 = VdbEditPlugin.Util.getString("VdbWsdlGenerationOptionsImpl.ProblemsGeneratingWsdl");
                    problems.add(new Status(4, "com.metamatrix.vdb.edit", 0, msg3, e3));
                }
            } else if (status instanceof MultiStatus) {
                IStatus[] children = ((MultiStatus)status).getChildren();
                for (int i4 = 0; i4 < children.length; ++i4) {
                    if (children[i4] == null) continue;
                    problems.add(children[i4]);
                }
            } else {
                problems.add(status);
            }
        }
        if (problems.size() == 1) {
            return (IStatus)problems.get(0);
        }
        if (problems.size() == 0) {
            msg = VdbEditPlugin.Util.getString("VdbWsdlGenerationOptionsImpl.SuccessfullyGeneratedWsdl");
            return new Status(0, "com.metamatrix.vdb.edit", 0, msg, null);
        }
        msg = VdbEditPlugin.Util.getString("VdbWsdlGenerationOptionsImpl.ProblemsGeneratingWsdl");
        IStatus[] problemArray = problems.toArray(new IStatus[problems.size()]);
        return new MultiStatus("com.metamatrix.vdb.edit", 0, problemArray, msg, null);
    }

    protected boolean exposeXmlServiceInWsdl(Resource r2) {
        if (r2 instanceof EmfResource) {
            if (((EmfResource)r2).getPrimaryMetamodelUri() == null) {
                return false;
            }
            String primaryMetamodelUri = ((EmfResource)r2).getPrimaryMetamodelUri().toString();
            if ("http://www.metamatrix.com/metamodels/XmlService".equals(primaryMetamodelUri)) {
                if (!r2.isLoaded()) {
                    Map loadOptions = r2.getResourceSet() != null ? r2.getResourceSet().getLoadOptions() : Collections.EMPTY_MAP;
                    try {
                        r2.load(loadOptions);
                    }
                    catch (Throwable e2) {
                        VdbEditPlugin.Util.log(e2);
                    }
                }
                Iterator i2 = r2.getContents().iterator();
                while (i2.hasNext()) {
                    XmlInput input;
                    XmlOperation op;
                    EObject eObj = (EObject)i2.next();
                    if (!(eObj instanceof XmlOperation) || (op = (XmlOperation)eObj).getInputs().size() != 1 || (input = (XmlInput)op.getInputs().get(0)) == null || input.getType() == null) continue;
                    XSDSimpleTypeDefinition type = (XSDSimpleTypeDefinition)input.getType();
                    if (type.eIsProxy() && XML_LITERAL_TYPE_URI_STRING.equals(((InternalEObject)((Object)type)).eProxyURI().toString())) {
                        return true;
                    }
                    if (!XML_LITERAL_TYPE_URI_STRING.equals(type.getURI())) continue;
                    return true;
                }
            }
        }
        return false;
    }

    protected IPath encodePathForUseInUri(IPath pathToResourceInVdb) {
        String[] pathSegments = pathToResourceInVdb.segments();
        IPath pathWithEncoding = Path.ROOT;
        for (int i2 = 0; i2 < pathSegments.length; ++i2) {
            String segment = pathSegments[i2];
            StringBuffer encodedSegment = new StringBuffer();
            String tokenDelimSet = ".?_";
            EnhancedStringTokenizer segmentTokens = new EnhancedStringTokenizer(segment, ".?_");
            while (segmentTokens.hasMoreTokens()) {
                String token = segmentTokens.nextToken();
                String delims = segmentTokens.nextDelimiters();
                String encodedSegmentToken = UriUtil.escape(token);
                encodedSegment.append(encodedSegmentToken);
                if (delims == null) continue;
                encodedSegment.append(delims);
            }
            pathWithEncoding = pathWithEncoding.append(encodedSegment.toString());
        }
        return pathWithEncoding;
    }

    protected void executeModelVisitor(List eResources, ModelVisitor visitor) throws ModelWorkspaceException {
        ModelVisitorProcessor processor = new ModelVisitorProcessor(visitor);
        Iterator i2 = eResources.iterator();
        while (i2.hasNext()) {
            Resource r2 = (Resource)i2.next();
            if (r2 == null) continue;
            try {
                processor.walk(r2, 2);
            }
            catch (ModelerCoreException err) {
                throw new ModelWorkspaceException(err);
            }
        }
    }
}

