/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.vdb.internal.edit;

import com.metamatrix.core.id.IDGenerator;
import com.metamatrix.core.id.InvalidIDException;
import com.metamatrix.core.id.ObjectID;
import com.metamatrix.core.util.ArgCheck;
import com.metamatrix.core.util.Assertion;
import com.metamatrix.core.util.StringUtil;
import com.metamatrix.modeler.core.ModelerCore;
import com.metamatrix.modeler.core.ModelerCoreException;
import com.metamatrix.modeler.core.container.Container;
import com.metamatrix.modeler.core.workspace.ModelResource;
import com.metamatrix.modeler.core.workspace.ModelWorkspace;
import com.metamatrix.modeler.core.workspace.ModelWorkspaceException;
import com.metamatrix.modeler.internal.core.workspace.WorkspaceResourceFinderUtil;
import com.metamatrix.vdb.edit.VdbEditException;
import com.metamatrix.vdb.edit.VdbEditPlugin;
import com.metamatrix.vdb.edit.manifest.ModelReference;
import com.metamatrix.vdb.internal.edit.VdbInputResourceFinder;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceVisitor;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;

public class WsVdbInputResourceFinder
implements VdbInputResourceFinder {
    private static final int UUID_STRING_LENGTH = 43;
    private Container cntr;

    public WsVdbInputResourceFinder() {
        try {
            this.cntr = ModelerCore.getModelContainer();
        }
        catch (CoreException e2) {
            ModelerCore.Util.log(e2);
        }
    }

    public Resource getEmfResource(IPath modelPath) throws VdbEditException {
        ArgCheck.isNotNull(modelPath);
        this.assertEclipseRuntime();
        Resource eResource = null;
        IResource iResource = ResourcesPlugin.getWorkspace().getRoot().getFile(modelPath);
        if (iResource == null) {
            iResource = WorkspaceResourceFinderUtil.findIResource(((Object)modelPath).toString());
        }
        if (iResource != null) {
            eResource = this.getEmfResource(iResource);
        }
        URI modelUri = URI.createURI(((Object)modelPath).toString());
        if (eResource == null) {
            eResource = this.cntr.getResource(modelUri, false);
        }
        if (eResource == null) {
            String modelUriString = URI.decode(modelUri.toString());
            Iterator iter = this.cntr.getResources().iterator();
            while (iter.hasNext()) {
                Resource rsrc = (Resource)iter.next();
                if (!URI.decode(rsrc.getURI().toString()).endsWith(modelUriString)) continue;
                eResource = rsrc;
                break;
            }
        }
        return eResource;
    }

    public Resource getEmfResource(ModelReference modelRef) throws VdbEditException {
        IPath modelPath;
        ObjectID uuid;
        ArgCheck.isNotNull(modelRef);
        this.assertEclipseRuntime();
        Resource eResource = null;
        String stringifiedUuid = modelRef.getUuid();
        if (!StringUtil.isEmpty(stringifiedUuid) && stringifiedUuid.startsWith("mmuuid") && (uuid = this.stringToObjectID(stringifiedUuid)) != null) {
            eResource = this.cntr.getResourceFinder().findByUUID(uuid, false);
        }
        String location = modelRef.getModelLocation();
        if (eResource == null && !StringUtil.isEmpty(location) && (eResource = this.getEmfResource(modelPath = new Path(location).makeAbsolute())) == null) {
            String name = modelPath.lastSegment();
            IResource[] iResources = WorkspaceResourceFinderUtil.findIResourceByName(name);
            IResource iResource = null;
            if (iResources.length == 1) {
                iResource = iResources[0];
            } else if (iResources.length > 1) {
                String projectName = modelPath.segment(0);
                for (int i2 = 0; i2 != iResources.length; ++i2) {
                    if (!projectName.equals(iResources[i2].getFullPath().segment(0))) continue;
                    iResource = iResources[i2];
                    break;
                }
                if (iResource == null) {
                    iResource = iResources[0];
                }
            }
            if (iResource != null) {
                eResource = this.getEmfResource(iResource);
            }
        }
        return eResource;
    }

    public InputStream getEmfResourceStream(Resource emfResource) throws VdbEditException {
        File f2;
        ArgCheck.isNotNull(emfResource);
        this.assertEclipseRuntime();
        if (emfResource.getURI().isFile() && (f2 = new File(emfResource.getURI().toFileString())) != null && f2.exists()) {
            try {
                return new FileInputStream(f2);
            }
            catch (FileNotFoundException e2) {
                throw new VdbEditException(e2);
            }
        }
        return null;
    }

    public IPath getEmfResourcePath(Resource emfResource) throws VdbEditException {
        if (emfResource != null && emfResource.getURI() != null) {
            this.assertEclipseRuntime();
            URI resourceUri = emfResource.getURI();
            String resourceUriString = resourceUri.isFile() ? resourceUri.toFileString() : URI.decode(resourceUri.toString());
            resourceUriString = new Path(resourceUriString).toString();
            if (WorkspaceResourceFinderUtil.isGlobalResource(resourceUriString)) {
                Object[] params = new Object[]{resourceUriString};
                String msg = VdbEditPlugin.Util.getString("VdbInputResourceFinder.unable_to_return_an_path_for_the_global_resource", params);
                throw new VdbEditException(msg);
            }
            FileResourceCollectorVisitor visitor = new FileResourceCollectorVisitor();
            IWorkspaceRoot wsRoot = ResourcesPlugin.getWorkspace().getRoot();
            IProject[] projects = wsRoot.getProjects();
            for (int i2 = 0; i2 < projects.length; ++i2) {
                try {
                    projects[i2].accept(visitor);
                    continue;
                }
                catch (CoreException e2) {
                    // empty catch block
                }
            }
            IFile[] fileResources = visitor.getFileResources();
            for (int i3 = 0; i3 < fileResources.length; ++i3) {
                IFile fileResource = fileResources[i3];
                String resourceLocation = ((Object)fileResource.getLocation()).toString();
                if (!resourceUriString.endsWith(resourceLocation)) continue;
                return fileResource.getFullPath();
            }
        }
        return null;
    }

    protected void assertEclipseRuntime() throws VdbEditException {
        IWorkspace iworkspace = ResourcesPlugin.getWorkspace();
        if (iworkspace == null) {
            String msg = VdbEditPlugin.Util.getString("VdbInputResourceFinder.Not_running_in_Eclipse_workspace;_use_a_different_ResourceFinder");
            throw new VdbEditException(msg);
        }
    }

    protected ObjectID stringToObjectID(String uuidString) {
        if (uuidString == null || uuidString.length() < 43) {
            return null;
        }
        ObjectID uuid = null;
        try {
            uuid = IDGenerator.getInstance().stringToObject(uuidString, "mmuuid");
        }
        catch (InvalidIDException e2) {
            VdbEditPlugin.Util.log(4, e2.getMessage());
        }
        return uuid;
    }

    protected Resource getEmfResource(IResource iResource) throws VdbEditException {
        Resource eResource = null;
        if (iResource != null) {
            ModelWorkspace workspace = ModelerCore.getModelWorkspace();
            ModelResource mResource = workspace.findModelResource(iResource);
            if (mResource != null) {
                try {
                    eResource = mResource.getEmfResource();
                    Assertion.isNotNull(eResource);
                }
                catch (ModelWorkspaceException e2) {
                    throw new VdbEditException(e2);
                }
            }
            URI location = null;
            if (iResource.getLocation() != null && iResource.getLocation().toFile().exists()) {
                location = URI.createFileURI(iResource.getLocation().toOSString());
            } else if (iResource.getFullPath().toFile().exists()) {
                location = URI.createFileURI(iResource.getFullPath().toOSString());
            }
            if (location != null) {
                try {
                    eResource = this.cntr.getOrCreateResource(location);
                }
                catch (ModelerCoreException e3) {
                    ModelerCore.Util.log(e3);
                }
            }
        }
        return eResource;
    }

    private static class FileResourceCollectorVisitor
    implements IResourceVisitor {
        private List resources = new ArrayList();

        public boolean visit(IResource resource) throws CoreException {
            if (resource.exists() && resource instanceof IFile) {
                this.resources.add(resource);
            }
            return true;
        }

        public IFile[] getFileResources() {
            return this.resources.toArray(new IFile[this.resources.size()]);
        }
    }
}

