/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.vdb.internal.edit;

import com.metamatrix.core.id.ObjectID;
import com.metamatrix.core.util.ArgCheck;
import com.metamatrix.metamodels.core.ModelAnnotation;
import com.metamatrix.metamodels.core.ModelType;
import com.metamatrix.modeler.core.util.ModelContents;
import com.metamatrix.modeler.internal.core.resource.EmfResource;
import com.metamatrix.vdb.edit.VdbGenerationContext;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import org.eclipse.emf.common.util.EMap;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.xsd.XSDSchema;
import org.eclipse.xsd.util.XSDResourceImpl;

public class VdbGenerationModelHelper
implements VdbGenerationContext.ModelHelper {
    private final Map modelNameByResource;
    private final Map modelPathByResource;
    private final Map modelVisibilityByResource;

    public VdbGenerationModelHelper(Map modelNameByResource, Map modelPathByResource, Map modelVisibilityByResource) {
        ArgCheck.isNotNull(modelNameByResource);
        ArgCheck.isNotNull(modelPathByResource);
        this.modelNameByResource = modelNameByResource;
        this.modelPathByResource = modelPathByResource;
        this.modelVisibilityByResource = modelVisibilityByResource;
    }

    public String getUuid(Resource model) {
        ArgCheck.isNotNull(model);
        ObjectID id = this.getObjectId(model);
        return ((Object)id).toString();
    }

    public ObjectID getObjectId(Resource model) {
        EmfResource emfResource;
        ModelAnnotation modelAnn;
        if (model instanceof EmfResource && (modelAnn = (emfResource = (EmfResource)model).getModelAnnotation()) != null) {
            return modelAnn.getObjectId();
        }
        return null;
    }

    public String getName(Resource model) {
        return (String)this.modelNameByResource.get(model);
    }

    public String getPath(Resource model) {
        return (String)this.modelPathByResource.get(model);
    }

    public String getDescription(Resource model) {
        if (model instanceof EmfResource) {
            EmfResource emfResource = (EmfResource)model;
            ModelAnnotation modelAnn = emfResource.getModelAnnotation();
            if (modelAnn != null) {
                return modelAnn.getDescription();
            }
        } else if (model instanceof XSDResourceImpl) {
            // empty if block
        }
        return null;
    }

    public String getPrimaryMetamodelUri(Resource model) {
        ModelAnnotation modelAnnotation;
        EmfResource emfResource;
        ModelContents contents;
        if (model instanceof EmfResource && (contents = (emfResource = (EmfResource)model).getModelContents()) != null && (modelAnnotation = contents.getModelAnnotation()) != null) {
            return modelAnnotation.getPrimaryMetamodelUri();
        }
        if (model instanceof XSDResourceImpl) {
            return "http://www.eclipse.org/xsd/2002/XSD";
        }
        return null;
    }

    /*
     * Enabled aggressive block sorting
     */
    public String getTargetNamespaceUri(Resource model) {
        if (model instanceof EmfResource) {
            EmfResource emfResource = (EmfResource)model;
            ModelAnnotation modelAnn = emfResource.getModelAnnotation();
            if (modelAnn == null) return null;
            return null;
        }
        if (!(model instanceof XSDResourceImpl)) return null;
        XSDSchema schema = ((XSDResourceImpl)model).getSchema();
        if (schema == null) return null;
        return schema.getTargetNamespace();
    }

    public Properties getProperties(Resource model) {
        ModelAnnotation modelAnnotation;
        EmfResource emfResource;
        ModelContents contents;
        ArgCheck.isNotNull(model);
        Properties properties = new Properties();
        if (model instanceof EmfResource && (contents = (emfResource = (EmfResource)model).getModelContents()) != null && (modelAnnotation = contents.getModelAnnotation()) != null) {
            EMap props = modelAnnotation.getTags();
            Iterator iter = props.iterator();
            while (iter.hasNext()) {
                Map.Entry entry = (Map.Entry)iter.next();
                Object key = entry.getKey();
                Object value = entry.getValue();
                properties.put(key, value);
            }
        }
        return properties;
    }

    public VdbGenerationContext.ModelType getModelType(Resource model) {
        ModelAnnotation modelAnnotation;
        EmfResource emfResource;
        ModelContents contents;
        ArgCheck.isNotNull(model);
        ModelType type = null;
        if (model instanceof EmfResource && (contents = (emfResource = (EmfResource)model).getModelContents()) != null && (modelAnnotation = contents.getModelAnnotation()) != null) {
            type = modelAnnotation.getModelType();
        }
        if (model instanceof XSDResourceImpl) {
            type = ModelType.TYPE_LITERAL;
        }
        if (type == null) {
            return VdbGenerationContext.ModelType.UNKNOWN;
        }
        return VdbGenerationContext.ModelType.getModelType(type);
    }

    public boolean isVisible(Resource model) {
        Boolean isVisible = (Boolean)this.modelVisibilityByResource.get(model);
        return isVisible != null ? isVisible : true;
    }
}

